/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.jpa.util.BaseIterator;
import java.io.Closeable;
import java.util.Iterator;
import org.apache.commons.lang3.Validate;
import org.hibernate.ScrollableResults;

public class ScrollableResultsIterator<T>
extends BaseIterator<T>
implements Iterator<T>,
Closeable {
    private boolean hasNext;
    private T myNext;
    private ScrollableResults myScroll;

    public ScrollableResultsIterator(ScrollableResults theScroll) {
        this.myScroll = theScroll;
    }

    private void ensureHaveNext() {
        if (this.myNext == null) {
            if (this.myScroll.next()) {
                this.hasNext = true;
                this.myNext = this.myScroll.get();
            } else {
                this.hasNext = false;
            }
        }
    }

    @Override
    public boolean hasNext() {
        this.ensureHaveNext();
        return this.hasNext;
    }

    @Override
    public T next() {
        this.ensureHaveNext();
        Validate.isTrue((boolean)this.hasNext);
        T next = this.myNext;
        this.myNext = null;
        return next;
    }

    @Override
    public void close() {
        if (this.myScroll != null) {
            this.myScroll.close();
            this.myScroll = null;
        }
    }
}

