/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch2;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.pid.IResourcePidList;
import ca.uhn.fhir.jpa.api.pid.IResourcePidStream;
import ca.uhn.fhir.jpa.api.pid.StreamTemplate;
import ca.uhn.fhir.jpa.api.pid.TypedResourcePid;
import ca.uhn.fhir.jpa.api.pid.TypedResourceStream;
import ca.uhn.fhir.jpa.api.svc.IBatch2DaoSvc;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.DateRangeUtil;
import ca.uhn.fhir.util.Logs;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.springframework.transaction.support.TransactionOperations;

public class Batch2DaoSvcImpl
implements IBatch2DaoSvc {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    private final IResourceTableDao myResourceTableDao;
    private final MatchUrlService myMatchUrlService;
    private final DaoRegistry myDaoRegistry;
    private final FhirContext myFhirContext;
    private final IHapiTransactionService myTransactionService;

    public boolean isAllResourceTypeSupported() {
        return true;
    }

    public Batch2DaoSvcImpl(IResourceTableDao theResourceTableDao, MatchUrlService theMatchUrlService, DaoRegistry theDaoRegistry, FhirContext theFhirContext, IHapiTransactionService theTransactionService) {
        this.myResourceTableDao = theResourceTableDao;
        this.myMatchUrlService = theMatchUrlService;
        this.myDaoRegistry = theDaoRegistry;
        this.myFhirContext = theFhirContext;
        this.myTransactionService = theTransactionService;
    }

    public IResourcePidStream fetchResourceIdStream(Date theStart, Date theEnd, RequestPartitionId theRequestPartitionId, String theUrl) {
        if (StringUtils.isBlank((CharSequence)theUrl)) {
            return this.makeStreamResult(theRequestPartitionId, () -> this.streamResourceIdsNoUrl(theStart, theEnd, theRequestPartitionId));
        }
        return this.makeStreamResult(theRequestPartitionId, () -> this.streamResourceIdsWithUrl(theStart, theEnd, theUrl, theRequestPartitionId));
    }

    private Stream<TypedResourcePid> streamResourceIdsWithUrl(Date theStart, Date theEnd, String theUrl, RequestPartitionId theRequestPartitionId) {
        Batch2DaoSvcImpl.validateUrl(theUrl);
        SearchParameterMap searchParamMap = this.parseQuery(theUrl);
        searchParamMap.setLastUpdated(DateRangeUtil.narrowDateRange((DateRangeParam)searchParamMap.getLastUpdated(), (Date)theStart, (Date)theEnd));
        String resourceType = theUrl.substring(0, theUrl.indexOf(63));
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
        SystemRequestDetails request = new SystemRequestDetails().setRequestPartitionId(theRequestPartitionId);
        return dao.searchForIdStream(searchParamMap, (RequestDetails)request, null).map(pid -> new TypedResourcePid(resourceType, pid));
    }

    private static TypedResourcePid typedPidFromQueryArray(Object[] thePidTypeDateArray) {
        String resourceType = (String)thePidTypeDateArray[1];
        Long pid = (Long)thePidTypeDateArray[0];
        return new TypedResourcePid(resourceType, (IResourcePersistentId)JpaPid.fromId((Long)pid));
    }

    @Nonnull
    private TypedResourceStream makeStreamResult(RequestPartitionId theRequestPartitionId, Supplier<Stream<TypedResourcePid>> streamSupplier) {
        IHapiTransactionService.IExecutionBuilder txSettings = this.myTransactionService.withSystemRequest().withRequestPartitionId(theRequestPartitionId);
        StreamTemplate streamTemplate = StreamTemplate.fromSupplier(streamSupplier).withTransactionAdvice((TransactionOperations)txSettings);
        return new TypedResourceStream(theRequestPartitionId, streamTemplate);
    }

    @Nonnull
    private Stream<TypedResourcePid> streamResourceIdsNoUrl(Date theStart, Date theEnd, RequestPartitionId theRequestPartitionId) {
        Stream<Object[]> rowStream;
        if (theRequestPartitionId == null || theRequestPartitionId.isAllPartitions()) {
            ourLog.debug("Search for resources - all partitions");
            rowStream = this.myResourceTableDao.streamIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldest(theStart, theEnd);
        } else if (theRequestPartitionId.isDefaultPartition()) {
            ourLog.debug("Search for resources - default partition");
            rowStream = this.myResourceTableDao.streamIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldestForDefaultPartition(theStart, theEnd);
        } else {
            ourLog.debug("Search for resources - partition {}", (Object)theRequestPartitionId);
            rowStream = this.myResourceTableDao.streamIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldestForPartitionIds(theStart, theEnd, theRequestPartitionId.getPartitionIds());
        }
        return rowStream.map(Batch2DaoSvcImpl::typedPidFromQueryArray);
    }

    @Deprecated(since="6.11", forRemoval=true)
    public IResourcePidList fetchResourceIdsPage(Date theStart, Date theEnd, @Nullable RequestPartitionId theRequestPartitionId, @Nullable String theUrl) {
        Validate.isTrue((boolean)false, (String)"Unimplemented", (Object[])new Object[0]);
        return null;
    }

    private static void validateUrl(@Nonnull String theUrl) {
        if (!theUrl.contains("?")) {
            throw new InternalErrorException(Msg.code((int)2422) + "this should never happen: URL is missing a '?'");
        }
    }

    @Nonnull
    private SearchParameterMap parseQuery(String theUrl) {
        String resourceType = theUrl.substring(0, theUrl.indexOf(63));
        RuntimeResourceDefinition def = this.myFhirContext.getResourceDefinition(resourceType);
        SearchParameterMap searchParamMap = this.myMatchUrlService.translateMatchUrl(theUrl, def, new MatchUrlService.Flag[0]);
        searchParamMap.setSort(new SortSpec("_lastUpdated").setChain(new SortSpec("_pid")));
        searchParamMap.setLoadSynchronousUpTo(Integer.valueOf(Integer.MAX_VALUE));
        return searchParamMap;
    }
}

