/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.ParserOptions;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

public class FhirContextR4Config {
    public static final String DEFAULT_PRESERVE_VERSION_REFS_DSTU2 = "AuditEvent.object.reference";
    public static final String DEFAULT_PRESERVE_VERSION_REFS_DSTU3 = "AuditEvent.entity.reference";
    public static final String DEFAULT_PRESERVE_VERSION_REFS_R4_AND_LATER = "AuditEvent.entity.what";

    @Bean(name={"primaryFhirContext"})
    @Primary
    public FhirContext fhirContextR4() {
        FhirContext retVal = FhirContext.forR4();
        FhirContextR4Config.configureFhirContext(retVal);
        return retVal;
    }

    public static FhirContext configureFhirContext(FhirContext theFhirContext) {
        ParserOptions parserOptions = theFhirContext.getParserOptions();
        if (theFhirContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
            parserOptions.setDontStripVersionsFromReferencesAtPaths(new String[]{DEFAULT_PRESERVE_VERSION_REFS_DSTU2});
        } else if (theFhirContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU3)) {
            parserOptions.setDontStripVersionsFromReferencesAtPaths(new String[]{DEFAULT_PRESERVE_VERSION_REFS_DSTU3});
        } else {
            parserOptions.setDontStripVersionsFromReferencesAtPaths(new String[]{DEFAULT_PRESERVE_VERSION_REFS_R4_AND_LATER});
        }
        IRestfulClientFactory clientFactory = theFhirContext.getRestfulClientFactory();
        clientFactory.setPoolMaxPerRoute(1000);
        clientFactory.setPoolMaxTotal(1000);
        return theFhirContext;
    }
}

