/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config.r5;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.IDaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.config.GeneratedDaoAndResourceProviderConfigR5;
import ca.uhn.fhir.jpa.config.JpaConfig;
import ca.uhn.fhir.jpa.config.r5.FhirContextR5Config;
import ca.uhn.fhir.jpa.dao.ITransactionProcessorVersionAdapter;
import ca.uhn.fhir.jpa.dao.r5.FhirSystemDaoR5;
import ca.uhn.fhir.jpa.dao.r5.TransactionProcessorVersionAdapterR5;
import ca.uhn.fhir.jpa.graphql.GraphQLProvider;
import ca.uhn.fhir.jpa.graphql.GraphQLProviderWithIntrospection;
import ca.uhn.fhir.jpa.provider.JpaSystemProvider;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import ca.uhn.fhir.jpa.term.TermVersionAdapterSvcR5;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermLoaderSvc;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.utilities.graphql.IGraphQLStorageServices;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@Import(value={FhirContextR5Config.class, GeneratedDaoAndResourceProviderConfigR5.class, JpaConfig.class})
public class JpaR5Config {
    @Bean
    public ITermVersionAdapterSvc terminologyVersionAdapterSvc() {
        return new TermVersionAdapterSvcR5();
    }

    @Bean
    public ITransactionProcessorVersionAdapter transactionProcessorVersionFacade() {
        return new TransactionProcessorVersionAdapterR5();
    }

    @Bean(name={"myGraphQLProvider"})
    @Lazy
    public GraphQLProvider graphQLProvider(FhirContext theFhirContext, IGraphQLStorageServices theGraphqlStorageServices, IValidationSupport theValidationSupport, ISearchParamRegistry theSearchParamRegistry, IDaoRegistry theDaoRegistry) {
        return new GraphQLProviderWithIntrospection(theFhirContext, theValidationSupport, theGraphqlStorageServices, theSearchParamRegistry, theDaoRegistry);
    }

    @Bean(name={"mySystemDaoR5"})
    public IFhirSystemDao<Bundle, Meta> systemDaoR5() {
        FhirSystemDaoR5 retVal = new FhirSystemDaoR5();
        return retVal;
    }

    @Bean(name={"mySystemProviderR5"})
    public JpaSystemProvider<Bundle, Meta> systemProviderR5(FhirContext theFhirContext) {
        JpaSystemProvider<Bundle, Meta> retVal = new JpaSystemProvider<Bundle, Meta>();
        retVal.setContext(theFhirContext);
        retVal.setDao(this.systemDaoR5());
        return retVal;
    }

    @Bean
    public ITermLoaderSvc terminologyLoaderService(ITermDeferredStorageSvc theDeferredStorageSvc, ITermCodeSystemStorageSvc theCodeSystemStorageSvc) {
        return new TermLoaderSvcImpl(theDeferredStorageSvc, theCodeSystemStorageSvc);
    }
}

