/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.TransactionProcessor;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.dao.expunge.ExpungeService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProviderFactory;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.jpa.util.ResourceCountCache;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseHapiFhirSystemDao<T extends IBaseBundle, MT>
extends BaseStorageDao
implements IFhirSystemDao<T, MT> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseHapiFhirSystemDao.class);
    public ResourceCountCache myResourceCountsCache;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private TransactionProcessor myTransactionProcessor;
    @Autowired
    private ApplicationContext myApplicationContext;
    @Autowired
    private ExpungeService myExpungeService;
    @Autowired
    private IResourceTableDao myResourceTableDao;
    @Autowired
    private PersistedJpaBundleProviderFactory myPersistedJpaBundleProviderFactory;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperService;
    @Autowired
    private IHapiTransactionService myTransactionService;

    @VisibleForTesting
    public void setTransactionProcessorForUnitTest(TransactionProcessor theTransactionProcessor) {
        this.myTransactionProcessor = theTransactionProcessor;
    }

    @Transactional(propagation=Propagation.NEVER)
    public ExpungeOutcome expunge(ExpungeOptions theExpungeOptions, RequestDetails theRequestDetails) {
        this.validateExpungeEnabled(theExpungeOptions);
        return this.myExpungeService.expunge(null, null, theExpungeOptions, theRequestDetails);
    }

    private void validateExpungeEnabled(ExpungeOptions theExpungeOptions) {
        if (!this.getStorageSettings().isExpungeEnabled()) {
            throw new MethodNotAllowedException(Msg.code((int)2080) + "$expunge is not enabled on this server");
        }
        if (theExpungeOptions.isExpungeEverything() && !this.getStorageSettings().isAllowMultipleDelete()) {
            throw new MethodNotAllowedException(Msg.code((int)2081) + "Multiple delete is not enabled on this server");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Long> getResourceCounts() {
        HashMap<String, Long> retVal = new HashMap<String, Long>();
        List<Map<?, ?>> counts = this.myResourceTableDao.getResourceCounts();
        for (Map<?, ?> next : counts) {
            retVal.put(next.get("type").toString(), Long.parseLong(next.get("count").toString()));
        }
        return retVal;
    }

    @Nullable
    public Map<String, Long> getResourceCountsFromCache() {
        if (this.myResourceCountsCache == null) {
            this.myResourceCountsCache = (ResourceCountCache)this.myApplicationContext.getBean("myResourceCountsCache", ResourceCountCache.class);
        }
        return this.myResourceCountsCache.get();
    }

    public IBundleProvider history(Date theSince, Date theUntil, Integer theOffset, RequestDetails theRequestDetails) {
        StopWatch w = new StopWatch();
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForHistory(theRequestDetails, null, null);
        IBundleProvider retVal = (IBundleProvider)this.myTransactionService.withRequest(theRequestDetails).withRequestPartitionId(requestPartitionId).execute(() -> this.myPersistedJpaBundleProviderFactory.history(theRequestDetails, null, null, theSince, theUntil, theOffset, requestPartitionId));
        ourLog.info("Processed global history in {}ms", (Object)w.getMillisAndRestart());
        return retVal;
    }

    public T transaction(RequestDetails theRequestDetails, T theRequest) {
        HapiTransactionService.noTransactionAllowed();
        return (T)this.myTransactionProcessor.transaction(theRequestDetails, (IBaseBundle)theRequest, false);
    }

    public T transactionNested(RequestDetails theRequestDetails, T theRequest) {
        HapiTransactionService.requireTransaction();
        return (T)this.myTransactionProcessor.transaction(theRequestDetails, (IBaseBundle)theRequest, true);
    }

    public <P extends IResourcePersistentId> void preFetchResources(List<P> theResolvedIds, boolean thePreFetchIndexes) {
        HapiTransactionService.requireTransaction();
        List pids = theResolvedIds.stream().map(t -> ((JpaPid)t).getId()).collect(Collectors.toList());
        new QueryChunker().chunk(pids, idChunk -> {
            if (!idChunk.isEmpty()) {
                List<ResourceTable> entityChunk = this.prefetchResourceTableHistoryAndProvenance((List<Long>)idChunk);
                if (thePreFetchIndexes) {
                    this.prefetchByField("string", "myParamsString", ResourceTable::isParamsStringPopulated, entityChunk);
                    this.prefetchByField("token", "myParamsToken", ResourceTable::isParamsTokenPopulated, entityChunk);
                    this.prefetchByField("date", "myParamsDate", ResourceTable::isParamsDatePopulated, entityChunk);
                    this.prefetchByField("quantity", "myParamsQuantity", ResourceTable::isParamsQuantityPopulated, entityChunk);
                    this.prefetchByField("resourceLinks", "myResourceLinks", ResourceTable::isHasLinks, entityChunk);
                    this.prefetchByJoinClause("tags", "LEFT JOIN FETCH r.myTags t LEFT JOIN FETCH t.myTag", BaseHasResource::isHasTags, entityChunk);
                    this.prefetchByField("comboStringUnique", "myParamsComboStringUnique", ResourceTable::isParamsComboStringUniquePresent, entityChunk);
                    this.prefetchByField("comboTokenNonUnique", "myParamsComboTokensNonUnique", ResourceTable::isParamsComboTokensNonUniquePresent, entityChunk);
                    if (this.myStorageSettings.getIndexMissingFields() == StorageSettings.IndexEnabledEnum.ENABLED) {
                        this.prefetchByField("searchParamPresence", "mySearchParamPresents", r -> true, entityChunk);
                    }
                }
            }
        });
    }

    @Nonnull
    private List<ResourceTable> prefetchResourceTableHistoryAndProvenance(List<Long> idChunk) {
        assert (idChunk.size() < 800) : "assume pre-chunked";
        Query query = this.myEntityManager.createQuery("select r, h  FROM ResourceTable r  LEFT JOIN fetch ResourceHistoryTable h       on r.myVersion = h.myResourceVersion and r.id = h.myResourceId  left join fetch h.myProvenance  WHERE r.myId IN ( :IDS ) ");
        query.setParameter("IDS", idChunk);
        Stream queryResultStream = query.getResultStream();
        return queryResultStream.map(nextPair -> {
            ResourceTable result = (ResourceTable)nextPair[0];
            ResourceHistoryTable currentVersion = (ResourceHistoryTable)nextPair[1];
            result.setCurrentVersionEntity(currentVersion);
            return result;
        }).collect(Collectors.toList());
    }

    private void prefetchByField(String theDescription, String theJpaFieldName, Predicate<ResourceTable> theEntityPredicate, List<ResourceTable> theEntities) {
        String joinClause = "LEFT JOIN FETCH r." + theJpaFieldName;
        this.prefetchByJoinClause(theDescription, joinClause, theEntityPredicate, theEntities);
    }

    private void prefetchByJoinClause(String theDescription, String theJoinClause, Predicate<ResourceTable> theEntityPredicate, List<ResourceTable> theEntities) {
        List idSubset = theEntities.stream().filter(theEntityPredicate).map(ResourceTable::getId).collect(Collectors.toList());
        if (idSubset.isEmpty()) {
            return;
        }
        String jqlQuery = "FROM ResourceTable r " + theJoinClause + " WHERE r.myId IN ( :IDS )";
        TypedQuery query = this.myEntityManager.createQuery(jqlQuery, ResourceTable.class);
        query.setParameter("IDS", idSubset);
        List indexFetchOutcome = query.getResultList();
        ourLog.debug("Pre-fetched {} {} indexes", (Object)indexFetchOutcome.size(), (Object)theDescription);
    }

    @Nullable
    protected String getResourceName() {
        return null;
    }

    protected IInterceptorBroadcaster getInterceptorBroadcaster() {
        return this.myInterceptorBroadcaster;
    }

    protected JpaStorageSettings getStorageSettings() {
        return this.myStorageSettings;
    }

    public FhirContext getContext() {
        return this.myFhirContext;
    }

    @VisibleForTesting
    public void setStorageSettingsForUnitTest(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }
}

