/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.primitive.BooleanDt;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseCoding;

public class CodingSpy {
    final Map<Class, Field> mySpies = new ConcurrentHashMap<Class, Field>();

    public Boolean getBooleanObject(IBaseCoding theValue) {
        Field spy = this.getSpy(theValue);
        try {
            Object o = spy.get(theValue);
            if (o == null) {
                return null;
            }
            if (o instanceof BooleanDt) {
                BooleanDt booleanDt = (BooleanDt)o;
                return (Boolean)booleanDt.getValue();
            }
            if (o instanceof IBaseBooleanDatatype) {
                IBaseBooleanDatatype booleanValue = (IBaseBooleanDatatype)o;
                return (Boolean)booleanValue.getValue();
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            throw new RuntimeException(Msg.code((int)2342) + "unsupported type :" + theValue.getClass().getName());
        }
        catch (IllegalAccessException theException) {
            throw new RuntimeException(Msg.code((int)2343) + "illegal access during reflection", theException);
        }
    }

    private Field getSpy(IBaseCoding theValue) {
        return this.mySpies.computeIfAbsent(theValue.getClass(), k -> CodingSpy.getFieldHandle(k));
    }

    private static Field getFieldHandle(Class k) {
        Field result = FieldUtils.getField((Class)k, (String)"userSelected", (boolean)true);
        if (result == null) {
            result = FieldUtils.getField((Class)k, (String)"myUserSelected", (boolean)true);
        }
        return result;
    }
}

