/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoSubscription;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.data.ISubscriptionTableDao;
import ca.uhn.fhir.jpa.entity.SubscriptionTable;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.model.dstu2.resource.Subscription;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import java.util.Date;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class FhirResourceDaoSubscriptionDstu2
extends BaseHapiFhirResourceDao<Subscription>
implements IFhirResourceDaoSubscription<Subscription> {
    @Autowired
    private ISubscriptionTableDao mySubscriptionTableDao;
    @Autowired
    private PlatformTransactionManager myTxManager;

    private void createSubscriptionTable(ResourceTable theEntity, Subscription theSubscription) {
        SubscriptionTable subscriptionEntity = new SubscriptionTable();
        subscriptionEntity.setCreated(new Date());
        subscriptionEntity.setSubscriptionResource(theEntity);
        this.myEntityManager.persist((Object)subscriptionEntity);
    }

    public Long getSubscriptionTablePidForSubscriptionResource(IIdType theId, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        ResourceTable entity = this.readEntityLatestVersion(theId, theRequest, theTransactionDetails);
        SubscriptionTable table = this.mySubscriptionTableDao.findOneByResourcePid(entity.getId());
        if (table == null) {
            return null;
        }
        return table.getId();
    }

    @Override
    protected void postPersist(ResourceTable theEntity, Subscription theSubscription, RequestDetails theRequestDetails) {
        super.postPersist(theEntity, theSubscription, theRequestDetails);
        this.createSubscriptionTable(theEntity, theSubscription);
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequest, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        ResourceTable retVal = super.updateEntity(theRequest, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        if (theDeletedTimestampOrNull != null) {
            this.mySubscriptionTableDao.deleteAllForSubscription((ResourceTable)theEntity);
        }
        return retVal;
    }
}

