/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.term.TermReadSvcUtil;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.sl.cache.Cache;
import ca.uhn.fhir.sl.cache.CacheFactory;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRED)
public class JpaPersistedResourceValidationSupport
implements IValidationSupport {
    private static final Logger ourLog = LoggerFactory.getLogger(JpaPersistedResourceValidationSupport.class);
    private final FhirContext myFhirContext;
    private final IBaseResource myNoMatch;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private ITermReadSvc myTermReadSvc;
    private Class<? extends IBaseResource> myCodeSystemType;
    private Class<? extends IBaseResource> myStructureDefinitionType;
    private Class<? extends IBaseResource> myValueSetType;
    private Cache<String, IBaseResource> myLoadCache = CacheFactory.build((long)TimeUnit.MINUTES.toMillis(1L), (long)1000L);

    public JpaPersistedResourceValidationSupport(FhirContext theFhirContext) {
        Validate.notNull((Object)theFhirContext);
        this.myFhirContext = theFhirContext;
        this.myNoMatch = (IBaseResource)this.myFhirContext.getResourceDefinition("Basic").newInstance();
    }

    public String getName() {
        return this.myFhirContext.getVersion().getVersion() + " JPA Validation Support";
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        if (TermReadSvcUtil.isLoincUnversionedCodeSystem(theSystem)) {
            Optional<IBaseResource> currentCSOpt = this.getCodeSystemCurrentVersion(new UriType(theSystem));
            if (!currentCSOpt.isPresent()) {
                ourLog.info("Couldn't find current version of CodeSystem: " + theSystem);
            }
            return currentCSOpt.orElse(null);
        }
        return this.fetchResource(this.myCodeSystemType, theSystem);
    }

    private Optional<IBaseResource> getCodeSystemCurrentVersion(UriType theUrl) {
        if (!theUrl.getValueAsString().contains("loinc")) {
            return Optional.empty();
        }
        return this.myTermReadSvc.readCodeSystemByForcedId("loinc");
    }

    public IBaseResource fetchValueSet(String theSystem) {
        if (TermReadSvcUtil.isLoincUnversionedValueSet(theSystem)) {
            Optional<IBaseResource> currentVSOpt = this.getValueSetCurrentVersion(new UriType(theSystem));
            return currentVSOpt.orElse(null);
        }
        return this.fetchResource(this.myValueSetType, theSystem);
    }

    private Optional<IBaseResource> getValueSetCurrentVersion(UriType theUrl) {
        Optional<String> vsIdOpt = TermReadSvcUtil.getValueSetId(theUrl.getValueAsString());
        if (!vsIdOpt.isPresent()) {
            return Optional.empty();
        }
        IFhirResourceDao valueSetResourceDao = this.myDaoRegistry.getResourceDao(this.myValueSetType);
        IBaseResource valueSet = valueSetResourceDao.read((IIdType)new IdDt("ValueSet", vsIdOpt.get()));
        return Optional.ofNullable(valueSet);
    }

    public IBaseResource fetchStructureDefinition(String theUrl) {
        return this.fetchResource(this.myStructureDefinitionType, theUrl);
    }

    @Nullable
    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        if (!this.myDaoRegistry.isResourceTypeSupported("StructureDefinition")) {
            return null;
        }
        IBundleProvider search = this.myDaoRegistry.getResourceDao("StructureDefinition").search(new SearchParameterMap().setLoadSynchronousUpTo(Integer.valueOf(1000)), (RequestDetails)new SystemRequestDetails());
        return search.getResources(0, 1000);
    }

    public <T extends IBaseResource> T fetchResource(@Nullable Class<T> theClass, String theUri) {
        if (StringUtils.isBlank((CharSequence)theUri)) {
            return null;
        }
        String key = theClass + " " + theUri;
        IBaseResource fetched = (IBaseResource)this.myLoadCache.get((Object)key, t -> this.doFetchResource(theClass, theUri));
        if (fetched == this.myNoMatch) {
            ourLog.debug("Invalidating cache entry for URI: {} since the result of the underlying query is empty", (Object)theUri);
            this.myLoadCache.invalidate((Object)key);
            return null;
        }
        return (T)fetched;
    }

    private <T extends IBaseResource> IBaseResource doFetchResource(@Nullable Class<T> theClass, String theUri) {
        IBundleProvider search;
        String resourceName;
        if (theClass == null) {
            Supplier[] fetchers = new Supplier[]{() -> this.doFetchResource(ValueSet.class, theUri), () -> this.doFetchResource(CodeSystem.class, theUri), () -> this.doFetchResource(StructureDefinition.class, theUri)};
            return Arrays.stream(fetchers).map(t -> (IBaseResource)t.get()).filter(t -> t != this.myNoMatch).findFirst().orElse(this.myNoMatch);
        }
        IdType id = new IdType(theUri);
        boolean localReference = false;
        if (!id.hasBaseUrl() && id.hasIdPart()) {
            localReference = true;
        }
        switch (resourceName = this.myFhirContext.getResourceType(theClass)) {
            case "ValueSet": {
                if (localReference) {
                    SearchParameterMap params = new SearchParameterMap();
                    params.setLoadSynchronousUpTo(Integer.valueOf(1));
                    params.add("_id", (IQueryParameterType)new StringParam(theUri));
                    search = this.myDaoRegistry.getResourceDao(resourceName).search(params);
                    if (search.size() != 0) break;
                    params = new SearchParameterMap();
                    params.setLoadSynchronousUpTo(Integer.valueOf(1));
                    params.add("url", (IQueryParameterType)new UriParam(theUri));
                    search = this.myDaoRegistry.getResourceDao(resourceName).search(params);
                    break;
                }
                int versionSeparator = theUri.lastIndexOf(124);
                SearchParameterMap params = new SearchParameterMap();
                params.setLoadSynchronousUpTo(Integer.valueOf(1));
                if (versionSeparator != -1) {
                    params.add("version", (IQueryParameterType)new TokenParam(theUri.substring(versionSeparator + 1)));
                    params.add("url", (IQueryParameterType)new UriParam(theUri.substring(0, versionSeparator)));
                } else {
                    params.add("url", (IQueryParameterType)new UriParam(theUri));
                }
                params.setSort(new SortSpec("_lastUpdated").setOrder(SortOrderEnum.DESC));
                search = this.myDaoRegistry.getResourceDao(resourceName).search(params);
                if (!search.isEmpty() || !this.myFhirContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) break;
                params = new SearchParameterMap();
                params.setLoadSynchronousUpTo(Integer.valueOf(1));
                if (versionSeparator != -1) {
                    params.add("version", (IQueryParameterType)new TokenParam(theUri.substring(versionSeparator + 1)));
                    params.add("system", (IQueryParameterType)new UriParam(theUri.substring(0, versionSeparator)));
                } else {
                    params.add("system", (IQueryParameterType)new UriParam(theUri));
                }
                params.setSort(new SortSpec("_lastUpdated").setOrder(SortOrderEnum.DESC));
                search = this.myDaoRegistry.getResourceDao(resourceName).search(params);
                break;
            }
            case "StructureDefinition": {
                String typeName;
                if (theUri.startsWith("http://hl7.org/fhir/StructureDefinition/") && this.myFhirContext.getElementDefinition(typeName = theUri.substring("http://hl7.org/fhir/StructureDefinition/".length())) != null) {
                    return this.myNoMatch;
                }
                SearchParameterMap params = new SearchParameterMap();
                params.setLoadSynchronousUpTo(Integer.valueOf(1));
                params.add("url", (IQueryParameterType)new UriParam(theUri));
                search = this.myDaoRegistry.getResourceDao("StructureDefinition").search(params);
                break;
            }
            case "Questionnaire": {
                SearchParameterMap params = new SearchParameterMap();
                params.setLoadSynchronousUpTo(Integer.valueOf(1));
                if (localReference || this.myFhirContext.getVersion().getVersion().isEquivalentTo(FhirVersionEnum.DSTU2)) {
                    params.add("_id", (IQueryParameterType)new StringParam(id.getIdPart()));
                } else {
                    params.add("url", (IQueryParameterType)new UriParam(id.getValue()));
                }
                search = this.myDaoRegistry.getResourceDao("Questionnaire").search(params);
                break;
            }
            case "CodeSystem": {
                int versionSeparator = theUri.lastIndexOf(124);
                SearchParameterMap params = new SearchParameterMap();
                params.setLoadSynchronousUpTo(Integer.valueOf(1));
                if (versionSeparator != -1) {
                    params.add("version", (IQueryParameterType)new TokenParam(theUri.substring(versionSeparator + 1)));
                    params.add("url", (IQueryParameterType)new UriParam(theUri.substring(0, versionSeparator)));
                } else {
                    params.add("url", (IQueryParameterType)new UriParam(theUri));
                }
                params.setSort(new SortSpec("_lastUpdated").setOrder(SortOrderEnum.DESC));
                search = this.myDaoRegistry.getResourceDao(resourceName).search(params);
                break;
            }
            case "ImplementationGuide": 
            case "SearchParameter": {
                SearchParameterMap params = new SearchParameterMap();
                params.setLoadSynchronousUpTo(Integer.valueOf(1));
                params.add("url", (IQueryParameterType)new UriParam(theUri));
                search = this.myDaoRegistry.getResourceDao(resourceName).search(params);
                break;
            }
            default: {
                SearchParameterMap params = new SearchParameterMap();
                params.setLoadSynchronousUpTo(Integer.valueOf(1));
                params.add("url", (IQueryParameterType)new UriParam(theUri));
                search = this.myDaoRegistry.getResourceDao(resourceName).search(params);
            }
        }
        Integer size = search.size();
        if (size == null || size == 0) {
            return this.myNoMatch;
        }
        if (size > 1) {
            ourLog.warn("Found multiple {} instances with URL search value of: {}", (Object)resourceName, (Object)theUri);
        }
        return (IBaseResource)search.getResources(0, 1).get(0);
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    @PostConstruct
    public void start() {
        this.myStructureDefinitionType = this.myFhirContext.getResourceDefinition("StructureDefinition").getImplementingClass();
        this.myValueSetType = this.myFhirContext.getResourceDefinition("ValueSet").getImplementingClass();
        this.myCodeSystemType = this.myFhirContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU2) ? this.myFhirContext.getResourceDefinition("CodeSystem").getImplementingClass() : this.myFhirContext.getResourceDefinition("ValueSet").getImplementingClass();
    }

    public void clearCaches() {
        this.myLoadCache.invalidateAll();
    }
}

