/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.LookupCodeRequest;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.api.dao.ReindexOutcome;
import ca.uhn.fhir.jpa.api.dao.ReindexParameters;
import ca.uhn.fhir.jpa.api.model.ReindexJobStatus;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.util.LogicUtil;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.DatatypeUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JpaResourceDaoCodeSystem<T extends IBaseResource>
extends BaseHapiFhirResourceDao<T>
implements IFhirResourceDaoCodeSystem<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(JpaResourceDaoCodeSystem.class);
    @Autowired
    protected ITermCodeSystemStorageSvc myTerminologyCodeSystemStorageSvc;
    @Autowired
    protected IIdHelperService myIdHelperService;
    @Autowired
    protected ITermDeferredStorageSvc myTermDeferredStorageSvc;
    @Autowired
    private IValidationSupport myValidationSupport;
    @Autowired
    private FhirContext myFhirContext;
    private FhirTerser myTerser;
    @Autowired
    private VersionCanonicalizer myVersionCanonicalizer;

    @Override
    @PostConstruct
    public void start() {
        super.start();
        this.myTerser = this.myFhirContext.newTerser();
    }

    public List<IIdType> findCodeSystemIdsContainingSystemAndCode(String theCode, String theSystem, RequestDetails theRequest) {
        List ids = this.searchForIds(new SearchParameterMap("code", (IQueryParameterType)new TokenParam(theSystem, theCode)), theRequest);
        ArrayList<IIdType> valueSetIds = new ArrayList<IIdType>();
        for (IResourcePersistentId next : ids) {
            IIdType id = this.myIdHelperService.translatePidIdToForcedId(this.myFhirContext, "CodeSystem", next);
            valueSetIds.add(id);
        }
        return valueSetIds;
    }

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, IBaseCoding theCoding, RequestDetails theRequestDetails) {
        return this.lookupCode(theCode, theSystem, theCoding, null, theRequestDetails);
    }

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, IBaseCoding theCoding, IPrimitiveType<String> theDisplayLanguage, RequestDetails theRequestDetails) {
        return this.lookupCode(theCode, theSystem, theCoding, theDisplayLanguage, CollectionUtils.emptyCollection(), theRequestDetails);
    }

    @Nonnull
    public IValidationSupport.LookupCodeResult lookupCode(IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, IBaseCoding theCoding, IPrimitiveType<String> theDisplayLanguage, Collection<IPrimitiveType<String>> thePropertyNames, RequestDetails theRequestDetails) {
        return JpaResourceDaoCodeSystem.doLookupCode(this.myFhirContext, this.myTerser, this.myValidationSupport, theCode, theSystem, theCoding, theDisplayLanguage, thePropertyNames);
    }

    public IFhirResourceDaoCodeSystem.SubsumesResult subsumes(IPrimitiveType<String> theCodeA, IPrimitiveType<String> theCodeB, IPrimitiveType<String> theSystem, IBaseCoding theCodingA, IBaseCoding theCodingB, RequestDetails theRequestDetails) {
        return this.myTerminologySvc.subsumes(theCodeA, theCodeB, theSystem, theCodingA, theCodingB);
    }

    @Override
    protected void preDelete(T theResourceToDelete, ResourceTable theEntityToDelete, RequestDetails theRequestDetails) {
        super.preDelete(theResourceToDelete, theEntityToDelete, theRequestDetails);
        this.myTermDeferredStorageSvc.deleteCodeSystemForResource(theEntityToDelete);
    }

    @Override
    public ReindexOutcome reindex(IResourcePersistentId thePid, ReindexParameters theReindexParameters, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        ReindexOutcome outcome = super.reindex(thePid, theReindexParameters, theRequest, theTransactionDetails);
        if (outcome.getWarnings().isEmpty()) {
            outcome.setHasPendingWork(true);
        }
        return outcome;
    }

    public ReindexJobStatus getReindexJobStatus() {
        boolean isQueueEmpty = this.myTermDeferredStorageSvc.isStorageQueueEmpty(true);
        ReindexJobStatus status = new ReindexJobStatus();
        status.setHasReindexWorkPending(!isQueueEmpty);
        if (status.isHasReindexWorkPending()) {
            this.myTermDeferredStorageSvc.saveDeferred();
        }
        return status;
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequest, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        ResourceTable retVal = super.updateEntity(theRequest, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        if (!retVal.isUnchangedInCurrentOperation()) {
            CodeSystem cs = this.myVersionCanonicalizer.codeSystemToCanonical(theResource);
            this.addPidToResource((IResourceLookup<JpaPid>)theEntity, (IBaseResource)cs);
            this.myTerminologyCodeSystemStorageSvc.storeNewCodeSystemVersionIfNeeded(cs, (ResourceTable)theEntity, theRequest);
        }
        return retVal;
    }

    @Nonnull
    public IValidationSupport.CodeValidationResult validateCode(IIdType theCodeSystemId, IPrimitiveType<String> theCodeSystemUrl, IPrimitiveType<String> theVersion, IPrimitiveType<String> theCode, IPrimitiveType<String> theDisplay, IBaseCoding theCoding, IBaseDatatype theCodeableConcept, RequestDetails theRequestDetails) {
        String display;
        String codeSystemUrl;
        CodeableConcept codeableConcept = this.myVersionCanonicalizer.codeableConceptToCanonical(theCodeableConcept);
        boolean haveCodeableConcept = codeableConcept != null && codeableConcept.getCoding().size() > 0;
        Coding coding = this.myVersionCanonicalizer.codingToCanonical(theCoding);
        boolean haveCoding = coding != null && !coding.isEmpty();
        String code = DatatypeUtil.toStringValue(theCode);
        boolean haveCode = StringUtils.isNotBlank((CharSequence)code);
        if (!(haveCodeableConcept || haveCoding || haveCode)) {
            throw new InvalidRequestException(Msg.code((int)906) + "No code, coding, or codeableConcept provided to validate.");
        }
        if (!LogicUtil.multiXor(haveCodeableConcept, haveCoding, haveCode)) {
            throw new InvalidRequestException(Msg.code((int)907) + "$validate-code can only validate (code) OR (coding) OR (codeableConcept)");
        }
        if (theCodeSystemId != null) {
            Object codeSystem = this.read(theCodeSystemId, theRequestDetails);
            codeSystemUrl = CommonCodeSystemsTerminologyService.getCodeSystemUrl((FhirContext)this.myFhirContext, codeSystem);
        } else if (StringUtils.isNotBlank((CharSequence)DatatypeUtil.toStringValue(theCodeSystemUrl))) {
            codeSystemUrl = DatatypeUtil.toStringValue(theCodeSystemUrl);
        } else {
            throw new InvalidRequestException(Msg.code((int)908) + "Either CodeSystem ID or CodeSystem identifier must be provided. Unable to validate.");
        }
        if (haveCodeableConcept) {
            IValidationSupport.CodeValidationResult anyValidation = null;
            for (int i = 0; i < codeableConcept.getCoding().size(); ++i) {
                IValidationSupport.CodeValidationResult nextValidation;
                Coding nextCoding = (Coding)codeableConcept.getCoding().get(i);
                if (nextCoding.hasSystem()) {
                    if (!codeSystemUrl.equalsIgnoreCase(nextCoding.getSystem())) {
                        throw new InvalidRequestException(Msg.code((int)909) + "Coding.system '" + nextCoding.getSystem() + "' does not equal with CodeSystem.url '" + codeSystemUrl + "'. Unable to validate.");
                    }
                    codeSystemUrl = nextCoding.getSystem();
                }
                code = nextCoding.getCode();
                String display2 = nextCoding.getDisplay();
                anyValidation = nextValidation = this.codeSystemValidateCode(codeSystemUrl, DatatypeUtil.toStringValue(theVersion), code, display2);
                if (!nextValidation.isOk()) continue;
                return nextValidation;
            }
            return anyValidation;
        }
        if (haveCoding) {
            if (coding.hasSystem()) {
                if (!codeSystemUrl.equalsIgnoreCase(coding.getSystem())) {
                    throw new InvalidRequestException(Msg.code((int)910) + "Coding.system '" + coding.getSystem() + "' does not equal with CodeSystem.url '" + codeSystemUrl + "'. Unable to validate.");
                }
                codeSystemUrl = coding.getSystem();
            }
            code = coding.getCode();
            display = coding.getDisplay();
            return this.codeSystemValidateCode(codeSystemUrl, DatatypeUtil.toStringValue(theVersion), code, display);
        }
        display = DatatypeUtil.toStringValue(theDisplay);
        return this.codeSystemValidateCode(codeSystemUrl, DatatypeUtil.toStringValue(theVersion), code, display);
    }

    private IValidationSupport.CodeValidationResult codeSystemValidateCode(String theCodeSystemUrl, String theVersion, String theCode, String theDisplay) {
        ValidationSupportContext context = new ValidationSupportContext(this.myValidationSupport);
        ConceptValidationOptions options = new ConceptValidationOptions();
        options.setValidateDisplay(StringUtils.isNotBlank((CharSequence)theDisplay));
        String codeSystemUrl = JpaResourceDaoCodeSystem.createVersionedSystemIfVersionIsPresent(theCodeSystemUrl, theVersion);
        IValidationSupport.CodeValidationResult retVal = this.myValidationSupport.validateCode(context, options, codeSystemUrl, theCode, theDisplay, null);
        if (retVal == null) {
            retVal = new IValidationSupport.CodeValidationResult();
            retVal.setMessage("Terminology service was unable to provide validation for " + codeSystemUrl + "#" + theCode);
        }
        return retVal;
    }

    public static IValidationSupport.LookupCodeResult doLookupCode(FhirContext theFhirContext, FhirTerser theFhirTerser, IValidationSupport theValidationSupport, IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, IBaseCoding theCoding, IPrimitiveType<String> theDisplayLanguage, Collection<IPrimitiveType<String>> thePropertyNames) {
        Object system;
        String code;
        boolean haveDisplayLanguage;
        boolean haveCoding = theCoding != null && StringUtils.isNotBlank((CharSequence)JpaResourceDaoCodeSystem.extractCodingSystem(theCoding)) && StringUtils.isNotBlank((CharSequence)JpaResourceDaoCodeSystem.extractCodingCode(theCoding));
        boolean haveCode = theCode != null && !theCode.isEmpty();
        boolean haveSystem = theSystem != null && !theSystem.isEmpty();
        boolean bl = haveDisplayLanguage = theDisplayLanguage != null && !theDisplayLanguage.isEmpty();
        if (!(haveCoding || haveSystem && haveCode)) {
            throw new InvalidRequestException(Msg.code((int)1126) + "No code, coding, or codeableConcept provided to validate");
        }
        boolean[] blArray = new boolean[2];
        blArray[0] = haveCoding;
        boolean bl2 = blArray[1] = haveSystem && haveCode;
        if (!LogicUtil.multiXor(blArray) || haveSystem != haveCode) {
            throw new InvalidRequestException(Msg.code((int)1127) + "$lookup can only validate (system AND code) OR (coding.system AND coding.code)");
        }
        if (haveCoding) {
            code = JpaResourceDaoCodeSystem.extractCodingCode(theCoding);
            system = JpaResourceDaoCodeSystem.extractCodingSystem(theCoding);
            String version = JpaResourceDaoCodeSystem.extractCodingVersion(theFhirContext, theFhirTerser, theCoding);
            if (StringUtils.isNotBlank((CharSequence)version)) {
                system = (String)system + "|" + version;
            }
        } else {
            code = (String)theCode.getValue();
            system = (String)theSystem.getValue();
        }
        String displayLanguage = null;
        if (haveDisplayLanguage) {
            displayLanguage = (String)theDisplayLanguage.getValue();
        }
        ourLog.info("Looking up {} / {}", system, (Object)code);
        Collection propertyNames = CollectionUtils.emptyIfNull(thePropertyNames).stream().map(IPrimitiveType::getValueAsString).collect(Collectors.toSet());
        if (theValidationSupport.isCodeSystemSupported(new ValidationSupportContext(theValidationSupport), (String)system)) {
            ourLog.info("Code system {} is supported", system);
            IValidationSupport.LookupCodeResult retVal = theValidationSupport.lookupCode(new ValidationSupportContext(theValidationSupport), new LookupCodeRequest((String)system, code, displayLanguage, propertyNames));
            if (retVal != null) {
                return retVal;
            }
        }
        return IValidationSupport.LookupCodeResult.notFound((String)system, (String)code);
    }

    private static String extractCodingSystem(IBaseCoding theCoding) {
        return theCoding.getSystem();
    }

    private static String extractCodingCode(IBaseCoding theCoding) {
        return theCoding.getCode();
    }

    private static String extractCodingVersion(FhirContext theFhirContext, FhirTerser theFhirTerser, IBaseCoding theCoding) {
        if (theFhirContext.getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
            return null;
        }
        return theFhirTerser.getSinglePrimitiveValueOrNull((IBase)theCoding, "version");
    }

    public static String createVersionedSystemIfVersionIsPresent(String theCodeSystemUrl, String theVersion) {
        Object codeSystemUrl = theCodeSystemUrl;
        if (StringUtils.isNotBlank((CharSequence)theVersion)) {
            codeSystemUrl = (String)codeSystemUrl + "|" + theVersion;
        }
        return codeSystemUrl;
    }
}

