/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoValueSet;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.JpaResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.provider.ValueSetOperationProvider;
import ca.uhn.fhir.jpa.search.autocomplete.ValueSetAutocompleteOptions;
import ca.uhn.fhir.jpa.util.LogicUtil;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.util.DatatypeUtil;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ValueSet;
import org.springframework.beans.factory.annotation.Autowired;

public class JpaResourceDaoValueSet<T extends IBaseResource>
extends BaseHapiFhirResourceDao<T>
implements IFhirResourceDaoValueSet<T> {
    @Autowired
    private IValidationSupport myValidationSupport;
    @Autowired
    private VersionCanonicalizer myVersionCanonicalizer;
    @Autowired(required=false)
    private IFulltextSearchSvc myFulltextSearch;

    public T expand(IIdType theId, ValueSetExpansionOptions theOptions, RequestDetails theRequestDetails) {
        Object source = this.read(theId, theRequestDetails);
        return this.expand(source, theOptions);
    }

    public T expandByIdentifier(String theUri, ValueSetExpansionOptions theOptions) {
        IValidationSupport.ValueSetExpansionOutcome expansionOutcome = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), theOptions, theUri);
        return this.extractValueSetOrThrowException(expansionOutcome);
    }

    public T expand(T theSource, ValueSetExpansionOptions theOptions) {
        IValidationSupport.ValueSetExpansionOutcome expansionOutcome = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), theOptions, theSource);
        return this.extractValueSetOrThrowException(expansionOutcome);
    }

    public T expand(IIdType theId, T theValueSet, IPrimitiveType<String> theUrl, IPrimitiveType<String> theValueSetVersion, IPrimitiveType<String> theFilter, IPrimitiveType<String> theContext, IPrimitiveType<String> theContextDirection, IPrimitiveType<Integer> theOffset, IPrimitiveType<Integer> theCount, IPrimitiveType<String> theDisplayLanguage, IPrimitiveType<Boolean> theIncludeHierarchy, RequestDetails theRequestDetails) {
        IValidationSupport.ValueSetExpansionOutcome outcome;
        boolean isAutocompleteExtension;
        boolean haveId = theId != null && theId.hasIdPart();
        boolean haveIdentifier = theUrl != null && StringUtils.isNotBlank((CharSequence)((CharSequence)theUrl.getValue()));
        boolean haveValueSet = theValueSet != null && !theValueSet.isEmpty();
        boolean haveValueSetVersion = theValueSetVersion != null && !theValueSetVersion.isEmpty();
        boolean haveContextDirection = theContextDirection != null && !theContextDirection.isEmpty();
        boolean haveContext = theContext != null && !theContext.isEmpty();
        boolean bl = isAutocompleteExtension = haveContext && haveContextDirection && "existing".equals(theContextDirection.getValue());
        if (isAutocompleteExtension) {
            ValueSetAutocompleteOptions options = ValueSetAutocompleteOptions.validateAndParseOptions(this.myStorageSettings, theContext, theFilter, theCount, theId, theUrl, theValueSet);
            if (this.myFulltextSearch == null || this.myFulltextSearch.isDisabled()) {
                throw new InvalidRequestException(Msg.code((int)2083) + " Autocomplete is not supported on this server, as the fulltext search service is not configured.");
            }
            return (T)this.myFulltextSearch.tokenAutocompleteValueSetSearch(options);
        }
        if (!(haveId || haveIdentifier || haveValueSet)) {
            if (this.myFhirContext.getVersion().getVersion() == FhirVersionEnum.DSTU2) {
                throw new InvalidRequestException(Msg.code((int)1130) + "$expand operation at the type level (no ID specified) requires an identifier or a valueSet as a part of the request");
            }
            throw new InvalidRequestException(Msg.code((int)1133) + "$expand operation at the type level (no ID specified) requires a url or a valueSet as a part of the request.");
        }
        if (!LogicUtil.multiXor(haveId, haveIdentifier, haveValueSet)) {
            if (this.myFhirContext.getVersion().getVersion() == FhirVersionEnum.DSTU2) {
                throw new InvalidRequestException(Msg.code((int)1131) + "$expand must EITHER be invoked at the type level, or have an identifier specified, or have a ValueSet specified. Can not combine these options.");
            }
            throw new InvalidRequestException(Msg.code((int)1134) + "$expand must EITHER be invoked at the instance level, or have a url specified, or have a ValueSet specified. Can not combine these options.");
        }
        ValueSetExpansionOptions options = ValueSetOperationProvider.createValueSetExpansionOptions(this.myStorageSettings, theOffset, theCount, theIncludeHierarchy, theFilter, theDisplayLanguage);
        if (haveId) {
            Object valueSet = this.read(theId, theRequestDetails);
            outcome = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), options, valueSet);
        } else if (haveIdentifier) {
            Object url = haveValueSetVersion ? (String)theUrl.getValue() + "|" + (String)theValueSetVersion.getValue() : (String)theUrl.getValue();
            outcome = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), options, (String)url);
        } else {
            outcome = this.myValidationSupport.expandValueSet(new ValidationSupportContext(this.myValidationSupport), options, theValueSet);
        }
        return this.extractValueSetOrThrowException(outcome);
    }

    private T extractValueSetOrThrowException(IValidationSupport.ValueSetExpansionOutcome outcome) {
        if (outcome == null) {
            throw new InternalErrorException(Msg.code((int)2028) + "No validation support module was able to expand the given valueset");
        }
        if (outcome.getError() != null) {
            throw new PreconditionFailedException(Msg.code((int)2029) + outcome.getError());
        }
        return (T)outcome.getValueSet();
    }

    public IValidationSupport.CodeValidationResult validateCode(IPrimitiveType<String> theValueSetIdentifier, IIdType theValueSetId, IPrimitiveType<String> theCode, IPrimitiveType<String> theSystem, IPrimitiveType<String> theDisplay, IBaseCoding theCoding, IBaseDatatype theCodeableConcept, RequestDetails theRequestDetails) {
        String display;
        String code;
        String system;
        String valueSetIdentifier;
        boolean haveCode;
        CodeableConcept codeableConcept = this.myVersionCanonicalizer.codeableConceptToCanonical(theCodeableConcept);
        boolean haveCodeableConcept = codeableConcept != null && codeableConcept.getCoding().size() > 0;
        Coding canonicalCodingToValidate = this.myVersionCanonicalizer.codingToCanonical(theCoding);
        boolean haveCoding = canonicalCodingToValidate != null && !canonicalCodingToValidate.isEmpty();
        boolean bl = haveCode = theCode != null && !theCode.isEmpty();
        if (!(haveCodeableConcept || haveCoding || haveCode)) {
            throw new InvalidRequestException(Msg.code((int)899) + "No code, coding, or codeableConcept provided to validate");
        }
        if (!LogicUtil.multiXor(haveCodeableConcept, haveCoding, haveCode)) {
            throw new InvalidRequestException(Msg.code((int)900) + "$validate-code can only validate (system AND code) OR (coding) OR (codeableConcept)");
        }
        if (theValueSetId != null) {
            Object valueSet = this.read(theValueSetId, theRequestDetails);
            StringBuilder valueSetIdentifierBuilder = new StringBuilder(CommonCodeSystemsTerminologyService.getValueSetUrl((FhirContext)this.myFhirContext, valueSet));
            String valueSetVersion = CommonCodeSystemsTerminologyService.getValueSetVersion((FhirContext)this.myFhirContext, valueSet);
            if (valueSetVersion != null) {
                valueSetIdentifierBuilder.append("|").append(valueSetVersion);
            }
            valueSetIdentifier = valueSetIdentifierBuilder.toString();
        } else if (StringUtils.isNotBlank((CharSequence)DatatypeUtil.toStringValue(theValueSetIdentifier))) {
            valueSetIdentifier = DatatypeUtil.toStringValue(theValueSetIdentifier);
        } else {
            throw new InvalidRequestException(Msg.code((int)901) + "Either ValueSet ID or ValueSet identifier or system and code must be provided. Unable to validate.");
        }
        if (haveCodeableConcept) {
            IValidationSupport.CodeValidationResult anyValidation = null;
            for (int i = 0; i < codeableConcept.getCoding().size(); ++i) {
                IValidationSupport.CodeValidationResult nextValidation;
                Coding nextCoding = (Coding)codeableConcept.getCoding().get(i);
                String system2 = JpaResourceDaoCodeSystem.createVersionedSystemIfVersionIsPresent(nextCoding.getSystem(), nextCoding.getVersion());
                String code2 = nextCoding.getCode();
                String display2 = nextCoding.getDisplay();
                anyValidation = nextValidation = this.validateCode(system2, code2, display2, valueSetIdentifier);
                if (!nextValidation.isOk()) continue;
                return nextValidation;
            }
            return anyValidation;
        }
        if (haveCoding) {
            system = JpaResourceDaoCodeSystem.createVersionedSystemIfVersionIsPresent(canonicalCodingToValidate.getSystem(), canonicalCodingToValidate.getVersion());
            code = canonicalCodingToValidate.getCode();
            display = canonicalCodingToValidate.getDisplay();
            return this.validateCode(system, code, display, valueSetIdentifier);
        }
        system = DatatypeUtil.toStringValue(theSystem);
        code = DatatypeUtil.toStringValue(theCode);
        display = DatatypeUtil.toStringValue(theDisplay);
        return this.validateCode(system, code, display, valueSetIdentifier);
    }

    private IValidationSupport.CodeValidationResult validateCode(String theSystem, String theCode, String theDisplay, String theValueSetIdentifier) {
        ValidationSupportContext context = new ValidationSupportContext(this.myValidationSupport);
        ConceptValidationOptions options = new ConceptValidationOptions();
        options.setValidateDisplay(StringUtils.isNotBlank((CharSequence)theDisplay));
        IValidationSupport.CodeValidationResult result = this.myValidationSupport.validateCode(context, options, theSystem, theCode, theDisplay, theValueSetIdentifier);
        if (result == null) {
            result = new IValidationSupport.CodeValidationResult();
            result.setMessage("Validator is unable to provide validation for " + theCode + "#" + theSystem + " - Unknown or unusable ValueSet[" + theValueSetIdentifier + "]");
        }
        return result;
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequestDetails, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        ResourceTable retVal = super.updateEntity(theRequestDetails, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        if (this.getStorageSettings().isPreExpandValueSets() && !retVal.isUnchangedInCurrentOperation()) {
            if (retVal.getDeleted() == null) {
                ValueSet valueSet = this.myVersionCanonicalizer.valueSetToCanonical(theResource);
                this.myTerminologySvc.storeTermValueSet(retVal, valueSet);
            } else {
                this.myTerminologySvc.deleteValueSetAndChildren(retVal);
            }
        }
        return retVal;
    }
}

