/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.dao.ITransactionProcessorVersionAdapter;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.dstu2.resource.Bundle;
import ca.uhn.fhir.model.dstu2.resource.OperationOutcome;
import ca.uhn.fhir.model.dstu2.valueset.BundleTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.HTTPVerbEnum;
import ca.uhn.fhir.model.dstu2.valueset.IssueSeverityEnum;
import ca.uhn.fhir.model.dstu2.valueset.IssueTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class TransactionProcessorVersionAdapterDstu2
implements ITransactionProcessorVersionAdapter<Bundle, Bundle.Entry> {
    public void setResponseStatus(Bundle.Entry theBundleEntry, String theStatus) {
        theBundleEntry.getResponse().setStatus(theStatus);
    }

    public void setResponseLastModified(Bundle.Entry theBundleEntry, Date theLastModified) {
        theBundleEntry.getResponse().setLastModified(theLastModified, TemporalPrecisionEnum.MILLI);
    }

    public void setResource(Bundle.Entry theBundleEntry, IBaseResource theResource) {
        theBundleEntry.setResource((IResource)theResource);
    }

    public IBaseResource getResource(Bundle.Entry theBundleEntry) {
        return theBundleEntry.getResource();
    }

    public String getBundleType(Bundle theRequest) {
        if (theRequest.getType() == null) {
            return null;
        }
        return (String)theRequest.getTypeElement().getValue();
    }

    public void populateEntryWithOperationOutcome(BaseServerResponseException theCaughtEx, Bundle.Entry theEntry) {
        OperationOutcome oo = new OperationOutcome();
        oo.addIssue().setSeverity(IssueSeverityEnum.ERROR).setDiagnostics(theCaughtEx.getMessage()).setCode(IssueTypeEnum.EXCEPTION);
        theEntry.setResource((IResource)oo);
    }

    public Bundle createBundle(String theBundleType) {
        Bundle resp = new Bundle();
        try {
            resp.setType(BundleTypeEnum.forCode((String)theBundleType));
        }
        catch (FHIRException theE) {
            throw new InternalErrorException(Msg.code((int)936) + "Unknown bundle type: " + theBundleType);
        }
        return resp;
    }

    public List<Bundle.Entry> getEntries(Bundle theRequest) {
        return theRequest.getEntry();
    }

    public void addEntry(Bundle theBundle, Bundle.Entry theEntry) {
        theBundle.addEntry(theEntry);
    }

    public Bundle.Entry addEntry(Bundle theBundle) {
        return theBundle.addEntry();
    }

    public String getEntryRequestVerb(FhirContext theContext, Bundle.Entry theEntry) {
        String retVal = null;
        HTTPVerbEnum value = (HTTPVerbEnum)theEntry.getRequest().getMethodElement().getValueAsEnum();
        if (value != null) {
            retVal = value.getCode();
        }
        return retVal;
    }

    public String getFullUrl(Bundle.Entry theEntry) {
        return theEntry.getFullUrl();
    }

    public void setFullUrl(Bundle.Entry theEntry, String theFullUrl) {
        theEntry.setFullUrl(theFullUrl);
    }

    public String getEntryIfNoneExist(Bundle.Entry theEntry) {
        return theEntry.getRequest().getIfNoneExist();
    }

    public String getEntryRequestUrl(Bundle.Entry theEntry) {
        return theEntry.getRequest().getUrl();
    }

    public void setResponseLocation(Bundle.Entry theEntry, String theResponseLocation) {
        theEntry.getResponse().setLocation(theResponseLocation);
    }

    public void setResponseETag(Bundle.Entry theEntry, String theEtag) {
        theEntry.getResponse().setEtag(theEtag);
    }

    public String getEntryRequestIfMatch(Bundle.Entry theEntry) {
        return theEntry.getRequest().getIfMatch();
    }

    public String getEntryRequestIfNoneExist(Bundle.Entry theEntry) {
        return theEntry.getRequest().getIfNoneExist();
    }

    public String getEntryRequestIfNoneMatch(Bundle.Entry theEntry) {
        return theEntry.getRequest().getIfNoneMatch();
    }

    public void setResponseOutcome(Bundle.Entry theEntry, IBaseOperationOutcome theOperationOutcome) {
        theEntry.setResource((IResource)theOperationOutcome);
    }

    public void setRequestVerb(Bundle.Entry theEntry, String theVerb) {
        theEntry.getRequest().setMethod(HTTPVerbEnum.forCode((String)theVerb));
    }

    public void setRequestUrl(Bundle.Entry theEntry, String theUrl) {
        theEntry.getRequest().setUrl(theUrl);
    }
}

