/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.batch2.model.BatchWorkChunkStatusDTO;
import ca.uhn.fhir.batch2.model.WorkChunkStatusEnum;
import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.entity.Batch2WorkChunkEntity;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface IBatch2WorkChunkRepository
extends JpaRepository<Batch2WorkChunkEntity, String>,
IHapiFhirJpaRepository {
    @Query(value="SELECT e FROM Batch2WorkChunkEntity e WHERE e.myInstanceId = :instanceId ORDER BY e.mySequence ASC, e.myId ASC")
    public List<Batch2WorkChunkEntity> fetchChunks(Pageable var1, @Param(value="instanceId") String var2);

    @Query(value="SELECT new Batch2WorkChunkEntity(e.myId, e.mySequence, e.myJobDefinitionId, e.myJobDefinitionVersion, e.myInstanceId, e.myTargetStepId, e.myStatus,e.myCreateTime, e.myStartTime, e.myUpdateTime, e.myEndTime,e.myErrorMessage, e.myErrorCount, e.myRecordsProcessed, e.myWarningMessage,e.myNextPollTime, e.myPollAttempts) FROM Batch2WorkChunkEntity e WHERE e.myInstanceId = :instanceId ORDER BY e.mySequence ASC, e.myId ASC")
    public List<Batch2WorkChunkEntity> fetchChunksNoData(Pageable var1, @Param(value="instanceId") String var2);

    @Query(value="SELECT DISTINCT e.myStatus from Batch2WorkChunkEntity e where e.myInstanceId = :instanceId AND e.myTargetStepId = :stepId")
    public Set<WorkChunkStatusEnum> getDistinctStatusesForStep(@Param(value="instanceId") String var1, @Param(value="stepId") String var2);

    @Query(value="SELECT e FROM Batch2WorkChunkEntity e WHERE e.myInstanceId = :instanceId AND e.myTargetStepId = :targetStepId ORDER BY e.mySequence ASC")
    public Stream<Batch2WorkChunkEntity> fetchChunksForStep(@Param(value="instanceId") String var1, @Param(value="targetStepId") String var2);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :status, e.myEndTime = :et, e.myRecordsProcessed = :rp, e.myErrorCount = e.myErrorCount + :errorRetries, e.mySerializedData = null, e.mySerializedDataVc = null, e.myWarningMessage = :warningMessage WHERE e.myId = :id")
    public void updateChunkStatusAndClearDataForEndSuccess(@Param(value="id") String var1, @Param(value="et") Date var2, @Param(value="rp") int var3, @Param(value="errorRetries") int var4, @Param(value="status") WorkChunkStatusEnum var5, @Param(value="warningMessage") String var6);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :status, e.myNextPollTime = :nextPollTime, e.myPollAttempts = COALESCE(e.myPollAttempts, 0) + 1 WHERE e.myId = :id AND e.myStatus IN(:states)")
    public int updateWorkChunkNextPollTime(@Param(value="id") String var1, @Param(value="status") WorkChunkStatusEnum var2, @Param(value="states") Set<WorkChunkStatusEnum> var3, @Param(value="nextPollTime") Date var4);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :status, e.myNextPollTime = null WHERE e.myInstanceId = :instanceId AND e.myStatus IN(:states) AND e.myNextPollTime <= :pollTime")
    public int updateWorkChunksForPollWaiting(@Param(value="instanceId") String var1, @Param(value="pollTime") Date var2, @Param(value="states") Set<WorkChunkStatusEnum> var3, @Param(value="status") WorkChunkStatusEnum var4);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :status, e.myEndTime = :et, e.mySerializedData = null, e.mySerializedDataVc = null, e.myErrorMessage = :em WHERE e.myId IN(:ids)")
    public void updateAllChunksForInstanceStatusClearDataAndSetError(@Param(value="ids") List<String> var1, @Param(value="et") Date var2, @Param(value="status") WorkChunkStatusEnum var3, @Param(value="em") String var4);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :status, e.myEndTime = :et, e.myErrorMessage = :em, e.myErrorCount = e.myErrorCount + 1 WHERE e.myId = :id")
    public int updateChunkStatusAndIncrementErrorCountForEndError(@Param(value="id") String var1, @Param(value="et") Date var2, @Param(value="em") String var3, @Param(value="status") WorkChunkStatusEnum var4);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :status, e.myStartTime = :st WHERE e.myId = :id AND e.myStatus IN :startStatuses")
    public int updateChunkStatusForStart(@Param(value="id") String var1, @Param(value="st") Date var2, @Param(value="status") WorkChunkStatusEnum var3, @Param(value="startStatuses") Collection<WorkChunkStatusEnum> var4);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :newStatus WHERE e.myId = :id AND e.myStatus = :oldStatus")
    public int updateChunkStatus(@Param(value="id") String var1, @Param(value="oldStatus") WorkChunkStatusEnum var2, @Param(value="newStatus") WorkChunkStatusEnum var3);

    @Modifying
    @Query(value="UPDATE Batch2WorkChunkEntity e SET e.myStatus = :newStatus WHERE e.myInstanceId = :instanceId AND e.myTargetStepId = :stepId AND e.myStatus IN ( :oldStatuses )")
    public int updateAllChunksForStepWithStatus(@Param(value="instanceId") String var1, @Param(value="stepId") String var2, @Param(value="oldStatuses") List<WorkChunkStatusEnum> var3, @Param(value="newStatus") WorkChunkStatusEnum var4);

    @Modifying
    @Query(value="DELETE FROM Batch2WorkChunkEntity e WHERE e.myInstanceId = :instanceId")
    public int deleteAllForInstance(@Param(value="instanceId") String var1);

    @Query(value="SELECT e.myId from Batch2WorkChunkEntity e where e.myInstanceId = :instanceId AND e.myTargetStepId = :stepId AND e.myStatus = :status")
    public List<String> fetchAllChunkIdsForStepWithStatus(@Param(value="instanceId") String var1, @Param(value="stepId") String var2, @Param(value="status") WorkChunkStatusEnum var3);

    @Query(value="SELECT new ca.uhn.fhir.batch2.model.BatchWorkChunkStatusDTO(e.myTargetStepId, e.myStatus, min(e.myStartTime), max(e.myEndTime), avg(cast((e.myEndTime - e.myStartTime) as long)), count(*)) FROM Batch2WorkChunkEntity e WHERE e.myInstanceId=:instanceId GROUP BY e.myTargetStepId, e.myStatus")
    public List<BatchWorkChunkStatusDTO> fetchWorkChunkStatusForInstance(@Param(value="instanceId") String var1);
}

