/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.entity.MdmLink;
import ca.uhn.fhir.mdm.api.MdmMatchResultEnum;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface IMdmLinkJpaRepository
extends RevisionRepository<MdmLink, Long, Long>,
JpaRepository<MdmLink, Long>,
IHapiFhirJpaRepository {
    @Modifying
    @Query(value="DELETE FROM MdmLink f WHERE myGoldenResourcePid = :pid OR mySourcePid = :pid")
    public int deleteWithAnyReferenceToPid(@Param(value="pid") Long var1);

    @Modifying
    @Query(value="DELETE FROM MdmLink f WHERE (myGoldenResourcePid = :pid OR mySourcePid = :pid) AND myMatchResult <> :matchResult")
    public int deleteWithAnyReferenceToPidAndMatchResultNot(@Param(value="pid") Long var1, @Param(value="matchResult") MdmMatchResultEnum var2);

    @Modifying
    @Query(value="DELETE FROM MdmLink f WHERE myGoldenResourcePid IN (:goldenPids) OR mySourcePid IN (:goldenPids)")
    public void deleteLinksWithAnyReferenceToPids(@Param(value="goldenPids") List<Long> var1);

    @Modifying
    @Query(value="DELETE FROM MPI_LINK_AUD WHERE GOLDEN_RESOURCE_PID IN (:goldenPids) OR TARGET_PID IN (:goldenPids)", nativeQuery=true)
    public void deleteLinksHistoryWithAnyReferenceToPids(@Param(value="goldenPids") List<Long> var1);

    @Query(value="SELECT lookup_links.myGoldenResourcePid as goldenPid, gld_rt.myPartitionIdValue as goldenPartitionId, lookup_links.mySourcePid as sourcePid, lookup_links.myPartitionIdValue as sourcePartitionId FROM MdmLink lookup_links INNER JOIN ResourceTable gld_rt on lookup_links.myGoldenResourcePid=gld_rt.myId WHERE lookup_links.myMatchResult=:matchResult AND lookup_links.myGoldenResourcePid IN (SELECT inner_mdm_link.myGoldenResourcePid FROM MdmLink inner_mdm_link INNER JOIN ResourceLink inner_res_link ON inner_res_link.myTargetResourcePid=inner_mdm_link.mySourcePid AND inner_res_link.mySourceResourcePid=:groupPid AND inner_res_link.mySourcePath='Group.member.entity' AND inner_res_link.myTargetResourceType='Patient')")
    public List<MdmPidTuple> expandPidsFromGroupPidGivenMatchResult(@Param(value="groupPid") Long var1, @Param(value="matchResult") MdmMatchResultEnum var2);

    @Query(value="SELECT ml FROM MdmLink ml WHERE ml.mySourcePid = :sourcePid AND ml.myMatchResult = :matchResult")
    public Optional<MdmLink> findBySourcePidAndMatchResult(@Param(value="sourcePid") Long var1, @Param(value="matchResult") MdmMatchResultEnum var2);

    @Query(value="SELECT lookup_link.myGoldenResourcePid as goldenPid, gld_rt.myPartitionIdValue as goldenPartitionId, lookup_link.mySourcePid as sourcePid, lookup_link.myPartitionIdValue as sourcePartitionId FROM MdmLink lookup_link INNER JOIN MdmLink gld_link on lookup_link.myGoldenResourcePid=gld_link.myGoldenResourcePid INNER JOIN ResourceTable gld_rt on gld_link.myGoldenResourcePid=gld_rt.myId WHERE gld_link.mySourcePid=:sourcePid AND gld_link.myMatchResult=:matchResult AND lookup_link.myMatchResult=:matchResult")
    public List<MdmPidTuple> expandPidsBySourcePidAndMatchResult(@Param(value="sourcePid") Long var1, @Param(value="matchResult") MdmMatchResultEnum var2);

    @Query(value="SELECT ml FROM MdmLink ml INNER JOIN MdmLink ml2 on ml.myGoldenResourcePid=ml2.myGoldenResourcePid WHERE ml2.mySourcePid=:sourcePid AND ml2.myMatchResult!=:matchResult")
    public List<MdmLink> findLinksAssociatedWithGoldenResourceOfSourceResourceExcludingMatchResult(@Param(value="sourcePid") Long var1, @Param(value="matchResult") MdmMatchResultEnum var2);

    @Query(value="SELECT lookup_link.myGoldenResourcePid as goldenPid, gld_rt.myPartitionIdValue as goldenPartitionId, lookup_link.mySourcePid as sourcePid, lookup_link.myPartitionIdValue as sourcePartitionId FROM MdmLink lookup_link INNER JOIN ResourceTable gld_rt on lookup_link.myGoldenResourcePid=gld_rt.myId WHERE lookup_link.myGoldenResourcePid = :goldenPid AND lookup_link.myMatchResult = :matchResult")
    public List<MdmPidTuple> expandPidsByGoldenResourcePidAndMatchResult(@Param(value="goldenPid") Long var1, @Param(value="matchResult") MdmMatchResultEnum var2);

    @Query(value="SELECT ml.myId FROM MdmLink ml WHERE ml.myMdmSourceType = :resourceName AND ml.myCreated <= :highThreshold ORDER BY ml.myCreated DESC")
    public List<Long> findPidByResourceNameAndThreshold(@Param(value="resourceName") String var1, @Param(value="highThreshold") Date var2, Pageable var3);

    @Query(value="SELECT ml.myId FROM MdmLink ml WHERE ml.myMdmSourceType = :resourceName AND ml.myCreated <= :highThreshold AND ml.myPartitionIdValue IN :partitionId ORDER BY ml.myCreated DESC")
    public List<Long> findPidByResourceNameAndThresholdAndPartitionId(@Param(value="resourceName") String var1, @Param(value="highThreshold") Date var2, @Param(value="partitionId") List<Integer> var3, Pageable var4);

    public static interface MdmPidTuple {
        public Long getGoldenPid();

        public Integer getGoldenPartitionId();

        public Long getSourcePid();

        public Integer getSourcePartitionId();
    }
}

