/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.dao.data.custom.IForcedIdQueries;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.MANDATORY)
public interface IResourceTableDao
extends JpaRepository<ResourceTable, Long>,
IHapiFhirJpaRepository,
IForcedIdQueries {
    @Query(value="SELECT t.myId FROM ResourceTable t WHERE t.myDeleted IS NOT NULL")
    public Slice<Long> findIdsOfDeletedResources(Pageable var1);

    @Query(value="SELECT t.myId FROM ResourceTable t WHERE t.myResourceType = :restype AND t.myDeleted IS NOT NULL")
    public Slice<Long> findIdsOfDeletedResourcesOfType(Pageable var1, @Param(value="restype") String var2);

    @Query(value="SELECT t.myId FROM ResourceTable t WHERE t.myId = :resid AND t.myResourceType = :restype AND t.myDeleted IS NOT NULL")
    public Slice<Long> findIdsOfDeletedResourcesOfType(Pageable var1, @Param(value="resid") Long var2, @Param(value="restype") String var3);

    @Query(value="SELECT t.myResourceType as type, COUNT(t.myResourceType) as count FROM ResourceTable t GROUP BY t.myResourceType")
    public List<Map<?, ?>> getResourceCounts();

    @Query(value="SELECT t.myId FROM ResourceTable t WHERE t.myUpdated >= :low AND t.myUpdated <= :high ORDER BY t.myUpdated DESC")
    public Slice<Long> findIdsOfResourcesWithinUpdatedRangeOrderedFromNewest(Pageable var1, @Param(value="low") Date var2, @Param(value="high") Date var3);

    @Query(value="SELECT t.myId FROM ResourceTable t WHERE t.myUpdated >= :low AND t.myUpdated <= :high ORDER BY t.myUpdated ASC")
    public Slice<Long> findIdsOfResourcesWithinUpdatedRangeOrderedFromOldest(Pageable var1, @Param(value="low") Date var2, @Param(value="high") Date var3);

    @Query(value="SELECT t.myId, t.myResourceType, t.myUpdated FROM ResourceTable t WHERE t.myUpdated >= :low AND t.myUpdated <= :high ORDER BY t.myUpdated ASC")
    public Stream<Object[]> streamIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldest(@Param(value="low") Date var1, @Param(value="high") Date var2);

    @Query(value="SELECT t.myId, t.myResourceType, t.myUpdated FROM ResourceTable t WHERE t.myUpdated >= :low AND t.myUpdated <= :high AND t.myPartitionIdValue IN (:partition_ids) ORDER BY t.myUpdated ASC")
    public Slice<Object[]> findIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldestForPartitionIds(Pageable var1, @Param(value="low") Date var2, @Param(value="high") Date var3, @Param(value="partition_ids") List<Integer> var4);

    @Query(value="SELECT t.myId, t.myResourceType, t.myUpdated FROM ResourceTable t WHERE t.myUpdated >= :low AND t.myUpdated <= :high AND t.myPartitionIdValue IN (:partition_ids) ORDER BY t.myUpdated ASC")
    public Stream<Object[]> streamIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldestForPartitionIds(@Param(value="low") Date var1, @Param(value="high") Date var2, @Param(value="partition_ids") List<Integer> var3);

    @Query(value="SELECT t.myId, t.myResourceType, t.myUpdated FROM ResourceTable t WHERE t.myUpdated >= :low AND t.myUpdated <= :high ORDER BY t.myUpdated ASC")
    public Slice<Object[]> findIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldestForDefaultPartition(Pageable var1, @Param(value="low") Date var2, @Param(value="high") Date var3);

    @Query(value="SELECT t.myId, t.myResourceType, t.myUpdated FROM ResourceTable t WHERE t.myUpdated >= :low AND t.myUpdated <= :high ORDER BY t.myUpdated ASC")
    public Stream<Object[]> streamIdsTypesAndUpdateTimesOfResourcesWithinUpdatedRangeOrderedFromOldestForDefaultPartition(@Param(value="low") Date var1, @Param(value="high") Date var2);

    @Query(value="SELECT t.myId FROM ResourceTable t WHERE t.myUpdated >= :low AND t.myUpdated <= :high AND t.myPartitionIdValue = :partition_id ORDER BY t.myUpdated ASC")
    public Slice<Long> findIdsOfPartitionedResourcesWithinUpdatedRangeOrderedFromOldest(Pageable var1, @Param(value="low") Date var2, @Param(value="high") Date var3, @Param(value="partition_id") Integer var4);

    @Query(value="SELECT t.myId FROM ResourceTable t WHERE t.myUpdated >= :low AND t.myUpdated <= :high AND t.myResourceType = :restype ORDER BY t.myUpdated ASC")
    public Slice<Long> findIdsOfResourcesWithinUpdatedRangeOrderedFromOldest(Pageable var1, @Param(value="restype") String var2, @Param(value="low") Date var3, @Param(value="high") Date var4);

    @Modifying
    @Query(value="UPDATE ResourceTable t SET t.myIndexStatus = :status WHERE t.myId = :id")
    public void updateIndexStatus(@Param(value="id") Long var1, @Param(value="status") Long var2);

    @Modifying
    @Query(value="UPDATE ResourceTable t SET t.myUpdated = :updated WHERE t.myId = :id")
    public void updateLastUpdated(@Param(value="id") Long var1, @Param(value="updated") Date var2);

    @Modifying
    @Query(value="DELETE FROM ResourceTable t WHERE t.myId = :pid")
    public void deleteByPid(@Param(value="pid") Long var1);

    @Query(value="SELECT t.myResourceType, t.myId, t.myDeleted, t.myPartitionIdValue, t.myPartitionDateValue FROM ResourceTable t WHERE t.myId IN (:pid)")
    public Collection<Object[]> findLookupFieldsByResourcePid(@Param(value="pid") List<Long> var1);

    @Query(value="SELECT t.myResourceType, t.myId, t.myDeleted, t.myPartitionIdValue, t.myPartitionDateValue FROM ResourceTable t WHERE t.myId IN (:pid) AND t.myPartitionIdValue IN :partition_id")
    public Collection<Object[]> findLookupFieldsByResourcePidInPartitionIds(@Param(value="pid") List<Long> var1, @Param(value="partition_id") Collection<Integer> var2);

    @Query(value="SELECT t.myResourceType, t.myId, t.myDeleted, t.myPartitionIdValue, t.myPartitionDateValue FROM ResourceTable t WHERE t.myId IN (:pid) AND (t.myPartitionIdValue IS NULL OR t.myPartitionIdValue IN :partition_id)")
    public Collection<Object[]> findLookupFieldsByResourcePidInPartitionIdsOrNullPartition(@Param(value="pid") List<Long> var1, @Param(value="partition_id") Collection<Integer> var2);

    @Query(value="SELECT t.myResourceType, t.myId, t.myDeleted, t.myPartitionIdValue, t.myPartitionDateValue FROM ResourceTable t WHERE t.myId IN (:pid) AND t.myPartitionIdValue IS NULL")
    public Collection<Object[]> findLookupFieldsByResourcePidInPartitionNull(@Param(value="pid") List<Long> var1);

    @Query(value="SELECT t.myVersion FROM ResourceTable t WHERE t.myId = :pid")
    public Long findCurrentVersionByPid(@Param(value="pid") Long var1);

    @Query(value="SELECT t.myId, t.myResourceType, t.myVersion FROM ResourceTable t WHERE t.myId IN ( :pid )")
    public Collection<Object[]> getResourceVersionsForPid(@Param(value="pid") List<Long> var1);

    @Query(value="SELECT t FROM ResourceTable t WHERE t.myPartitionId.myPartitionId IS NULL AND t.myId = :pid")
    public Optional<ResourceTable> readByPartitionIdNull(@Param(value="pid") Long var1);

    @Query(value="SELECT t FROM ResourceTable t WHERE t.myPartitionId.myPartitionId = :partitionId AND t.myId = :pid")
    public Optional<ResourceTable> readByPartitionId(@Param(value="partitionId") int var1, @Param(value="pid") Long var2);

    @Query(value="SELECT t FROM ResourceTable t WHERE (t.myPartitionId.myPartitionId IS NULL OR t.myPartitionId.myPartitionId IN (:partitionIds)) AND t.myId = :pid")
    public Optional<ResourceTable> readByPartitionIdsOrNull(@Param(value="partitionIds") Collection<Integer> var1, @Param(value="pid") Long var2);

    @Query(value="SELECT t FROM ResourceTable t WHERE t.myPartitionId.myPartitionId IN (:partitionIds) AND t.myId = :pid")
    public Optional<ResourceTable> readByPartitionIds(@Param(value="partitionIds") Collection<Integer> var1, @Param(value="pid") Long var2);

    @Query(value="SELECT t FROM ResourceTable t WHERE t.myId IN :pids")
    public List<ResourceTable> findAllByIdAndLoadForcedIds(@Param(value="pids") List<Long> var1);

    @Query(value="SELECT t FROM ResourceTable t where t.myResourceType = :restype and t.myFhirId = :fhirId")
    public Optional<ResourceTable> findByTypeAndFhirId(@Param(value="restype") String var1, @Param(value="fhirId") String var2);
}

