/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.dao.data.SearchIdAndResultSize;
import ca.uhn.fhir.jpa.entity.Search;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ISearchDao
extends JpaRepository<Search, Long>,
IHapiFhirJpaRepository {
    @Query(value="SELECT s FROM Search s LEFT OUTER JOIN FETCH s.myIncludes WHERE s.myUuid = :uuid")
    public Optional<Search> findByUuidAndFetchIncludes(@Param(value="uuid") String var1);

    @Query(value="SELECT s.myId FROM Search s WHERE (s.myCreated < :cutoff) AND (s.myExpiryOrNull IS NULL OR s.myExpiryOrNull < :now) AND (s.myDeleted IS NULL OR s.myDeleted = FALSE)")
    public Stream<Long> findWhereCreatedBefore(@Param(value="cutoff") Date var1, @Param(value="now") Date var2);

    @Query(value="SELECT new ca.uhn.fhir.jpa.dao.data.SearchIdAndResultSize(s.myId, (select max(sr.myOrder) as maxOrder from SearchResult sr where sr.mySearchPid = s.myId)) FROM Search s WHERE s.myDeleted = TRUE")
    public Stream<SearchIdAndResultSize> findDeleted();

    @Query(value="SELECT s FROM Search s WHERE s.myResourceType = :type AND s.mySearchQueryStringHash = :hash AND (s.myCreated > :cutoff) AND s.myDeleted = FALSE AND s.myStatus <> 'FAILED'")
    public Collection<Search> findWithCutoffOrExpiry(@Param(value="type") String var1, @Param(value="hash") int var2, @Param(value="cutoff") Date var3);

    @Query(value="SELECT COUNT(s) FROM Search s WHERE s.myDeleted = TRUE")
    public int countDeleted();

    @Modifying
    @Query(value="UPDATE Search s SET s.myDeleted = :deleted WHERE s.myId in (:pids)")
    @CanIgnoreReturnValue
    public int updateDeleted(@Param(value="pids") Set<Long> var1, @Param(value="deleted") boolean var2);

    @Modifying
    @Query(value="DELETE FROM Search s WHERE s.myId = :pid")
    public void deleteByPid(@Param(value="pid") Long var1);

    @Modifying
    @Query(value="DELETE FROM Search s WHERE s.myId in (:pids)")
    public void deleteByPids(@Param(value="pids") Collection<Long> var1);
}

