/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.dao.search.ResourceNotFoundInIndexException;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.IParser;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ExtendedHSearchResourceProjection {
    public static final String RESOURCE_NOT_STORED_ERROR = "Resource not stored in search index: ";
    final long myPid;
    final String myForcedId;
    final String myResourceString;

    public ExtendedHSearchResourceProjection(long thePid, String theForcedId, String theResourceString) {
        if (StringUtils.isEmpty((CharSequence)theResourceString)) {
            throw new ResourceNotFoundInIndexException(Msg.code((int)2130) + RESOURCE_NOT_STORED_ERROR + thePid);
        }
        this.myPid = thePid;
        this.myForcedId = theForcedId;
        this.myResourceString = theResourceString;
    }

    public IBaseResource toResource(IParser theParser) {
        IBaseResource result = theParser.parseResource(this.myResourceString);
        IdDt id = this.myForcedId != null ? new IdDt(this.myForcedId) : new IdDt(this.myPid);
        result.setId((IIdType)id);
        return result;
    }

    public long getPid() {
        return this.myPid;
    }
}

