/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.dao.search.IHSearchSortHelper;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.search.engine.search.sort.dsl.CompositeSortComponentsStep;
import org.hibernate.search.engine.search.sort.dsl.FieldSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.engine.search.sort.dsl.SortFinalStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSearchSortHelperImpl
implements IHSearchSortHelper {
    private static final Logger ourLog = LoggerFactory.getLogger(HSearchSortHelperImpl.class);
    private Map<RestSearchParameterTypeEnum, List<String>> mySortPropertyListMap = Map.of(RestSearchParameterTypeEnum.STRING, List.of("sp.*.string.lower"), RestSearchParameterTypeEnum.TOKEN, List.of(String.join((CharSequence)".", "nsp", "*", "token", "system"), String.join((CharSequence)".", "nsp", "*", "token", "code")), RestSearchParameterTypeEnum.REFERENCE, List.of("sp.*.reference.value"), RestSearchParameterTypeEnum.DATE, List.of("sp.*.dt.lower"), RestSearchParameterTypeEnum.QUANTITY, List.of(String.join((CharSequence)".", "nsp", "*", "quantity", "value-norm"), String.join((CharSequence)".", "nsp", "*", "quantity", "value")), RestSearchParameterTypeEnum.URI, List.of("sp.*.uri-value"), RestSearchParameterTypeEnum.NUMBER, List.of("sp.*.number-value"));
    private final ISearchParamRegistry mySearchParamRegistry;

    public HSearchSortHelperImpl(ISearchParamRegistry theSearchParamRegistry) {
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    @Override
    public SortFinalStep getSortClauses(SearchSortFactory theSortFactory, SortSpec theSortParams, String theResourceType) {
        CompositeSortComponentsStep sortStep = theSortFactory.composite();
        Optional<SortFinalStep> sortClauseOpt = this.getSortClause(theSortFactory, theSortParams, theResourceType);
        sortClauseOpt.ifPresent(arg_0 -> ((CompositeSortComponentsStep)sortStep).add(arg_0));
        for (SortSpec nextParam = theSortParams.getChain(); nextParam != null; nextParam = nextParam.getChain()) {
            sortClauseOpt = this.getSortClause(theSortFactory, nextParam, theResourceType);
            sortClauseOpt.ifPresent(arg_0 -> ((CompositeSortComponentsStep)sortStep).add(arg_0));
        }
        return sortStep;
    }

    @Override
    public boolean supportsAllSortTerms(String theResourceType, SearchParameterMap theParams) {
        for (SortSpec sortSpec : theParams.getAllChainsInOrder()) {
            Optional<RestSearchParameterTypeEnum> paramTypeOpt = this.getParamType(theResourceType, sortSpec.getParamName());
            if (!paramTypeOpt.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    Optional<SortFinalStep> getSortClause(SearchSortFactory theF, SortSpec theSortSpec, String theResourceType) {
        Optional<RestSearchParameterTypeEnum> paramTypeOpt = this.getParamType(theResourceType, theSortSpec.getParamName());
        if (paramTypeOpt.isEmpty()) {
            throw new IllegalArgumentException(Msg.code((int)2523) + "Invalid sort specification: " + theSortSpec.getParamName());
        }
        List<String> paramFieldNameList = this.getSortPropertyList(paramTypeOpt.get(), theSortSpec.getParamName());
        if (paramFieldNameList.isEmpty()) {
            ourLog.warn("Unable to sort by parameter '{}' . Sort parameter ignored.", (Object)theSortSpec.getParamName());
            return Optional.empty();
        }
        CompositeSortComponentsStep sortFinalStep = theF.composite();
        for (String fieldName : paramFieldNameList) {
            FieldSortOptionsStep sortStep = theF.field(fieldName);
            if (theSortSpec.getOrder().equals((Object)SortOrderEnum.DESC)) {
                sortStep.desc();
            } else {
                sortStep.asc();
            }
            sortFinalStep.add((SortFinalStep)sortStep.missing().last());
        }
        return Optional.of(sortFinalStep);
    }

    @VisibleForTesting
    Optional<RestSearchParameterTypeEnum> getParamType(String theResourceTypeName, String theParamName) {
        ResourceSearchParams activeSearchParams = this.mySearchParamRegistry.getActiveSearchParams(theResourceTypeName);
        RuntimeSearchParam searchParam = activeSearchParams.get(theParamName);
        if (searchParam == null) {
            return Optional.empty();
        }
        return Optional.of(searchParam.getParamType());
    }

    @VisibleForTesting
    List<String> getSortPropertyList(RestSearchParameterTypeEnum theParamType, String theParamName) {
        List<String> paramFieldNameList = this.mySortPropertyListMap.get(theParamType);
        return paramFieldNameList.stream().map(s -> s.replace("*", theParamName)).collect(Collectors.toList());
    }
}

