/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.dao.search.ExtendedHSearchClauseBuilder;
import ca.uhn.fhir.jpa.dao.search.ExtendedHSearchSearchBuilder;
import ca.uhn.fhir.jpa.dao.search.LastNAggregation;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.model.search.ExtendedHSearchBuilderConsumeAdvancedQueryClausesParams;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.util.LastNParameterHelper;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.ElasticsearchExtension;
import org.hibernate.search.backend.elasticsearch.search.query.dsl.ElasticsearchSearchQueryOptionsStep;
import org.hibernate.search.backend.elasticsearch.search.query.dsl.ElasticsearchSearchQuerySelectStep;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.query.SearchResult;
import org.hibernate.search.engine.search.query.dsl.SearchQueryDslExtension;
import org.hibernate.search.mapper.orm.session.SearchSession;

public class LastNOperation {
    public static final String OBSERVATION_RES_TYPE = "Observation";
    private final SearchSession mySession;
    private final FhirContext myFhirContext;
    private final StorageSettings myStorageSettings;
    private final ISearchParamRegistry mySearchParamRegistry;
    private final ExtendedHSearchSearchBuilder myExtendedHSearchSearchBuilder = new ExtendedHSearchSearchBuilder();

    public LastNOperation(SearchSession theSession, FhirContext theFhirContext, StorageSettings theStorageSettings, ISearchParamRegistry theSearchParamRegistry) {
        this.mySession = theSession;
        this.myFhirContext = theFhirContext;
        this.myStorageSettings = theStorageSettings;
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    public List<Long> executeLastN(SearchParameterMap theParams, Integer theMaximumResults) {
        boolean lastNGroupedBySubject = this.isLastNGroupedBySubject(theParams);
        LastNAggregation lastNAggregation = new LastNAggregation(this.getLastNMaxParamValue(theParams), lastNGroupedBySubject);
        AggregationKey observationsByCodeKey = AggregationKey.of((String)"lastN_aggregation");
        SearchResult result = ((ElasticsearchSearchQueryOptionsStep)((ElasticsearchSearchQueryOptionsStep)((ElasticsearchSearchQuerySelectStep)this.mySession.search(ResourceTable.class).extension((SearchQueryDslExtension)ElasticsearchExtension.get())).where(f -> f.bool(b -> {
            b.must((PredicateFinalStep)f.match().field("myResourceType").matching((Object)OBSERVATION_RES_TYPE));
            ExtendedHSearchClauseBuilder builder = new ExtendedHSearchClauseBuilder(this.myFhirContext, this.myStorageSettings, (BooleanPredicateClausesStep<?>)b, (SearchPredicateFactory)f);
            ExtendedHSearchBuilderConsumeAdvancedQueryClausesParams params = new ExtendedHSearchBuilderConsumeAdvancedQueryClausesParams();
            params.setResourceType(OBSERVATION_RES_TYPE).setSearchParameterMap(theParams.clone()).setSearchParamRegistry(this.mySearchParamRegistry);
            this.myExtendedHSearchSearchBuilder.addAndConsumeAdvancedQueryClauses(builder, params);
        }))).aggregation(observationsByCodeKey, f -> f.fromJson(lastNAggregation.toAggregation()))).fetch(Integer.valueOf(0));
        JsonObject resultAggregation = (JsonObject)result.aggregation(observationsByCodeKey);
        List<Long> pidList = lastNAggregation.extractResourceIds(resultAggregation);
        if (theMaximumResults != null && theMaximumResults <= pidList.size()) {
            return pidList.subList(0, theMaximumResults);
        }
        return pidList;
    }

    private boolean isLastNGroupedBySubject(SearchParameterMap theParams) {
        String patientParamName = LastNParameterHelper.getPatientParamName((FhirContext)this.myFhirContext);
        String subjectParamName = LastNParameterHelper.getSubjectParamName((FhirContext)this.myFhirContext);
        return theParams.containsKey(patientParamName) || theParams.containsKey(subjectParamName);
    }

    private int getLastNMaxParamValue(SearchParameterMap theParams) {
        return Objects.isNull(theParams.getLastNMax()) ? 1 : theParams.getLastNMax();
    }
}

