/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.delete;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.DeleteConflict;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.interceptor.CascadingDeleteInterceptor;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceGoneException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.transaction.annotation.Propagation;

public class ThreadSafeResourceDeleterSvc {
    public static final long RETRY_BACKOFF_PERIOD = 100L;
    public static final int RETRY_MAX_ATTEMPTS = 4;
    private static final String REQ_DET_KEY_IN_NEW_TRANSACTION = ThreadSafeResourceDeleterSvc.class.getName() + "REQ_DET_KEY_IN_NEW_TRANSACTION";
    private static final Logger ourLog = LoggerFactory.getLogger(ThreadSafeResourceDeleterSvc.class);
    private final DaoRegistry myDaoRegistry;
    private final IInterceptorBroadcaster myInterceptorBroadcaster;
    private final RetryTemplate myRetryTemplate = ThreadSafeResourceDeleterSvc.getRetryTemplate();
    private final IHapiTransactionService myTransactionService;

    public ThreadSafeResourceDeleterSvc(DaoRegistry theDaoRegistry, IInterceptorBroadcaster theInterceptorBroadcaster, IHapiTransactionService theTransactionService) {
        this.myDaoRegistry = theDaoRegistry;
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
        this.myTransactionService = theTransactionService;
    }

    public Integer delete(RequestDetails theRequest, DeleteConflictList theConflictList, TransactionDetails theTransactionDetails) {
        Integer retVal = 0;
        List<String> cascadeDeleteIdCache = CascadingDeleteInterceptor.getCascadedDeletesList(theRequest, true);
        for (DeleteConflict next : theConflictList) {
            IdDt nextSource = next.getSourceId();
            String nextSourceId = nextSource.toUnqualifiedVersionless().getValue();
            if (cascadeDeleteIdCache.contains(nextSourceId)) continue;
            cascadeDeleteIdCache.add(nextSourceId);
            retVal = retVal + this.handleNextSource(theRequest, theConflictList, theTransactionDetails, next, nextSource, nextSourceId);
        }
        return retVal;
    }

    private Integer handleNextSource(RequestDetails theRequest, DeleteConflictList theConflictList, TransactionDetails theTransactionDetails, DeleteConflict next, IdDt nextSource, String nextSourceId) {
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(nextSource.getResourceType());
        return (Integer)this.myRetryTemplate.execute(retryContext -> {
            String previousNewTransactionValue = null;
            if (theRequest != null) {
                previousNewTransactionValue = (String)theRequest.getUserData().get(REQ_DET_KEY_IN_NEW_TRANSACTION);
            }
            try {
                Propagation propagation;
                if (retryContext.getRetryCount() > 0) {
                    ourLog.info("Retrying delete of {} - Attempt #{}", (Object)nextSourceId, (Object)retryContext.getRetryCount());
                }
                if (theRequest == null || previousNewTransactionValue != null) {
                    propagation = Propagation.REQUIRED;
                } else {
                    theRequest.getUserData().put(REQ_DET_KEY_IN_NEW_TRANSACTION, REQ_DET_KEY_IN_NEW_TRANSACTION);
                    propagation = Propagation.REQUIRES_NEW;
                }
                this.myTransactionService.withRequest(theRequest).withTransactionDetails(theTransactionDetails).withPropagation(propagation).execute(() -> this.doDelete(theRequest, theConflictList, theTransactionDetails, nextSource, dao));
                Integer n = 1;
                return n;
            }
            catch (ResourceGoneException exception) {
                ourLog.info("{} is already deleted.  Skipping cascade delete of this resource", (Object)nextSourceId);
            }
            finally {
                if (theRequest != null) {
                    theRequest.getUserData().put(REQ_DET_KEY_IN_NEW_TRANSACTION, previousNewTransactionValue);
                }
            }
            return 0;
        });
    }

    private DaoMethodOutcome doDelete(RequestDetails theRequest, DeleteConflictList theConflictList, TransactionDetails theTransactionDetails, IdDt nextSource, IFhirResourceDao<?> dao) {
        IBaseResource resource = dao.read((IIdType)nextSource.toVersionless(), theRequest);
        HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(DeleteConflictList.class, (Object)theConflictList).add(IBaseResource.class, (Object)resource);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_CASCADE_DELETE, (HookParams)params);
        return dao.delete(resource.getIdElement(), theConflictList, theRequest, theTransactionDetails);
    }

    private static RetryTemplate getRetryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        FixedBackOffPolicy fixedBackOffPolicy = new FixedBackOffPolicy();
        fixedBackOffPolicy.setBackOffPeriod(100L);
        retryTemplate.setBackOffPolicy((BackOffPolicy)fixedBackOffPolicy);
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(4, Collections.singletonMap(ResourceVersionConflictException.class, true));
        retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
        return retryTemplate;
    }
}

