/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.delete.batch2;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.data.IResourceLinkDao;
import ca.uhn.fhir.jpa.dao.expunge.ResourceForeignKey;
import ca.uhn.fhir.jpa.dao.expunge.ResourceTableFKProvider;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceLink;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteExpungeSqlBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(DeleteExpungeSqlBuilder.class);
    private final ResourceTableFKProvider myResourceTableFKProvider;
    private final JpaStorageSettings myStorageSettings;
    private final IIdHelperService myIdHelper;
    private final IResourceLinkDao myResourceLinkDao;

    public DeleteExpungeSqlBuilder(ResourceTableFKProvider theResourceTableFKProvider, JpaStorageSettings theStorageSettings, IIdHelperService theIdHelper, IResourceLinkDao theResourceLinkDao) {
        this.myResourceTableFKProvider = theResourceTableFKProvider;
        this.myStorageSettings = theStorageSettings;
        this.myIdHelper = theIdHelper;
        this.myResourceLinkDao = theResourceLinkDao;
    }

    @Nonnull
    DeleteExpungeSqlResult convertPidsToDeleteExpungeSql(List<JpaPid> theJpaPids, boolean theCascade, Integer theCascadeMaxRounds) {
        Set pids = JpaPid.toLongSet(theJpaPids);
        this.validateOkToDeleteAndExpunge(pids, theCascade, theCascadeMaxRounds);
        ArrayList<String> rawSql = new ArrayList<String>();
        String pidListString = pids.toString().replace("[", "(").replace("]", ")");
        List<ResourceForeignKey> resourceForeignKeys = this.myResourceTableFKProvider.getResourceForeignKeys();
        for (ResourceForeignKey resourceForeignKey : resourceForeignKeys) {
            rawSql.add(this.deleteRecordsByColumnSql(pidListString, resourceForeignKey));
        }
        ResourceForeignKey resourceTablePk = new ResourceForeignKey("HFJ_RESOURCE", "RES_ID");
        rawSql.add(this.deleteRecordsByColumnSql(pidListString, resourceTablePk));
        return new DeleteExpungeSqlResult(rawSql, pids.size());
    }

    public void validateOkToDeleteAndExpunge(Set<Long> thePids, boolean theCascade, Integer theCascadeMaxRounds) {
        if (!this.myStorageSettings.isEnforceReferentialIntegrityOnDelete()) {
            ourLog.info("Referential integrity on delete disabled.  Skipping referential integrity check.");
            return;
        }
        List targetPidsAsResourceIds = JpaPid.fromLongList(thePids);
        List<Object> conflictResourceLinks = Collections.synchronizedList(new ArrayList());
        this.findResourceLinksWithTargetPidIn(targetPidsAsResourceIds, targetPidsAsResourceIds, conflictResourceLinks);
        if (conflictResourceLinks.isEmpty()) {
            return;
        }
        if (theCascade) {
            int cascadeMaxRounds = Integer.MAX_VALUE;
            if (theCascadeMaxRounds != null) {
                cascadeMaxRounds = theCascadeMaxRounds;
            }
            if (this.myStorageSettings.getMaximumDeleteConflictQueryCount() != null && this.myStorageSettings.getMaximumDeleteConflictQueryCount() < cascadeMaxRounds) {
                cascadeMaxRounds = this.myStorageSettings.getMaximumDeleteConflictQueryCount();
            }
            while (true) {
                ArrayList<JpaPid> addedThisRound = new ArrayList<JpaPid>();
                for (ResourceLink next : conflictResourceLinks) {
                    Long nextPid = next.getSourceResourcePid();
                    if (!thePids.add(nextPid)) continue;
                    addedThisRound.add(JpaPid.fromId((Long)nextPid));
                }
                if (addedThisRound.isEmpty()) {
                    return;
                }
                if (--cascadeMaxRounds <= 0) break;
                conflictResourceLinks = Collections.synchronizedList(new ArrayList());
                this.findResourceLinksWithTargetPidIn(addedThisRound, addedThisRound, conflictResourceLinks);
            }
        }
        ResourceLink firstConflict = conflictResourceLinks.get(0);
        String sourceResourceId = this.myIdHelper.resourceIdFromPidOrThrowException((IResourcePersistentId)JpaPid.fromId((Long)firstConflict.getSourceResourcePid()), firstConflict.getSourceResourceType()).toVersionless().getValue();
        String targetResourceId = this.myIdHelper.resourceIdFromPidOrThrowException((IResourcePersistentId)JpaPid.fromId((Long)firstConflict.getTargetResourcePid()), firstConflict.getTargetResourceType()).toVersionless().getValue();
        throw new InvalidRequestException(Msg.code((int)822) + "DELETE with _expunge=true failed.  Unable to delete " + targetResourceId + " because " + sourceResourceId + " refers to it via the path " + firstConflict.getSourcePath());
    }

    public void findResourceLinksWithTargetPidIn(List<JpaPid> theAllTargetPids, List<JpaPid> theSomeTargetPids, List<ResourceLink> theConflictResourceLinks) {
        List allTargetPidsAsLongs = JpaPid.toLongList(theAllTargetPids);
        List someTargetPidsAsLongs = JpaPid.toLongList(theSomeTargetPids);
        if (theConflictResourceLinks.isEmpty()) {
            List conflictResourceLinks = this.myResourceLinkDao.findWithTargetPidIn(someTargetPidsAsLongs).stream().filter(link -> !allTargetPidsAsLongs.contains(link.getSourceResourcePid())).collect(Collectors.toList());
            theConflictResourceLinks.addAll(conflictResourceLinks);
        }
    }

    private String deleteRecordsByColumnSql(String thePidListString, ResourceForeignKey theResourceForeignKey) {
        return "DELETE FROM " + theResourceForeignKey.table + " WHERE " + theResourceForeignKey.key + " IN " + thePidListString;
    }

    public static class DeleteExpungeSqlResult {
        private final List<String> mySqlStatements;
        private final int myRecordCount;

        public DeleteExpungeSqlResult(List<String> theSqlStatments, int theRecordCount) {
            this.mySqlStatements = theSqlStatments;
            this.myRecordCount = theRecordCount;
        }

        public List<String> getSqlStatements() {
            return this.mySqlStatements;
        }

        public int getRecordCount() {
            return this.myRecordCount;
        }
    }
}

