/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.batch2.model.WorkChunkMetadata;
import ca.uhn.fhir.batch2.model.WorkChunkStatusEnum;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import java.io.Serializable;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Subselect;

@Entity
@Immutable
@Subselect(value="SELECT e.id as id,  e.seq as seq, e.stat as state,  e.instance_id as instance_id,  e.definition_id as job_definition_id,  e.definition_ver as job_definition_version,  e.tgt_step_id as target_step_id FROM BT2_WORK_CHUNK e")
public class Batch2WorkChunkMetadataView
implements Serializable {
    @Id
    @Column(name="ID", length=100)
    private String myId;
    @Column(name="SEQ", nullable=false)
    private int mySequence;
    @Column(name="STATE", length=100, nullable=false)
    @Enumerated(value=EnumType.STRING)
    private WorkChunkStatusEnum myStatus;
    @Column(name="INSTANCE_ID", length=100, nullable=false)
    private String myInstanceId;
    @Column(name="JOB_DEFINITION_ID", length=100, nullable=false)
    private String myJobDefinitionId;
    @Column(name="JOB_DEFINITION_VERSION", nullable=false)
    private int myJobDefinitionVersion;
    @Column(name="TARGET_STEP_ID", length=100, nullable=false)
    private String myTargetStepId;

    public String getId() {
        return this.myId;
    }

    public void setId(String theId) {
        this.myId = theId;
    }

    public int getSequence() {
        return this.mySequence;
    }

    public void setSequence(int theSequence) {
        this.mySequence = theSequence;
    }

    public WorkChunkStatusEnum getStatus() {
        return this.myStatus;
    }

    public void setStatus(WorkChunkStatusEnum theStatus) {
        this.myStatus = theStatus;
    }

    public String getInstanceId() {
        return this.myInstanceId;
    }

    public void setInstanceId(String theInstanceId) {
        this.myInstanceId = theInstanceId;
    }

    public String getJobDefinitionId() {
        return this.myJobDefinitionId;
    }

    public void setJobDefinitionId(String theJobDefinitionId) {
        this.myJobDefinitionId = theJobDefinitionId;
    }

    public int getJobDefinitionVersion() {
        return this.myJobDefinitionVersion;
    }

    public void setJobDefinitionVersion(int theJobDefinitionVersion) {
        this.myJobDefinitionVersion = theJobDefinitionVersion;
    }

    public String getTargetStepId() {
        return this.myTargetStepId;
    }

    public void setTargetStepId(String theTargetStepId) {
        this.myTargetStepId = theTargetStepId;
    }

    public WorkChunkMetadata toChunkMetadata() {
        WorkChunkMetadata metadata = new WorkChunkMetadata();
        metadata.setId(this.getId());
        metadata.setInstanceId(this.getInstanceId());
        metadata.setSequence(this.getSequence());
        metadata.setStatus(this.getStatus());
        metadata.setJobDefinitionId(this.getJobDefinitionId());
        metadata.setJobDefinitionVersion(this.getJobDefinitionVersion());
        metadata.setTargetStepId(this.getTargetStepId());
        return metadata;
    }
}

