/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.BulkExportCollectionEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.r5.model.InstantType;

@Entity
@Table(name="HFJ_BLK_EXPORT_JOB", uniqueConstraints={@UniqueConstraint(name="IDX_BLKEX_JOB_ID", columnNames={"JOB_ID"})}, indexes={@Index(name="IDX_BLKEX_EXPTIME", columnList="EXP_TIME")})
@Deprecated
public class BulkExportJobEntity
implements Serializable {
    public static final int REQUEST_LENGTH = 1024;
    public static final int STATUS_MESSAGE_LEN = 500;
    public static final String JOB_ID = "JOB_ID";
    public static final String HFJ_BLK_EXPORT_JOB = "HFJ_BLK_EXPORT_JOB";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_BLKEXJOB_PID")
    @SequenceGenerator(name="SEQ_BLKEXJOB_PID", sequenceName="SEQ_BLKEXJOB_PID")
    @Column(name="PID")
    private Long myId;
    @Column(name="JOB_ID", length=36, nullable=false)
    private String myJobId;
    @Column(name="JOB_STATUS", length=10, nullable=false)
    private String myStatus;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_TIME", nullable=false)
    private Date myCreated;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="STATUS_TIME", nullable=false)
    private Date myStatusTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="EXP_TIME", nullable=true)
    private Date myExpiry;
    @Column(name="REQUEST", nullable=false, length=1024)
    private String myRequest;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="myJob", orphanRemoval=false)
    private Collection<BulkExportCollectionEntity> myCollections;
    @Version
    @Column(name="OPTLOCK", nullable=false)
    private int myVersion;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="EXP_SINCE", nullable=true)
    private Date mySince;
    @Column(name="STATUS_MESSAGE", nullable=true, length=500)
    private String myStatusMessage;

    public Date getCreated() {
        return this.myCreated;
    }

    public void setCreated(Date theCreated) {
        this.myCreated = theCreated;
    }

    public String getStatusMessage() {
        return this.myStatusMessage;
    }

    public void setStatusMessage(String theStatusMessage) {
        this.myStatusMessage = StringUtils.left((String)theStatusMessage, (int)500);
    }

    public String getRequest() {
        return this.myRequest;
    }

    public void setRequest(String theRequest) {
        this.myRequest = theRequest;
    }

    public void setExpiry(Date theExpiry) {
        this.myExpiry = theExpiry;
    }

    public Collection<BulkExportCollectionEntity> getCollections() {
        if (this.myCollections == null) {
            this.myCollections = new ArrayList<BulkExportCollectionEntity>();
        }
        return this.myCollections;
    }

    public String getJobId() {
        return this.myJobId;
    }

    public void setJobId(String theJobId) {
        this.myJobId = theJobId;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("pid", (Object)this.myId);
        if (StringUtils.isNotBlank((CharSequence)this.myJobId)) {
            b.append("jobId", (Object)this.myJobId);
        }
        if (this.myStatus != null) {
            b.append("status", (Object)(this.myStatus + " " + new InstantType(this.myStatusTime).getValueAsString()));
        }
        b.append("created", (Object)new InstantType(this.myCreated).getValueAsString());
        b.append("expiry", (Object)new InstantType(this.myExpiry).getValueAsString());
        b.append("request", (Object)this.myRequest);
        b.append("since", (Object)this.mySince);
        if (StringUtils.isNotBlank((CharSequence)this.myStatusMessage)) {
            b.append("statusMessage", (Object)this.myStatusMessage);
        }
        return b.toString();
    }

    public String getStatus() {
        return this.myStatus;
    }

    public void setStatus(String theStatus) {
        if (this.myStatus != theStatus) {
            this.myStatusTime = new Date();
            this.myStatus = theStatus;
        }
    }

    public Date getStatusTime() {
        return this.myStatusTime;
    }

    public int getVersion() {
        return this.myVersion;
    }

    public void setVersion(int theVersion) {
        this.myVersion = theVersion;
    }

    public Long getId() {
        return this.myId;
    }

    public Date getSince() {
        if (this.mySince != null) {
            return new Date(this.mySince.getTime());
        }
        return null;
    }

    public void setSince(Date theSince) {
        this.mySince = theSince;
    }
}

