/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.entity;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.util.ValidateUtil;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table(name="TRM_CONCEPT_DESIG", uniqueConstraints={}, indexes={@Index(name="FK_CONCEPTDESIG_CONCEPT", columnList="CONCEPT_PID", unique=false), @Index(name="FK_CONCEPTDESIG_CSV", columnList="CS_VER_PID")})
public class TermConceptDesignation
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_LENGTH = 500;
    public static final int MAX_VAL_LENGTH = 2000;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONCEPT_PID", referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_CONCEPTDESIG_CONCEPT"))
    private TermConcept myConcept;
    @Id
    @SequenceGenerator(name="SEQ_CONCEPT_DESIG_PID", sequenceName="SEQ_CONCEPT_DESIG_PID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_CONCEPT_DESIG_PID")
    @Column(name="PID")
    private Long myId;
    @Column(name="LANG", nullable=true, length=500)
    private String myLanguage;
    @Column(name="USE_SYSTEM", nullable=true, length=500)
    private String myUseSystem;
    @Column(name="USE_CODE", nullable=true, length=500)
    private String myUseCode;
    @Column(name="USE_DISPLAY", nullable=true, length=500)
    private String myUseDisplay;
    @Column(name="VAL", nullable=true, length=2000)
    private String myValue;
    @Column(name="VAL_VC", nullable=true, length=0x7FFFFFFF)
    private String myValueVc;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CS_VER_PID", nullable=true, referencedColumnName="PID", foreignKey=@ForeignKey(name="FK_CONCEPTDESIG_CSV"))
    private TermCodeSystemVersion myCodeSystemVersion;

    public String getLanguage() {
        return this.myLanguage;
    }

    public TermConceptDesignation setLanguage(String theLanguage) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theLanguage, (int)500, (String)("Language exceeds maximum length (500): " + StringUtils.length((CharSequence)theLanguage)));
        this.myLanguage = theLanguage;
        return this;
    }

    public String getUseCode() {
        return this.myUseCode;
    }

    public TermConceptDesignation setUseCode(String theUseCode) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theUseCode, (int)500, (String)("Use code exceeds maximum length (500): " + StringUtils.length((CharSequence)theUseCode)));
        this.myUseCode = theUseCode;
        return this;
    }

    public String getUseDisplay() {
        return this.myUseDisplay;
    }

    public TermConceptDesignation setUseDisplay(String theUseDisplay) {
        this.myUseDisplay = StringUtils.left((String)theUseDisplay, (int)500);
        return this;
    }

    public String getUseSystem() {
        return this.myUseSystem;
    }

    public TermConceptDesignation setUseSystem(String theUseSystem) {
        ValidateUtil.isNotTooLongOrThrowIllegalArgument((String)theUseSystem, (int)500, (String)("Use system exceeds maximum length (500): " + StringUtils.length((CharSequence)theUseSystem)));
        this.myUseSystem = theUseSystem;
        return this;
    }

    public String getValue() {
        return Objects.nonNull(this.myValueVc) ? this.myValueVc : this.myValue;
    }

    public TermConceptDesignation setValue(@Nonnull String theValueVc) {
        this.myValueVc = theValueVc;
        return this;
    }

    public TermConceptDesignation setCodeSystemVersion(TermCodeSystemVersion theCodeSystemVersion) {
        this.myCodeSystemVersion = theCodeSystemVersion;
        return this;
    }

    public TermConceptDesignation setConcept(TermConcept theConcept) {
        this.myConcept = theConcept;
        return this;
    }

    public Long getPid() {
        return this.myId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("conceptPid", (Object)this.myConcept.getId()).append("pid", (Object)this.myId).append("language", (Object)this.myLanguage).append("useSystem", (Object)this.myUseSystem).append("useCode", (Object)this.myUseCode).append("useDisplay", (Object)this.myUseDisplay).append("value", (Object)this.myValue).toString();
    }
}

