/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.model.DeleteConflict;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class OverridePathBasedReferentialIntegrityForDeletesInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(OverridePathBasedReferentialIntegrityForDeletesInterceptor.class);
    private final Set<String> myPaths = new HashSet<String>();
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private DaoRegistry myDaoRegistry;

    public void addPath(String thePath) {
        this.getPaths().add(thePath);
    }

    public void clearPaths() {
        this.getPaths().clear();
    }

    public Set<String> getPaths() {
        return this.myPaths;
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_DELETE_CONFLICTS, order=0)
    public void handleDeleteConflicts(DeleteConflictList theDeleteConflictList, RequestDetails requestDetails) {
        for (DeleteConflict nextConflict : theDeleteConflictList) {
            ourLog.info("Ignoring referential integrity deleting {} - Referred to from {} at path {}", new Object[]{nextConflict.getTargetId(), nextConflict.getSourceId(), nextConflict.getSourcePath()});
            IdDt sourceId = nextConflict.getSourceId();
            IdDt targetId = nextConflict.getTargetId();
            String targetIdValue = targetId.toVersionless().getValue();
            IBaseResource sourceResource = this.myDaoRegistry.getResourceDao(sourceId.getResourceType()).read((IIdType)sourceId, requestDetails);
            IFhirPath fhirPath = this.myFhirContext.newFhirPath();
            block1: for (String nextPath : this.myPaths) {
                List selections = fhirPath.evaluate((IBase)sourceResource, nextPath, IBaseReference.class);
                for (IBaseReference nextSelection : selections) {
                    String selectionTargetValue = nextSelection.getReferenceElement().toVersionless().getValue();
                    if (!Objects.equals(targetIdValue, selectionTargetValue)) continue;
                    theDeleteConflictList.setResourceIdToIgnoreConflict((IIdType)nextConflict.getTargetId());
                    continue block1;
                }
            }
        }
    }
}

