/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.packages.IHapiPackageCacheManager;
import jakarta.annotation.Nullable;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;

public class NpmJpaValidationSupport
implements IValidationSupport {
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IHapiPackageCacheManager myHapiPackageCacheManager;

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    public IBaseResource fetchValueSet(String theUri) {
        return this.fetchResource("ValueSet", theUri);
    }

    public IBaseResource fetchCodeSystem(String theUri) {
        return this.fetchResource("CodeSystem", theUri);
    }

    public IBaseResource fetchStructureDefinition(String theUri) {
        return this.fetchResource("StructureDefinition", theUri);
    }

    @Nullable
    public IBaseResource fetchResource(String theResourceType, String theUri) {
        Class type;
        FhirVersionEnum fhirVersion = this.myFhirContext.getVersion().getVersion();
        IBaseResource asset = this.myHapiPackageCacheManager.loadPackageAssetByUrl(fhirVersion, theUri);
        if (asset != null && (type = this.myFhirContext.getResourceDefinition(theResourceType).getImplementingClass()).isAssignableFrom(asset.getClass())) {
            return asset;
        }
        return null;
    }

    @Nullable
    public <T extends IBaseResource> List<T> fetchAllStructureDefinitions() {
        FhirVersionEnum fhirVersion = this.myFhirContext.getVersion().getVersion();
        return this.myHapiPackageCacheManager.loadPackageAssetsByType(fhirVersion, "StructureDefinition");
    }
}

