/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.packages;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.dao.data.INpmPackageVersionDao;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.dao.validation.SearchParameterDaoValidator;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.NpmPackageVersionEntity;
import ca.uhn.fhir.jpa.packages.IHapiPackageCacheManager;
import ca.uhn.fhir.jpa.packages.IPackageInstallerSvc;
import ca.uhn.fhir.jpa.packages.ImplementationGuideInstallationException;
import ca.uhn.fhir.jpa.packages.JpaPackageCache;
import ca.uhn.fhir.jpa.packages.PackageDeleteOutcomeJson;
import ca.uhn.fhir.jpa.packages.PackageInstallOutcomeJson;
import ca.uhn.fhir.jpa.packages.PackageInstallationSpec;
import ca.uhn.fhir.jpa.packages.loader.PackageResourceParsingSvc;
import ca.uhn.fhir.jpa.packages.util.PackageUtils;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.registry.ISearchParamRegistryController;
import ca.uhn.fhir.jpa.searchparam.util.SearchParameterHelper;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.SearchParameterUtil;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PackageInstallerSvcImpl
implements IPackageInstallerSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(PackageInstallerSvcImpl.class);
    boolean enabled = true;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IValidationSupport validationSupport;
    @Autowired
    private IHapiPackageCacheManager myPackageCacheManager;
    @Autowired
    private IHapiTransactionService myTxService;
    @Autowired
    private INpmPackageVersionDao myPackageVersionDao;
    @Autowired
    private ISearchParamRegistryController mySearchParamRegistryController;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private SearchParameterHelper mySearchParameterHelper;
    @Autowired
    private PackageResourceParsingSvc myPackageResourceParsingSvc;
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private SearchParameterDaoValidator mySearchParameterDaoValidator;
    @Autowired
    private VersionCanonicalizer myVersionCanonicalizer;

    @PostConstruct
    public void initialize() {
        switch (this.myFhirContext.getVersion().getVersion()) {
            case R5: 
            case R4B: 
            case R4: 
            case DSTU3: {
                break;
            }
            default: {
                ourLog.info("IG installation not supported for version: {}", (Object)this.myFhirContext.getVersion().getVersion());
                this.enabled = false;
            }
        }
    }

    @Override
    public PackageDeleteOutcomeJson uninstall(PackageInstallationSpec theInstallationSpec) {
        PackageDeleteOutcomeJson outcome = this.myPackageCacheManager.uninstallPackage(theInstallationSpec.getName(), theInstallationSpec.getVersion());
        this.validationSupport.invalidateCaches();
        return outcome;
    }

    @Override
    public PackageInstallOutcomeJson install(PackageInstallationSpec theInstallationSpec) throws ImplementationGuideInstallationException {
        PackageInstallOutcomeJson retVal = new PackageInstallOutcomeJson();
        if (this.enabled) {
            try {
                NpmPackage npmPackage;
                boolean exists = (Boolean)this.myTxService.withSystemRequest().withRequestPartitionId(RequestPartitionId.defaultPartition()).execute(() -> {
                    Optional<NpmPackageVersionEntity> existing = this.myPackageVersionDao.findByPackageIdAndVersion(theInstallationSpec.getName(), theInstallationSpec.getVersion());
                    return existing.isPresent();
                });
                if (exists) {
                    ourLog.info("Package {}#{} is already installed", (Object)theInstallationSpec.getName(), (Object)theInstallationSpec.getVersion());
                }
                if ((npmPackage = this.myPackageCacheManager.installPackage(theInstallationSpec)) == null) {
                    throw new IOException(Msg.code((int)1284) + "Package not found");
                }
                retVal.getMessage().addAll(JpaPackageCache.getProcessingMessages(npmPackage));
                if (theInstallationSpec.isFetchDependencies()) {
                    this.fetchAndInstallDependencies(npmPackage, theInstallationSpec, retVal);
                }
                if (theInstallationSpec.getInstallMode() == PackageInstallationSpec.InstallModeEnum.STORE_AND_INSTALL) {
                    this.install(npmPackage, theInstallationSpec, retVal);
                    this.mySearchParamRegistryController.refreshCacheIfNecessary();
                }
                this.validationSupport.invalidateCaches();
            }
            catch (IOException e) {
                throw new ImplementationGuideInstallationException(Msg.code((int)1285) + "Could not load NPM package " + theInstallationSpec.getName() + "#" + theInstallationSpec.getVersion(), e);
            }
        }
        return retVal;
    }

    private void install(NpmPackage npmPackage, PackageInstallationSpec theInstallationSpec, PackageInstallOutcomeJson theOutcome) throws ImplementationGuideInstallationException {
        int i;
        String name = npmPackage.getNpm().get("name").asJsonString().getValue();
        String version = npmPackage.getNpm().get("version").asJsonString().getValue();
        String fhirVersion = npmPackage.fhirVersion();
        String currentFhirVersion = this.myFhirContext.getVersion().getVersion().getFhirVersionString();
        this.assertFhirVersionsAreCompatible(fhirVersion, currentFhirVersion);
        List<String> installTypes = !theInstallationSpec.getInstallResourceTypes().isEmpty() ? theInstallationSpec.getInstallResourceTypes() : PackageUtils.DEFAULT_INSTALL_TYPES;
        ourLog.info("Installing package: {}#{}", (Object)name, (Object)version);
        int[] count = new int[installTypes.size()];
        for (i = 0; i < installTypes.size(); ++i) {
            String type = installTypes.get(i);
            List<IBaseResource> resources = this.myPackageResourceParsingSvc.parseResourcesOfType(type, npmPackage);
            count[i] = resources.size();
            for (IBaseResource next : resources) {
                try {
                    next = this.isStructureDefinitionWithoutSnapshot(next) ? this.generateSnapshot(next) : next;
                    this.install(next, theInstallationSpec, theOutcome);
                }
                catch (Exception e) {
                    ourLog.warn("Failed to upload resource of type {} with ID {} - Error: {}", new Object[]{this.myFhirContext.getResourceType(next), next.getIdElement().getValue(), e.toString()});
                    throw new ImplementationGuideInstallationException(Msg.code((int)1286) + String.format("Error installing IG %s#%s: %s", name, version, e), e);
                }
            }
        }
        ourLog.info(String.format("Finished installation of package %s#%s:", name, version));
        for (i = 0; i < count.length; ++i) {
            ourLog.info(String.format("-- Created or updated %s resources of type %s", count[i], installTypes.get(i)));
        }
    }

    private void fetchAndInstallDependencies(NpmPackage npmPackage, PackageInstallationSpec theInstallationSpec, PackageInstallOutcomeJson theOutcome) throws ImplementationGuideInstallationException {
        if (npmPackage.getNpm().has("dependencies")) {
            JsonObject dependenciesElement = npmPackage.getNpm().get("dependencies").asJsonObject();
            for (String id : dependenciesElement.getNames()) {
                String ver = dependenciesElement.getJsonString(id).asString();
                try {
                    theOutcome.getMessage().add("Package " + npmPackage.id() + "#" + npmPackage.version() + " depends on package " + id + "#" + ver);
                    boolean skip = false;
                    for (String next : theInstallationSpec.getDependencyExcludes()) {
                        if (!id.matches(next)) continue;
                        theOutcome.getMessage().add("Not installing dependency " + id + " because it matches exclude criteria: " + next);
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    NpmPackage dependency = this.myPackageCacheManager.loadPackage(id, ver);
                    this.fetchAndInstallDependencies(dependency, theInstallationSpec, theOutcome);
                    if (theInstallationSpec.getInstallMode() != PackageInstallationSpec.InstallModeEnum.STORE_AND_INSTALL) continue;
                    this.install(dependency, theInstallationSpec, theOutcome);
                }
                catch (IOException e) {
                    throw new ImplementationGuideInstallationException(Msg.code((int)1287) + String.format("Cannot resolve dependency %s#%s", id, ver), e);
                }
            }
        }
    }

    protected void assertFhirVersionsAreCompatible(String fhirVersion, String currentFhirVersion) throws ImplementationGuideInstallationException {
        FhirVersionEnum fhirVersionEnum = FhirVersionEnum.forVersionString((String)fhirVersion);
        FhirVersionEnum currentFhirVersionEnum = FhirVersionEnum.forVersionString((String)currentFhirVersion);
        Validate.notNull((Object)fhirVersionEnum, (String)"Invalid FHIR version string: %s", (Object[])new Object[]{fhirVersion});
        Validate.notNull((Object)currentFhirVersionEnum, (String)"Invalid FHIR version string: %s", (Object[])new Object[]{currentFhirVersion});
        boolean compatible = fhirVersionEnum.equals((Object)currentFhirVersionEnum);
        if (!compatible && fhirVersion.startsWith("R4") && currentFhirVersion.startsWith("R4")) {
            compatible = true;
        }
        if (!compatible) {
            throw new ImplementationGuideInstallationException(Msg.code((int)1288) + String.format("Cannot install implementation guide: FHIR versions mismatch (expected <=%s, package uses %s)", currentFhirVersion, fhirVersion));
        }
    }

    @VisibleForTesting
    void install(IBaseResource theResource, PackageInstallationSpec theInstallationSpec, PackageInstallOutcomeJson theOutcome) {
        IBaseResource existingResource;
        boolean isInstalled;
        if (!this.validForUpload(theResource)) {
            ourLog.warn("Failed to upload resource of type {} with ID {} - Error: Resource failed validation", (Object)theResource.fhirType(), (Object)theResource.getIdElement().getValue());
            return;
        }
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResource.getClass());
        SearchParameterMap map = this.createSearchParameterMapFor(theResource);
        IBundleProvider searchResult = this.searchResource(dao, map);
        String resourceQuery = map.toNormalizedQueryString(this.myFhirContext);
        if (!searchResult.isEmpty() && !theInstallationSpec.isReloadExisting()) {
            ourLog.info("Skipping update of existing resource matching {}", (Object)resourceQuery);
            return;
        }
        if (!searchResult.isEmpty()) {
            ourLog.info("Updating existing resource matching {}", (Object)resourceQuery);
        }
        if (isInstalled = this.createOrUpdateResource(dao, theResource, existingResource = !searchResult.isEmpty() ? (IBaseResource)searchResult.getResources(0, 1).get(0) : null)) {
            theOutcome.incrementResourcesInstalled(this.myFhirContext.getResourceType(theResource));
        }
    }

    private Optional<IBaseResource> readResourceById(IFhirResourceDao dao, IIdType id) {
        try {
            return Optional.ofNullable(dao.read(id.toUnqualifiedVersionless(), this.createRequestDetails()));
        }
        catch (Exception exception) {
            ourLog.warn("Exception when trying to read resource with ID: {}, message: {}", (Object)id, (Object)exception.getMessage());
            return Optional.empty();
        }
    }

    private IBundleProvider searchResource(IFhirResourceDao theDao, SearchParameterMap theMap) {
        return theDao.search(theMap, this.createRequestDetails());
    }

    protected boolean createOrUpdateResource(IFhirResourceDao theDao, IBaseResource theResource, IBaseResource theExistingResource) {
        boolean shouldOverrideId;
        IIdType id = theResource.getIdElement();
        if (theExistingResource == null && id.isEmpty()) {
            ourLog.debug("Install resource without id will be created");
            theDao.create(theResource, this.createRequestDetails());
            return true;
        }
        if (theExistingResource == null && !id.isEmpty() && id.isIdPartValidLong()) {
            String newIdPart = "npm-" + id.getIdPart();
            id.setParts(id.getBaseUrl(), id.getResourceType(), newIdPart, id.getVersionIdPart());
        }
        boolean isExistingUpdated = this.updateExistingResourceIfNecessary(theDao, theResource, theExistingResource);
        boolean bl = shouldOverrideId = theExistingResource != null && !isExistingUpdated;
        if (shouldOverrideId) {
            ourLog.debug("Existing resource {} will be overridden with installed resource {}", (Object)theExistingResource.getIdElement(), (Object)id);
            theResource.setId(theExistingResource.getIdElement().toUnqualifiedVersionless());
        } else {
            ourLog.debug("Install resource {} will be created", (Object)id);
        }
        DaoMethodOutcome outcome = this.updateResource(theDao, theResource);
        return outcome != null && !outcome.isNop();
    }

    private boolean updateExistingResourceIfNecessary(IFhirResourceDao theDao, IBaseResource theResource, IBaseResource theExistingResource) {
        if (!"SearchParameter".equals(theResource.getClass().getSimpleName())) {
            return false;
        }
        if (theExistingResource == null) {
            return false;
        }
        if (theExistingResource.getIdElement().getIdPart().equals(theResource.getIdElement().getIdPart())) {
            return false;
        }
        HashSet remainingBaseList = new HashSet(SearchParameterUtil.getBaseAsStrings((FhirContext)this.myFhirContext, (IBaseResource)theExistingResource));
        remainingBaseList.removeAll(SearchParameterUtil.getBaseAsStrings((FhirContext)this.myFhirContext, (IBaseResource)theResource));
        if (remainingBaseList.isEmpty()) {
            return false;
        }
        this.myFhirContext.getResourceDefinition(theExistingResource).getChildByName("base").getMutator().setValue((IBase)theExistingResource, null);
        for (String baseResourceName : remainingBaseList) {
            this.myFhirContext.newTerser().addElement((IBase)theExistingResource, "base", baseResourceName);
        }
        ourLog.info("Existing SearchParameter {} will be updated with base {}", (Object)theExistingResource.getIdElement().getIdPart(), remainingBaseList);
        this.updateResource(theDao, theExistingResource);
        return true;
    }

    private DaoMethodOutcome updateResource(IFhirResourceDao theDao, IBaseResource theResource) {
        DaoMethodOutcome outcome = null;
        IIdType id = theResource.getIdElement();
        RequestDetails requestDetails = this.createRequestDetails();
        try {
            outcome = theDao.update(theResource, requestDetails);
        }
        catch (ResourceVersionConflictException exception) {
            Optional<IBaseResource> optResource = this.readResourceById(theDao, id);
            String existingResourceUrlOrNull = optResource.filter(MetadataResource.class::isInstance).map(MetadataResource.class::cast).map(MetadataResource::getUrl).orElse(null);
            String newResourceUrlOrNull = theResource instanceof MetadataResource ? ((MetadataResource)theResource).getUrl() : null;
            ourLog.error("Version conflict error: This is possibly due to a collision between ValueSets from different IGs that are coincidentally using the same resource ID: [{}] and new resource URL: [{}], with the exisitng resource having URL: [{}].  Ignoring this update and continuing:  The first IG wins.  ", new Object[]{id.getIdPart(), newResourceUrlOrNull, existingResourceUrlOrNull, exception});
        }
        return outcome;
    }

    private RequestDetails createRequestDetails() {
        SystemRequestDetails requestDetails = new SystemRequestDetails();
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            requestDetails.setRequestPartitionId(RequestPartitionId.defaultPartition());
        }
        return requestDetails;
    }

    boolean validForUpload(IBaseResource theResource) {
        String resourceType = this.myFhirContext.getResourceType(theResource);
        if ("SearchParameter".equals(resourceType) && !this.isValidSearchParameter(theResource)) {
            return false;
        }
        if (!this.isValidResourceStatusForPackageUpload(theResource)) {
            ourLog.warn("Failed to validate resource of type {} with ID {} - Error: Resource status not accepted value.", (Object)theResource.fhirType(), (Object)theResource.getIdElement().getValue());
            return false;
        }
        return true;
    }

    private boolean isValidSearchParameter(IBaseResource theResource) {
        try {
            SearchParameter searchParameter = this.myVersionCanonicalizer.searchParameterToCanonical(theResource);
            this.mySearchParameterDaoValidator.validate(searchParameter);
            return true;
        }
        catch (UnprocessableEntityException unprocessableEntityException) {
            ourLog.error("The SearchParameter with URL {} is invalid. Validation Error: {}", (Object)SearchParameterUtil.getURL((FhirContext)this.myFhirContext, (IBaseResource)theResource), (Object)unprocessableEntityException.getMessage());
            return false;
        }
    }

    private boolean isValidResourceStatusForPackageUpload(IBaseResource theResource) {
        if (!this.myStorageSettings.isValidateResourceStatusForPackageUpload()) {
            return true;
        }
        List statusTypes = this.myFhirContext.newFhirPath().evaluate((IBase)theResource, "status", IPrimitiveType.class);
        if (statusTypes.isEmpty()) {
            return true;
        }
        if (!((IPrimitiveType)statusTypes.get(0)).hasValue() || ((IPrimitiveType)statusTypes.get(0)).getValue() == null) {
            return false;
        }
        switch (theResource.fhirType()) {
            case "Subscription": {
                return ((IPrimitiveType)statusTypes.get(0)).getValueAsString().equals("requested");
            }
            case "DocumentReference": 
            case "Communication": {
                return ((IPrimitiveType)statusTypes.get(0)).isEmpty() || !((IPrimitiveType)statusTypes.get(0)).getValueAsString().equals("?");
            }
        }
        return ((IPrimitiveType)statusTypes.get(0)).getValueAsString().equals("active");
    }

    private boolean isStructureDefinitionWithoutSnapshot(IBaseResource r) {
        Optional kind;
        boolean retVal = false;
        FhirTerser terser = this.myFhirContext.newTerser();
        if (r.getClass().getSimpleName().equals("StructureDefinition") && (kind = terser.getSinglePrimitiveValue((IBase)r, "kind")).isPresent() && !((String)kind.get()).equals("logical")) {
            retVal = terser.getSingleValueOrNull((IBase)r, "snapshot") == null;
        }
        return retVal;
    }

    private IBaseResource generateSnapshot(IBaseResource sd) {
        try {
            return this.validationSupport.generateSnapshot(new ValidationSupportContext(this.validationSupport), sd, null, null, null);
        }
        catch (Exception e) {
            throw new ImplementationGuideInstallationException(Msg.code((int)1290) + String.format("Failure when generating snapshot of StructureDefinition: %s", sd.getIdElement()), e);
        }
    }

    private SearchParameterMap createSearchParameterMapFor(IBaseResource theResource) {
        String resourceType = theResource.getClass().getSimpleName();
        if ("NamingSystem".equals(resourceType)) {
            String uniqueId = this.extractUniqeIdFromNamingSystem(theResource);
            return SearchParameterMap.newSynchronous().add("value", (IQueryParameterType)new StringParam(uniqueId).setExact(true));
        }
        if ("Subscription".equals(resourceType)) {
            String id = this.extractSimpleValue((IBase)theResource, "id");
            return SearchParameterMap.newSynchronous().add("_id", (IQueryParameterType)new TokenParam(id));
        }
        if ("SearchParameter".equals(resourceType)) {
            return this.buildSearchParameterMapForSearchParameter(theResource);
        }
        if (this.resourceHasUrlElement(theResource)) {
            String url = this.extractSimpleValue((IBase)theResource, "url");
            return SearchParameterMap.newSynchronous().add("url", (IQueryParameterType)new UriParam(url));
        }
        TokenParam identifierToken = this.extractIdentifierFromOtherResourceTypes(theResource);
        return SearchParameterMap.newSynchronous().add("identifier", (IQueryParameterType)identifierToken);
    }

    private SearchParameterMap buildSearchParameterMapForSearchParameter(IBaseResource theResource) {
        Optional spmFromCanonicalized = this.mySearchParameterHelper.buildSearchParameterMapFromCanonical(theResource);
        if (spmFromCanonicalized.isPresent()) {
            return (SearchParameterMap)spmFromCanonicalized.get();
        }
        if (this.resourceHasUrlElement(theResource)) {
            String url = this.extractSimpleValue((IBase)theResource, "url");
            return SearchParameterMap.newSynchronous().add("url", (IQueryParameterType)new UriParam(url));
        }
        TokenParam identifierToken = this.extractIdentifierFromOtherResourceTypes(theResource);
        return SearchParameterMap.newSynchronous().add("identifier", (IQueryParameterType)identifierToken);
    }

    private String extractUniqeIdFromNamingSystem(IBaseResource theResource) {
        IBase uniqueIdComponent = (IBase)this.extractValue((IBase)theResource, "uniqueId");
        if (uniqueIdComponent == null) {
            throw new ImplementationGuideInstallationException(Msg.code((int)1291) + "NamingSystem does not have uniqueId component.");
        }
        return this.extractSimpleValue(uniqueIdComponent, "value");
    }

    private TokenParam extractIdentifierFromOtherResourceTypes(IBaseResource theResource) {
        Identifier identifier = (Identifier)this.extractValue((IBase)theResource, "identifier");
        if (identifier != null) {
            return new TokenParam(identifier.getSystem(), identifier.getValue());
        }
        throw new UnsupportedOperationException(Msg.code((int)1292) + "Resources in a package must have a url or identifier to be loaded by the package installer.");
    }

    private Object extractValue(IBase theResource, String thePath) {
        return this.myFhirContext.newTerser().getSingleValueOrNull(theResource, thePath);
    }

    private String extractSimpleValue(IBase theResource, String thePath) {
        IPrimitiveType asPrimitiveType = (IPrimitiveType)this.extractValue(theResource, thePath);
        return (String)asPrimitiveType.getValue();
    }

    private boolean resourceHasUrlElement(IBaseResource resource) {
        BaseRuntimeElementDefinition def = this.myFhirContext.getElementDefinition(resource.getClass());
        if (!(def instanceof BaseRuntimeElementCompositeDefinition)) {
            throw new IllegalArgumentException(Msg.code((int)1293) + "Resource is not a composite type: " + resource.getClass().getName());
        }
        BaseRuntimeElementCompositeDefinition currentDef = (BaseRuntimeElementCompositeDefinition)def;
        BaseRuntimeChildDefinition nextDef = currentDef.getChildByName("url");
        return nextDef != null;
    }

    @VisibleForTesting
    void setFhirContextForUnitTest(FhirContext theCtx) {
        this.myFhirContext = theCtx;
    }
}

