/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoComposition;
import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import jakarta.servlet.http.HttpServletRequest;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BaseJpaResourceProviderComposition<T extends IBaseResource>
extends BaseJpaResourceProvider<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$document", idempotent=true, bundleType=BundleTypeEnum.DOCUMENT)
    public IBundleProvider getDocumentForComposition(HttpServletRequest theServletRequest, @IdParam IIdType theId, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the size of those pages.") @OperationParam(name="_count", typeName="unsignedInt") IPrimitiveType<Integer> theCount, @Description(formalDefinition="Results from this method are returned across multiple pages. This parameter controls the offset when fetching a page.") @OperationParam(name="_offset", typeName="unsignedInt") IPrimitiveType<Integer> theOffset, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OperationParam(name="_lastUpdated", min=0, max=1) DateRangeParam theLastUpdated, @Sort SortSpec theSortSpec, RequestDetails theRequestDetails) {
        BaseJpaResourceProviderComposition.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider bundleProvider;
            IBundleProvider iBundleProvider = bundleProvider = ((IFhirResourceDaoComposition)this.getDao()).getDocumentForComposition(theServletRequest, theId, theCount, theOffset, theLastUpdated, theSortSpec, theRequestDetails);
            return iBundleProvider;
        }
        finally {
            BaseJpaResourceProviderComposition.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

