/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.util.ResourceCountCache;
import ca.uhn.fhir.model.dstu2.composite.MetaDt;
import ca.uhn.fhir.model.dstu2.resource.Bundle;
import ca.uhn.fhir.model.dstu2.resource.Conformance;
import ca.uhn.fhir.model.dstu2.valueset.ConditionalDeleteStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.SearchParamTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.provider.dstu2.ServerConformanceProvider;
import ca.uhn.fhir.util.CoverageIgnore;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseDatatype;

public class JpaConformanceProviderDstu2
extends ServerConformanceProvider {
    private volatile Conformance myCachedValue;
    private JpaStorageSettings myStorageSettings;
    private String myImplementationDescription;
    private boolean myIncludeResourceCounts;
    private RestfulServer myRestfulServer;
    private IFhirSystemDao<Bundle, MetaDt> mySystemDao;
    private ResourceCountCache myResourceCountsCache;

    @CoverageIgnore
    public JpaConformanceProviderDstu2() {
        super.setCache(false);
        this.setIncludeResourceCounts(true);
    }

    public JpaConformanceProviderDstu2(RestfulServer theRestfulServer, IFhirSystemDao<Bundle, MetaDt> theSystemDao, JpaStorageSettings theStorageSettings) {
        super(theRestfulServer);
        this.myRestfulServer = theRestfulServer;
        this.mySystemDao = theSystemDao;
        this.myStorageSettings = theStorageSettings;
        super.setCache(false);
        this.setIncludeResourceCounts(true);
    }

    public Conformance getServerConformance(HttpServletRequest theRequest, RequestDetails theRequestDetails) {
        Conformance retVal = this.myCachedValue;
        Map counts = null;
        if (this.myIncludeResourceCounts) {
            counts = this.mySystemDao.getResourceCountsFromCache();
        }
        counts = (Map)ObjectUtils.defaultIfNull(counts, Collections.emptyMap());
        FhirContext ctx = this.myRestfulServer.getFhirContext();
        retVal = super.getServerConformance(theRequest, theRequestDetails);
        for (Conformance.Rest nextRest : retVal.getRest()) {
            for (Conformance.RestResource nextResource : nextRest.getResource()) {
                Long count;
                ConditionalDeleteStatusEnum conditionalDelete = (ConditionalDeleteStatusEnum)nextResource.getConditionalDeleteElement().getValueAsEnum();
                if (conditionalDelete == ConditionalDeleteStatusEnum.MULTIPLE_DELETES_SUPPORTED && !this.myStorageSettings.isAllowMultipleDelete()) {
                    nextResource.setConditionalDelete(ConditionalDeleteStatusEnum.SINGLE_DELETES_SUPPORTED);
                }
                if ((count = (Long)counts.get(nextResource.getTypeElement().getValueAsString())) != null) {
                    nextResource.addUndeclaredExtension(false, "http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#resourceCount", (IBaseDatatype)new DecimalDt(count.longValue()));
                }
                for (Conformance.RestResourceSearchParam nextParam : nextResource.getSearchParam()) {
                    if (nextParam.getTypeElement().getValueAsEnum() != SearchParamTypeEnum.REFERENCE) continue;
                    List targets = nextParam.getTarget();
                    for (BoundCodeDt next : targets) {
                        RuntimeResourceDefinition def = ctx.getResourceDefinition((String)next.getValue());
                        for (RuntimeSearchParam nextChainedParam : def.getSearchParams()) {
                            nextParam.addChain(nextChainedParam.getName());
                        }
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.myImplementationDescription)) {
            retVal.getImplementation().setDescription(this.myImplementationDescription);
        }
        this.myCachedValue = retVal;
        return retVal;
    }

    public boolean isIncludeResourceCounts() {
        return this.myIncludeResourceCounts;
    }

    public void setStorageSettings(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    @CoverageIgnore
    public void setImplementationDescription(String theImplDesc) {
        this.myImplementationDescription = theImplDesc;
    }

    public void setIncludeResourceCounts(boolean theIncludeResourceCounts) {
        this.myIncludeResourceCounts = theIncludeResourceCounts;
    }

    public void setRestfulServer(RestfulServer theRestfulServer) {
        this.myRestfulServer = theRestfulServer;
        super.setRestfulServer(theRestfulServer);
    }

    @CoverageIgnore
    public void setSystemDao(IFhirSystemDao<Bundle, MetaDt> mySystemDao) {
        this.mySystemDao = mySystemDao;
    }
}

