/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.provider.BaseJpaProvider;
import ca.uhn.fhir.jpa.term.UploadStatistics;
import ca.uhn.fhir.jpa.term.api.ITermLoaderSvc;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.AttachmentUtil;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.ValidateUtil;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_40;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r5.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TerminologyUploaderProvider
extends BaseJpaProvider {
    public static final String PARAM_FILE = "file";
    public static final String PARAM_CODESYSTEM = "codeSystem";
    public static final String PARAM_SYSTEM = "system";
    private static final String RESP_PARAM_CONCEPT_COUNT = "conceptCount";
    private static final String RESP_PARAM_TARGET = "target";
    private static final Logger ourLog = LoggerFactory.getLogger(TerminologyUploaderProvider.class);
    private static final String RESP_PARAM_SUCCESS = "success";
    @Autowired
    private ITermLoaderSvc myTerminologyLoaderSvc;

    public TerminologyUploaderProvider() {
        this(null, null);
    }

    public TerminologyUploaderProvider(FhirContext theContext, ITermLoaderSvc theTerminologyLoaderSvc) {
        this.setContext(theContext);
        this.myTerminologyLoaderSvc = theTerminologyLoaderSvc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(typeName="CodeSystem", name="$upload-external-code-system", idempotent=false, returnParameters={})
    public IBaseParameters uploadSnapshot(HttpServletRequest theServletRequest, @OperationParam(name="system", min=1, typeName="uri") IPrimitiveType<String> theCodeSystemUrl, @OperationParam(name="file", min=0, max=-1, typeName="attachment") List<ICompositeType> theFiles, RequestDetails theRequestDetails) {
        TerminologyUploaderProvider.startRequest((HttpServletRequest)theServletRequest);
        if (theCodeSystemUrl == null || StringUtils.isBlank((CharSequence)theCodeSystemUrl.getValueAsString())) {
            throw new InvalidRequestException(Msg.code((int)1137) + "Missing mandatory parameter: system");
        }
        if (theFiles == null || theFiles.size() == 0) {
            throw new InvalidRequestException(Msg.code((int)1138) + "No 'file' parameter, or package had no data");
        }
        for (ICompositeType next : theFiles) {
            ValidateUtil.isTrueOrThrowInvalidRequest((boolean)this.getContext().getElementDefinition(next.getClass()).getName().equals("Attachment"), (String)"Package must be of type Attachment", (Object[])new Object[0]);
        }
        try {
            UploadStatistics stats;
            List<ITermLoaderSvc.FileDescriptor> localFiles = this.convertAttachmentsToFileDescriptors(theFiles);
            String codeSystemUrl = (String)theCodeSystemUrl.getValue();
            switch (codeSystemUrl = StringUtils.trim((String)codeSystemUrl)) {
                case "http://hl7.org/fhir/sid/icd-10": {
                    stats = this.myTerminologyLoaderSvc.loadIcd10(localFiles, theRequestDetails);
                    break;
                }
                case "http://hl7.org/fhir/sid/icd-10-cm": {
                    stats = this.myTerminologyLoaderSvc.loadIcd10cm(localFiles, theRequestDetails);
                    break;
                }
                case "http://www.ebi.ac.uk/ipd/imgt/hla": {
                    stats = this.myTerminologyLoaderSvc.loadImgthla(localFiles, theRequestDetails);
                    break;
                }
                case "http://loinc.org": {
                    stats = this.myTerminologyLoaderSvc.loadLoinc(localFiles, theRequestDetails);
                    break;
                }
                case "http://snomed.info/sct": {
                    stats = this.myTerminologyLoaderSvc.loadSnomedCt(localFiles, theRequestDetails);
                    break;
                }
                default: {
                    stats = this.myTerminologyLoaderSvc.loadCustom(codeSystemUrl, localFiles, theRequestDetails);
                }
            }
            IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
            ParametersUtil.addParameterToParametersBoolean((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)RESP_PARAM_SUCCESS, (boolean)true);
            ParametersUtil.addParameterToParametersInteger((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)RESP_PARAM_CONCEPT_COUNT, (int)stats.getUpdatedConceptCount());
            ParametersUtil.addParameterToParametersReference((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)RESP_PARAM_TARGET, (String)stats.getTarget().getValue());
            IBaseParameters iBaseParameters = retVal;
            return iBaseParameters;
        }
        finally {
            TerminologyUploaderProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(typeName="CodeSystem", name="$apply-codesystem-delta-add", idempotent=false, returnParameters={})
    public IBaseParameters uploadDeltaAdd(HttpServletRequest theServletRequest, @OperationParam(name="system", min=1, max=1, typeName="uri") IPrimitiveType<String> theSystem, @OperationParam(name="file", min=0, max=-1, typeName="attachment") List<ICompositeType> theFiles, @OperationParam(name="codeSystem", min=0, max=-1, typeName="CodeSystem") List<IBaseResource> theCodeSystems, RequestDetails theRequestDetails) {
        TerminologyUploaderProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            this.validateHaveSystem(theSystem);
            this.validateHaveFiles(theFiles, theCodeSystems);
            List<ITermLoaderSvc.FileDescriptor> files = this.convertAttachmentsToFileDescriptors(theFiles);
            this.convertCodeSystemsToFileDescriptors(files, theCodeSystems);
            UploadStatistics outcome = this.myTerminologyLoaderSvc.loadDeltaAdd((String)theSystem.getValue(), files, theRequestDetails);
            IBaseParameters iBaseParameters = this.toDeltaResponse(outcome);
            return iBaseParameters;
        }
        finally {
            TerminologyUploaderProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(typeName="CodeSystem", name="$apply-codesystem-delta-remove", idempotent=false, returnParameters={})
    public IBaseParameters uploadDeltaRemove(HttpServletRequest theServletRequest, @OperationParam(name="system", min=1, max=1, typeName="uri") IPrimitiveType<String> theSystem, @OperationParam(name="file", min=0, max=-1, typeName="attachment") List<ICompositeType> theFiles, @OperationParam(name="codeSystem", min=0, max=-1, typeName="CodeSystem") List<IBaseResource> theCodeSystems, RequestDetails theRequestDetails) {
        TerminologyUploaderProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            this.validateHaveSystem(theSystem);
            this.validateHaveFiles(theFiles, theCodeSystems);
            List<ITermLoaderSvc.FileDescriptor> files = this.convertAttachmentsToFileDescriptors(theFiles);
            this.convertCodeSystemsToFileDescriptors(files, theCodeSystems);
            UploadStatistics outcome = this.myTerminologyLoaderSvc.loadDeltaRemove((String)theSystem.getValue(), files, theRequestDetails);
            IBaseParameters iBaseParameters = this.toDeltaResponse(outcome);
            return iBaseParameters;
        }
        finally {
            TerminologyUploaderProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    private void convertCodeSystemsToFileDescriptors(List<ITermLoaderSvc.FileDescriptor> theFiles, List<IBaseResource> theCodeSystems) {
        Object fileDescriptor;
        String fileName;
        StringBuilder b;
        LinkedHashMap<String, String> codes = new LinkedHashMap<String, String>();
        LinkedHashMap<String, List<CodeSystem.ConceptPropertyComponent>> codeToProperties = new LinkedHashMap<String, List<CodeSystem.ConceptPropertyComponent>>();
        ArrayListMultimap codeToParentCodes = ArrayListMultimap.create();
        if (theCodeSystems != null) {
            for (IBaseResource iBaseResource : theCodeSystems) {
                CodeSystem nextCodeSystem = this.canonicalizeCodeSystem(iBaseResource);
                this.convertCodeSystemCodesToCsv(nextCodeSystem.getConcept(), codes, codeToProperties, null, (Multimap<String, String>)codeToParentCodes);
            }
        }
        if (codes.size() > 0) {
            b = new StringBuilder();
            b.append("CODE");
            b.append(",");
            b.append("DISPLAY");
            b.append("\n");
            for (Map.Entry nextEntry : codes.entrySet()) {
                b.append(TerminologyUploaderProvider.csvEscape((String)nextEntry.getKey()));
                b.append(",");
                b.append(TerminologyUploaderProvider.csvEscape((String)nextEntry.getValue()));
                b.append("\n");
            }
            byte[] byArray = b.toString().getBytes(Charsets.UTF_8);
            fileName = "concepts.csv";
            fileDescriptor = new ITermLoaderSvc.ByteArrayFileDescriptor(fileName, byArray);
            theFiles.add((ITermLoaderSvc.FileDescriptor)fileDescriptor);
        }
        if (codeToParentCodes.size() > 0) {
            b = new StringBuilder();
            b.append("CHILD");
            b.append(",");
            b.append("PARENT");
            b.append("\n");
            for (Map.Entry nextEntry : codeToParentCodes.entries()) {
                b.append(TerminologyUploaderProvider.csvEscape((String)nextEntry.getKey()));
                b.append(",");
                b.append(TerminologyUploaderProvider.csvEscape((String)nextEntry.getValue()));
                b.append("\n");
            }
            byte[] byArray = b.toString().getBytes(Charsets.UTF_8);
            fileName = "hierarchy.csv";
            fileDescriptor = new ITermLoaderSvc.ByteArrayFileDescriptor(fileName, byArray);
            theFiles.add((ITermLoaderSvc.FileDescriptor)fileDescriptor);
        }
        if (codeToProperties.size() > 0) {
            b = new StringBuilder();
            b.append("CODE");
            b.append(",");
            b.append("KEY");
            b.append(",");
            b.append("VALUE");
            b.append(",");
            b.append("TYPE");
            b.append("\n");
            for (Map.Entry nextEntry : codeToProperties.entrySet()) {
                for (CodeSystem.ConceptPropertyComponent propertyComponent : (List)nextEntry.getValue()) {
                    b.append(TerminologyUploaderProvider.csvEscape((String)nextEntry.getKey()));
                    b.append(",");
                    b.append(TerminologyUploaderProvider.csvEscape(propertyComponent.getCode()));
                    b.append(",");
                    b.append(TerminologyUploaderProvider.csvEscape((String)propertyComponent.getValueStringType().getValue()));
                    b.append(",");
                    b.append(TerminologyUploaderProvider.csvEscape(propertyComponent.getValue().primitiveValue()));
                    b.append("\n");
                }
            }
            byte[] byArray = b.toString().getBytes(Charsets.UTF_8);
            fileName = "properties.csv";
            fileDescriptor = new ITermLoaderSvc.ByteArrayFileDescriptor(fileName, byArray);
            theFiles.add((ITermLoaderSvc.FileDescriptor)fileDescriptor);
        }
    }

    @Nonnull
    CodeSystem canonicalizeCodeSystem(@Nonnull IBaseResource theCodeSystem) {
        CodeSystem nextCodeSystem;
        RuntimeResourceDefinition resourceDef = this.getContext().getResourceDefinition(theCodeSystem);
        ValidateUtil.isTrueOrThrowInvalidRequest((boolean)resourceDef.getName().equals("CodeSystem"), (String)"Resource '%s' is not a CodeSystem", (Object[])new Object[]{resourceDef.getName()});
        switch (this.getContext().getVersion().getVersion()) {
            case DSTU3: {
                nextCodeSystem = (CodeSystem)VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.dstu3.model.Resource)((org.hl7.fhir.dstu3.model.CodeSystem)theCodeSystem), (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
                break;
            }
            case R5: {
                nextCodeSystem = (CodeSystem)VersionConvertorFactory_40_50.convertResource((Resource)((org.hl7.fhir.r5.model.CodeSystem)theCodeSystem), (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
                break;
            }
            default: {
                nextCodeSystem = (CodeSystem)theCodeSystem;
            }
        }
        return nextCodeSystem;
    }

    private void convertCodeSystemCodesToCsv(List<CodeSystem.ConceptDefinitionComponent> theConcept, Map<String, String> theCodes, Map<String, List<CodeSystem.ConceptPropertyComponent>> theProperties, String theParentCode, Multimap<String, String> theCodeToParentCodes) {
        for (CodeSystem.ConceptDefinitionComponent nextConcept : theConcept) {
            if (!StringUtils.isNotBlank((CharSequence)nextConcept.getCode())) continue;
            theCodes.put(nextConcept.getCode(), nextConcept.getDisplay());
            if (StringUtils.isNotBlank((CharSequence)theParentCode)) {
                theCodeToParentCodes.put((Object)nextConcept.getCode(), (Object)theParentCode);
            }
            if (nextConcept.getProperty() != null) {
                theProperties.put(nextConcept.getCode(), nextConcept.getProperty());
            }
            this.convertCodeSystemCodesToCsv(nextConcept.getConcept(), theCodes, theProperties, nextConcept.getCode(), theCodeToParentCodes);
        }
    }

    private void validateHaveSystem(IPrimitiveType<String> theSystem) {
        if (theSystem == null || StringUtils.isBlank((CharSequence)theSystem.getValueAsString())) {
            throw new InvalidRequestException(Msg.code((int)1139) + "Missing mandatory parameter: system");
        }
    }

    private void validateHaveFiles(List<ICompositeType> theFiles, List<IBaseResource> theCodeSystems) {
        if (theFiles != null) {
            for (ICompositeType nextFile : theFiles) {
                if (nextFile.isEmpty()) continue;
                return;
            }
        }
        if (theCodeSystems != null) {
            for (IBaseResource next : theCodeSystems) {
                if (next.isEmpty()) continue;
                return;
            }
        }
        throw new InvalidRequestException(Msg.code((int)1140) + "Missing mandatory parameter: file");
    }

    @Nonnull
    private List<ITermLoaderSvc.FileDescriptor> convertAttachmentsToFileDescriptors(@OperationParam(name="file", min=0, max=-1, typeName="attachment") List<ICompositeType> theFiles) {
        ArrayList<ITermLoaderSvc.FileDescriptor> files = new ArrayList<ITermLoaderSvc.FileDescriptor>();
        if (theFiles != null) {
            for (ICompositeType next : theFiles) {
                String nextUrl = (String)AttachmentUtil.getOrCreateUrl((FhirContext)this.getContext(), (ICompositeType)next).getValue();
                ValidateUtil.isNotBlankOrThrowUnprocessableEntity((String)nextUrl, (String)"Missing Attachment.url value");
                if (nextUrl.startsWith("localfile:")) {
                    String nextLocalFile = nextUrl.substring("localfile:".length());
                    if (!StringUtils.isNotBlank((CharSequence)nextLocalFile)) continue;
                    ourLog.info("Reading in local file: {}", (Object)nextLocalFile);
                    File nextFile = new File(nextLocalFile);
                    if (!nextFile.exists() || !nextFile.isFile()) {
                        throw new InvalidRequestException(Msg.code((int)1141) + "Unknown file: " + nextFile.getName());
                    }
                    files.add(new FileBackedFileDescriptor(nextFile));
                    continue;
                }
                byte[] nextData = (byte[])AttachmentUtil.getOrCreateData((FhirContext)this.getContext(), (ICompositeType)next).getValue();
                ValidateUtil.isTrueOrThrowInvalidRequest((nextData != null && nextData.length > 0 ? 1 : 0) != 0, (String)"Missing Attachment.data value", (Object[])new Object[0]);
                files.add((ITermLoaderSvc.FileDescriptor)new ITermLoaderSvc.ByteArrayFileDescriptor(nextUrl, nextData));
            }
        }
        return files;
    }

    private IBaseParameters toDeltaResponse(UploadStatistics theOutcome) {
        IBaseParameters retVal = ParametersUtil.newInstance((FhirContext)this.getContext());
        ParametersUtil.addParameterToParametersInteger((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)RESP_PARAM_CONCEPT_COUNT, (int)theOutcome.getUpdatedConceptCount());
        ParametersUtil.addParameterToParametersReference((FhirContext)this.getContext(), (IBaseParameters)retVal, (String)RESP_PARAM_TARGET, (String)theOutcome.getTarget().getValue());
        return retVal;
    }

    public void setTerminologyLoaderSvc(ITermLoaderSvc theTermLoaderSvc) {
        this.myTerminologyLoaderSvc = theTermLoaderSvc;
    }

    private static String csvEscape(String theValue) {
        if (theValue == null) {
            return "";
        }
        return "\"" + theValue.replace("\"", "\"\"").replace("\n", "\\n").replace("\r", "") + "\"";
    }

    public static class FileBackedFileDescriptor
    implements ITermLoaderSvc.FileDescriptor {
        private final File myNextFile;

        public FileBackedFileDescriptor(File theNextFile) {
            this.myNextFile = theNextFile;
        }

        public String getFilename() {
            return this.myNextFile.getAbsolutePath();
        }

        public InputStream getInputStream() {
            try {
                return new FileInputStream(this.myNextFile);
            }
            catch (FileNotFoundException theE) {
                throw new InternalErrorException(Msg.code((int)1142) + theE);
            }
        }
    }
}

