/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.provider;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.dao.JpaResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.provider.BaseJpaResourceProviderCodeSystem;
import ca.uhn.fhir.jpa.provider.ValueSetOperationProvider;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.FhirTerser;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;

public class ValueSetOperationProviderDstu2
extends ValueSetOperationProvider {
    @Autowired
    private IValidationSupport myValidationSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$expand", idempotent=true, typeName="ValueSet")
    public IBaseResource expand(HttpServletRequest theServletRequest, @IdParam(optional=true) IIdType theId, @OperationParam(name="valueSet", min=0, max=1) IBaseResource theValueSet, @OperationParam(name="url", min=0, max=1, typeName="uri") IPrimitiveType<String> theUrl, @OperationParam(name="identifier", min=0, max=1, typeName="uri") IPrimitiveType<String> theIdentifier, @OperationParam(name="valueSetVersion", min=0, max=1, typeName="string") IPrimitiveType<String> theValueSetVersion, @OperationParam(name="filter", min=0, max=1, typeName="string") IPrimitiveType<String> theFilter, @OperationParam(name="context", min=0, max=1, typeName="string") IPrimitiveType<String> theContext, @OperationParam(name="contextDirection", min=0, max=1, typeName="string") IPrimitiveType<String> theContextDirection, @OperationParam(name="offset", min=0, max=1, typeName="integer") IPrimitiveType<Integer> theOffset, @OperationParam(name="count", min=0, max=1, typeName="integer") IPrimitiveType<Integer> theCount, @OperationParam(name="displayLanguage", min=0, max=1, typeName="code") IPrimitiveType<String> theDisplayLanguage, @OperationParam(name="includeHierarchy", min=0, max=1, typeName="boolean") IPrimitiveType<Boolean> theIncludeHierarchy, RequestDetails theRequestDetails) {
        IPrimitiveType<String> url = theUrl;
        if (theIdentifier != null) {
            url = theIdentifier;
        }
        ValueSetOperationProviderDstu2.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBaseResource iBaseResource = this.getDao().expand(theId, theValueSet, url, theValueSetVersion, theFilter, theContext, theContextDirection, theOffset, theCount, theDisplayLanguage, theIncludeHierarchy, theRequestDetails);
            return iBaseResource;
        }
        finally {
            ValueSetOperationProviderDstu2.endRequest((HttpServletRequest)theServletRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(name="$lookup", idempotent=true, typeName="ValueSet", returnParameters={@OperationParam(name="name", typeName="string", min=1), @OperationParam(name="version", typeName="string", min=0), @OperationParam(name="display", typeName="string", min=1), @OperationParam(name="abstract", typeName="boolean", min=1)})
    public IBaseParameters lookup(HttpServletRequest theServletRequest, @OperationParam(name="code", min=0, max=1, typeName="code") IPrimitiveType<String> theCode, @OperationParam(name="system", min=0, max=1, typeName="uri") IPrimitiveType<String> theSystem, @OperationParam(name="coding", min=0, max=1, typeName="Coding") IBaseCoding theCoding, @OperationParam(name="version", min=0, max=1, typeName="string") IPrimitiveType<String> theVersion, @OperationParam(name="displayLanguage", min=0, max=1, typeName="code") IPrimitiveType<String> theDisplayLanguage, @OperationParam(name="property", min=0, max=-1, typeName="code") List<IPrimitiveType<String>> thePropertyNames, RequestDetails theRequestDetails) {
        ValueSetOperationProviderDstu2.startRequest((HttpServletRequest)theServletRequest);
        try {
            BaseJpaResourceProviderCodeSystem.applyVersionToSystem(theSystem, theVersion);
            FhirTerser terser = this.getContext().newTerser();
            IValidationSupport.LookupCodeResult result = JpaResourceDaoCodeSystem.doLookupCode(this.getContext(), terser, this.myValidationSupport, theCode, theSystem, theCoding, theDisplayLanguage, thePropertyNames);
            result.throwNotFoundIfAppropriate();
            IBaseParameters iBaseParameters = result.toParameters(theRequestDetails.getFhirContext(), thePropertyNames);
            return iBaseParameters;
        }
        finally {
            ValueSetOperationProviderDstu2.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

