/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r4b;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r4b.model.Person;

public class PersonResourceProvider
extends BaseJpaResourceProvider<Person> {
    public Class<Person> getResourceType() {
        return Person.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search the contents of the resource's data using a list") @OptionalParam(name="_list") StringAndListParam theList, @Description(shortDefinition="The language of the resource") @OptionalParam(name="_language") TokenAndListParam theResourceLanguage, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam the_lastUpdated, @Description(shortDefinition="The profile of the resource") @OptionalParam(name="_profile") UriAndListParam the_profile, @Description(shortDefinition="The security of the resource") @OptionalParam(name="_security") TokenAndListParam the_security, @Description(shortDefinition="The tag of the resource") @OptionalParam(name="_tag") TokenAndListParam the_tag, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") StringAndListParam the_text, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text* [Person](person.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text* [Practitioner](practitioner.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text* [RelatedPerson](relatedperson.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text") @OptionalParam(name="address") StringAndListParam theAddress, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A city specified in an address* [Person](person.html): A city specified in an address* [Practitioner](practitioner.html): A city specified in an address* [RelatedPerson](relatedperson.html): A city specified in an address") @OptionalParam(name="address-city") StringAndListParam theAddress_city, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A country specified in an address* [Person](person.html): A country specified in an address* [Practitioner](practitioner.html): A country specified in an address* [RelatedPerson](relatedperson.html): A country specified in an address") @OptionalParam(name="address-country") StringAndListParam theAddress_country, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A postalCode specified in an address* [Person](person.html): A postal code specified in an address* [Practitioner](practitioner.html): A postalCode specified in an address* [RelatedPerson](relatedperson.html): A postal code specified in an address") @OptionalParam(name="address-postalcode") StringAndListParam theAddress_postalcode, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A state specified in an address* [Person](person.html): A state specified in an address* [Practitioner](practitioner.html): A state specified in an address* [RelatedPerson](relatedperson.html): A state specified in an address") @OptionalParam(name="address-state") StringAndListParam theAddress_state, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A use code specified in an address* [Person](person.html): A use code specified in an address* [Practitioner](practitioner.html): A use code specified in an address* [RelatedPerson](relatedperson.html): A use code specified in an address") @OptionalParam(name="address-use") TokenAndListParam theAddress_use, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): The patient's date of birth* [Person](person.html): The person's date of birth* [RelatedPerson](relatedperson.html): The Related Person's date of birth") @OptionalParam(name="birthdate") DateRangeParam theBirthdate, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A value in an email contact* [Person](person.html): A value in an email contact* [Practitioner](practitioner.html): A value in an email contact* [PractitionerRole](practitionerrole.html): A value in an email contact* [RelatedPerson](relatedperson.html): A value in an email contact") @OptionalParam(name="email") TokenAndListParam theEmail, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): Gender of the patient* [Person](person.html): The gender of the person* [Practitioner](practitioner.html): Gender of the practitioner* [RelatedPerson](relatedperson.html): Gender of the related person") @OptionalParam(name="gender") TokenAndListParam theGender, @Description(shortDefinition="A person Identifier") @OptionalParam(name="identifier") TokenAndListParam theIdentifier, @Description(shortDefinition="Any link has this Patient, Person, RelatedPerson or Practitioner reference") @OptionalParam(name="link", targetTypes={}) ReferenceAndListParam theLink, @Description(shortDefinition="A server defined search that may match any of the string fields in the HumanName, including family, give, prefix, suffix, suffix, and/or text") @OptionalParam(name="name") StringAndListParam theName, @Description(shortDefinition="The organization at which this person record is being managed") @OptionalParam(name="organization", targetTypes={}) ReferenceAndListParam theOrganization, @Description(shortDefinition="The Person links to this Patient") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A value in a phone contact* [Person](person.html): A value in a phone contact* [Practitioner](practitioner.html): A value in a phone contact* [PractitionerRole](practitionerrole.html): A value in a phone contact* [RelatedPerson](relatedperson.html): A value in a phone contact") @OptionalParam(name="phone") TokenAndListParam thePhone, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): A portion of either family or given name using some kind of phonetic matching algorithm* [Person](person.html): A portion of name using some kind of phonetic matching algorithm* [Practitioner](practitioner.html): A portion of either family or given name using some kind of phonetic matching algorithm* [RelatedPerson](relatedperson.html): A portion of name using some kind of phonetic matching algorithm") @OptionalParam(name="phonetic") StringAndListParam thePhonetic, @Description(shortDefinition="The Person links to this Practitioner") @OptionalParam(name="practitioner", targetTypes={}) ReferenceAndListParam thePractitioner, @Description(shortDefinition="The Person links to this RelatedPerson") @OptionalParam(name="relatedperson", targetTypes={}) ReferenceAndListParam theRelatedperson, @Description(shortDefinition="Multiple Resources: * [Patient](patient.html): The value in any kind of telecom details of the patient* [Person](person.html): The value in any kind of contact* [Practitioner](practitioner.html): The value in any kind of contact* [PractitionerRole](practitionerrole.html): The value in any kind of contact* [RelatedPerson](relatedperson.html): The value in any kind of contact") @OptionalParam(name="telecom") TokenAndListParam theTelecom, @RawParam Map<String, List<String>> theAdditionalRawParams, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        PersonResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_list", (IQueryParameterAnd)theList);
            paramMap.add("_language", (IQueryParameterAnd)theResourceLanguage);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_profile", (IQueryParameterAnd)the_profile);
            paramMap.add("_security", (IQueryParameterAnd)the_security);
            paramMap.add("_tag", (IQueryParameterAnd)the_tag);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("address", (IQueryParameterAnd)theAddress);
            paramMap.add("address-city", (IQueryParameterAnd)theAddress_city);
            paramMap.add("address-country", (IQueryParameterAnd)theAddress_country);
            paramMap.add("address-postalcode", (IQueryParameterAnd)theAddress_postalcode);
            paramMap.add("address-state", (IQueryParameterAnd)theAddress_state);
            paramMap.add("address-use", (IQueryParameterAnd)theAddress_use);
            paramMap.add("birthdate", (IQueryParameterAnd)theBirthdate);
            paramMap.add("email", (IQueryParameterAnd)theEmail);
            paramMap.add("gender", (IQueryParameterAnd)theGender);
            paramMap.add("identifier", (IQueryParameterAnd)theIdentifier);
            paramMap.add("link", (IQueryParameterAnd)theLink);
            paramMap.add("name", (IQueryParameterAnd)theName);
            paramMap.add("organization", (IQueryParameterAnd)theOrganization);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("phone", (IQueryParameterAnd)thePhone);
            paramMap.add("phonetic", (IQueryParameterAnd)thePhonetic);
            paramMap.add("practitioner", (IQueryParameterAnd)thePractitioner);
            paramMap.add("relatedperson", (IQueryParameterAnd)theRelatedperson);
            paramMap.add("telecom", (IQueryParameterAnd)theTelecom);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(the_lastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            PersonResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

