/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.rp.r5;

import ca.uhn.fhir.jpa.provider.BaseJpaResourceProvider;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.SpecialAndListParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.model.AuditEvent;

public class AuditEventResourceProvider
extends BaseJpaResourceProvider<AuditEvent> {
    public Class<AuditEvent> getResourceType() {
        return AuditEvent.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Search(allowUnknownParams=true)
    public IBundleProvider search(HttpServletRequest theServletRequest, HttpServletResponse theServletResponse, RequestDetails theRequestDetails, @Description(shortDefinition="Search the contents of the resource's data using a filter") @OptionalParam(name="_filter") StringAndListParam theFtFilter, @Description(shortDefinition="Search the contents of the resource's data using a fulltext search") @OptionalParam(name="_content") StringAndListParam theFtContent, @Description(shortDefinition="Search the contents of the resource's narrative using a fulltext search") @OptionalParam(name="_text") StringAndListParam theFtText, @Description(shortDefinition="Search for resources which have the given tag") @OptionalParam(name="_tag") TokenAndListParam theSearchForTag, @Description(shortDefinition="Search for resources which have the given security labels") @OptionalParam(name="_security") TokenAndListParam theSearchForSecurity, @Description(shortDefinition="Search for resources which have the given profile") @OptionalParam(name="_profile") UriAndListParam theSearchForProfile, @Description(shortDefinition="Search the contents of the resource's data using a list") @OptionalParam(name="_list") StringAndListParam theList, @Description(shortDefinition="The language of the resource") @OptionalParam(name="_language") TokenAndListParam theResourceLanguage, @Description(shortDefinition="Search for resources which have the given source value (Resource.meta.source)") @OptionalParam(name="_source") UriAndListParam theSearchForSource, @Description(shortDefinition="Return resources linked to by the given target") @OptionalParam(name="_has") HasAndListParam theHas, @Description(shortDefinition="The ID of the resource") @OptionalParam(name="_id") TokenAndListParam the_id, @Description(shortDefinition="Only return resources which were last updated as specified by the given range") @OptionalParam(name="_lastUpdated") DateRangeParam the_lastUpdated, @Description(shortDefinition="The profile of the resource") @OptionalParam(name="_profile") UriAndListParam the_profile, @Description(shortDefinition="The security of the resource") @OptionalParam(name="_security") TokenAndListParam the_security, @Description(shortDefinition="The tag of the resource") @OptionalParam(name="_tag") TokenAndListParam the_tag, @Description(shortDefinition="Search on the narrative of the resource") @OptionalParam(name="_text") SpecialAndListParam the_text, @Description(shortDefinition="Type of action performed during the event") @OptionalParam(name="action") TokenAndListParam theAction, @Description(shortDefinition="Identifier of who") @OptionalParam(name="agent", targetTypes={}) ReferenceAndListParam theAgent, @Description(shortDefinition="Agent role in the event") @OptionalParam(name="agent-role") TokenAndListParam theAgent_role, @Description(shortDefinition="Reference to the service request.") @OptionalParam(name="based-on", targetTypes={}) ReferenceAndListParam theBased_on, @Description(shortDefinition="Category of event") @OptionalParam(name="category") TokenAndListParam theCategory, @Description(shortDefinition="Multiple Resources: * [AdverseEvent](adverseevent.html): Event or incident that occurred or was averted* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance* [AuditEvent](auditevent.html): More specific code for the event* [Basic](basic.html): Kind of Resource* [ChargeItem](chargeitem.html): A code that identifies the charge, like a billing code* [Condition](condition.html): Code for the condition* [DetectedIssue](detectedissue.html): Issue Type, e.g. drug-drug, duplicate therapy, etc.* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code* [ImagingSelection](imagingselection.html): The imaging selection status* [List](list.html): What the purpose of this list is* [Medication](medication.html): Returns medications for a specific code* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code* [MedicationStatement](medicationstatement.html): Return statements of this medication code* [NutritionIntake](nutritionintake.html): Returns statements of this code of NutritionIntake* [Observation](observation.html): The code of the observation type* [Procedure](procedure.html): A code to identify a  procedure* [RequestOrchestration](requestorchestration.html): The code of the request orchestration* [Task](task.html): Search by task code") @OptionalParam(name="code") TokenAndListParam theCode, @Description(shortDefinition="Multiple Resources: * [AdverseEvent](adverseevent.html): When the event occurred* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded* [Appointment](appointment.html): Appointment date/time.* [AuditEvent](auditevent.html): Time when the event was recorded* [CarePlan](careplan.html): Time period plan covers* [CareTeam](careteam.html): A date within the coverage time period.* [ClinicalImpression](clinicalimpression.html): When the assessment was documented* [Composition](composition.html): Composition editing time* [Consent](consent.html): When consent was agreed to* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report* [DocumentReference](documentreference.html): When this document reference was created* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated* [Flag](flag.html): Time period when flag is active* [Immunization](immunization.html): Vaccination  (non)-Administration Date* [ImmunizationEvaluation](immunizationevaluation.html): Date the evaluation was generated* [ImmunizationRecommendation](immunizationrecommendation.html): Date recommendation(s) created* [Invoice](invoice.html): Invoice date / posting date* [List](list.html): When the list was prepared* [MeasureReport](measurereport.html): The date of the measure report* [NutritionIntake](nutritionintake.html): Date when patient was taking (or not taking) the medication* [Observation](observation.html): Clinically relevant time/time-period for observation* [Procedure](procedure.html): When the procedure occurred or is occurring* [ResearchSubject](researchsubject.html): Start and end of participation* [RiskAssessment](riskassessment.html): When was assessment made?* [SupplyRequest](supplyrequest.html): When the request was made") @OptionalParam(name="date") DateRangeParam theDate, @Description(shortDefinition="Multiple Resources: * [AuditEvent](auditevent.html): Encounter related to the activity recorded in the AuditEvent* [CarePlan](careplan.html): The Encounter during which this CarePlan was created* [ChargeItem](chargeitem.html): Encounter associated with event* [Claim](claim.html): Encounters associated with a billed line item* [ClinicalImpression](clinicalimpression.html): The Encounter during which this ClinicalImpression was created* [Communication](communication.html): The Encounter during which this Communication was created* [CommunicationRequest](communicationrequest.html): The Encounter during which this CommunicationRequest was created* [Composition](composition.html): Context of the Composition* [Condition](condition.html): The Encounter during which this Condition was created* [DeviceRequest](devicerequest.html): Encounter during which request was created* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made* [EncounterHistory](encounterhistory.html): The Encounter associated with this set of history values* [ExplanationOfBenefit](explanationofbenefit.html): Encounters associated with a billed line item* [Flag](flag.html): Alert relevant during encounter* [ImagingStudy](imagingstudy.html): The context of the study* [List](list.html): Context in which list created* [MedicationDispense](medicationdispense.html): Returns dispenses with a specific encounter* [MedicationStatement](medicationstatement.html): Returns statements for a specific encounter* [NutritionIntake](nutritionintake.html): Returns statements for a specific encounter* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier* [Observation](observation.html): Encounter related to the observation* [Procedure](procedure.html): The Encounter during which this Procedure was created* [Provenance](provenance.html): Encounter related to the Provenance* [QuestionnaireResponse](questionnaireresponse.html): Encounter associated with the questionnaire response* [RequestOrchestration](requestorchestration.html): The encounter the request orchestration applies to* [RiskAssessment](riskassessment.html): Where was assessment performed?* [ServiceRequest](servicerequest.html): An encounter in which this request is made* [Task](task.html): Search by encounter* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier") @OptionalParam(name="encounter", targetTypes={}) ReferenceAndListParam theEncounter, @Description(shortDefinition="Specific instance of resource") @OptionalParam(name="entity", targetTypes={}) ReferenceAndListParam theEntity, @Description(shortDefinition="What role the entity played") @OptionalParam(name="entity-role") TokenAndListParam theEntity_role, @Description(shortDefinition="Whether the event succeeded or failed") @OptionalParam(name="outcome") TokenAndListParam theOutcome, @Description(shortDefinition="Multiple Resources: * [Account](account.html): The entity that caused the expenses* [AdverseEvent](adverseevent.html): Subject impacted by event* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for* [Appointment](appointment.html): One of the individuals of the appointment is this patient* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient* [AuditEvent](auditevent.html): Where the activity involved patient data* [Basic](basic.html): Identifies the focus of this resource* [BodyStructure](bodystructure.html): Who this is about* [CarePlan](careplan.html): Who the care plan is for* [CareTeam](careteam.html): Who care team is for* [ChargeItem](chargeitem.html): Individual service was done for/to* [Claim](claim.html): Patient receiving the products or services* [ClaimResponse](claimresponse.html): The subject of care* [ClinicalImpression](clinicalimpression.html): Patient assessed* [Communication](communication.html): Focus of message* [CommunicationRequest](communicationrequest.html): Focus of message* [Composition](composition.html): Who and/or what the composition is about* [Condition](condition.html): Who has the condition?* [Consent](consent.html): Who the consent applies to* [Contract](contract.html): The identity of the subject of the contract (if a patient)* [Coverage](coverage.html): Retrieve coverages for a patient* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient* [DetectedIssue](detectedissue.html): Associated patient* [DeviceRequest](devicerequest.html): Individual the service is ordered for* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient* [DocumentReference](documentreference.html): Who/what is the subject of the document* [Encounter](encounter.html): The patient present at the encounter* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for* [Flag](flag.html): The identity of a subject to list flags for* [Goal](goal.html): Who this goal is intended for* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results* [ImagingSelection](imagingselection.html): Who the study is about* [ImagingStudy](imagingstudy.html): Who the study is about* [Immunization](immunization.html): The patient for the vaccination record* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for* [Invoice](invoice.html): Recipient(s) of goods and services* [List](list.html): If all resources have the same subject* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.* [MolecularSequence](molecularsequence.html): The subject that the sequence is about* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement* [Observation](observation.html): The subject that the observation is about (if patient)* [Person](person.html): The Person links to this Patient* [Procedure](procedure.html): Search by subject - a patient* [Provenance](provenance.html): Where the activity involved patient data* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response* [RelatedPerson](relatedperson.html): The patient this related person is related to* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations* [ResearchSubject](researchsubject.html): Who or what is part of study* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?* [ServiceRequest](servicerequest.html): Search by subject - a patient* [Specimen](specimen.html): The patient the specimen comes from* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined* [Task](task.html): Search by patient* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for") @OptionalParam(name="patient", targetTypes={}) ReferenceAndListParam thePatient, @Description(shortDefinition="Policy that authorized event") @OptionalParam(name="policy") UriAndListParam thePolicy, @Description(shortDefinition="The authorization (purposeOfUse) of the event") @OptionalParam(name="purpose") TokenAndListParam thePurpose, @Description(shortDefinition="The identity of source detecting the event") @OptionalParam(name="source", targetTypes={}) ReferenceAndListParam theSource, @RawParam Map<String, List<String>> theAdditionalRawParams, @IncludeParam Set<Include> theIncludes, @IncludeParam(reverse=true) Set<Include> theRevIncludes, @Sort SortSpec theSort, @Count Integer theCount, @Offset Integer theOffset, SummaryEnum theSummaryMode, SearchTotalModeEnum theSearchTotalMode, SearchContainedModeEnum theSearchContainedMode) {
        AuditEventResourceProvider.startRequest((HttpServletRequest)theServletRequest);
        try {
            IBundleProvider retVal;
            SearchParameterMap paramMap = new SearchParameterMap();
            paramMap.add("_filter", (IQueryParameterAnd)theFtFilter);
            paramMap.add("_content", (IQueryParameterAnd)theFtContent);
            paramMap.add("_text", (IQueryParameterAnd)theFtText);
            paramMap.add("_tag", (IQueryParameterAnd)theSearchForTag);
            paramMap.add("_security", (IQueryParameterAnd)theSearchForSecurity);
            paramMap.add("_profile", (IQueryParameterAnd)theSearchForProfile);
            paramMap.add("_source", (IQueryParameterAnd)theSearchForSource);
            paramMap.add("_list", (IQueryParameterAnd)theList);
            paramMap.add("_language", (IQueryParameterAnd)theResourceLanguage);
            paramMap.add("_has", (IQueryParameterAnd)theHas);
            paramMap.add("_id", (IQueryParameterAnd)the_id);
            paramMap.add("_profile", (IQueryParameterAnd)the_profile);
            paramMap.add("_security", (IQueryParameterAnd)the_security);
            paramMap.add("_tag", (IQueryParameterAnd)the_tag);
            paramMap.add("_text", (IQueryParameterAnd)the_text);
            paramMap.add("action", (IQueryParameterAnd)theAction);
            paramMap.add("agent", (IQueryParameterAnd)theAgent);
            paramMap.add("agent-role", (IQueryParameterAnd)theAgent_role);
            paramMap.add("based-on", (IQueryParameterAnd)theBased_on);
            paramMap.add("category", (IQueryParameterAnd)theCategory);
            paramMap.add("code", (IQueryParameterAnd)theCode);
            paramMap.add("date", (IQueryParameterAnd)theDate);
            paramMap.add("encounter", (IQueryParameterAnd)theEncounter);
            paramMap.add("entity", (IQueryParameterAnd)theEntity);
            paramMap.add("entity-role", (IQueryParameterAnd)theEntity_role);
            paramMap.add("outcome", (IQueryParameterAnd)theOutcome);
            paramMap.add("patient", (IQueryParameterAnd)thePatient);
            paramMap.add("policy", (IQueryParameterAnd)thePolicy);
            paramMap.add("purpose", (IQueryParameterAnd)thePurpose);
            paramMap.add("source", (IQueryParameterAnd)theSource);
            paramMap.setRevIncludes(theRevIncludes);
            paramMap.setLastUpdated(the_lastUpdated);
            paramMap.setIncludes(theIncludes);
            paramMap.setSort(theSort);
            paramMap.setCount(theCount);
            paramMap.setOffset(theOffset);
            paramMap.setSummaryMode(theSummaryMode);
            paramMap.setSearchTotalMode(theSearchTotalMode);
            paramMap.setSearchContainedMode(theSearchContainedMode);
            this.getDao().translateRawParameters(theAdditionalRawParams, paramMap);
            IBundleProvider iBundleProvider = retVal = this.getDao().search(paramMap, theRequestDetails, theServletResponse);
            return iBundleProvider;
        }
        finally {
            AuditEventResourceProvider.endRequest((HttpServletRequest)theServletRequest);
        }
    }
}

