/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.entity.SearchTypeEnum;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProvider;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchTask;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.method.ResponsePage;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistedJpaSearchFirstPageBundleProvider
extends PersistedJpaBundleProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(PersistedJpaSearchFirstPageBundleProvider.class);
    private final SearchTask mySearchTask;
    private final ISearchBuilder mySearchBuilder;

    public PersistedJpaSearchFirstPageBundleProvider(SearchTask theSearchTask, ISearchBuilder theSearchBuilder, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        super(theRequest, theSearchTask.getSearch());
        assert (this.getSearchEntity().getSearchType() != SearchTypeEnum.HISTORY);
        this.mySearchTask = theSearchTask;
        this.mySearchBuilder = theSearchBuilder;
        super.setRequestPartitionId(theRequestPartitionId);
    }

    @Override
    @Nonnull
    public List<IBaseResource> getResources(int theFromIndex, int theToIndex, @Nonnull ResponsePage.ResponsePageBuilder thePageBuilder) {
        this.ensureSearchEntityLoaded();
        QueryParameterUtils.verifySearchHasntFailedOrThrowInternalErrorException(this.getSearchEntity());
        this.mySearchTask.awaitInitialSync();
        ourLog.trace("Fetching search resource PIDs from task: {}", this.mySearchTask.getClass());
        List<JpaPid> pids = this.mySearchTask.getResourcePids(theFromIndex, theToIndex + 1);
        ourLog.trace("Done fetching search resource PIDs");
        int countOfPids = pids.size();
        int maxSize = Math.min(theToIndex - theFromIndex, countOfPids);
        thePageBuilder.setTotalRequestedResourcesFetched(countOfPids);
        RequestPartitionId requestPartitionId = this.getRequestPartitionId();
        List<JpaPid> firstBatch = pids.subList(0, maxSize);
        List retVal = (List)this.myTxService.withRequest(this.myRequest).withRequestPartitionId(requestPartitionId).execute(() -> this.toResourceList(this.mySearchBuilder, firstBatch, thePageBuilder));
        long totalCountWanted = theToIndex - theFromIndex;
        long totalCountMatch = (int)retVal.stream().filter(t -> !this.isInclude((IBaseResource)t)).count();
        if (totalCountMatch < totalCountWanted && (this.getSearchEntity().getStatus() == SearchStatusEnum.PASSCMPLET || this.getSearchEntity().getStatus() == SearchStatusEnum.FINISHED && this.getSearchEntity().getNumFound() >= theToIndex)) {
            Set existingIds = retVal.stream().map(t -> t.getIdElement().getValue()).filter(t -> t != null).collect(Collectors.toSet());
            long remainingWanted = totalCountWanted - totalCountMatch;
            long fromIndex = (long)theToIndex - remainingWanted;
            ResponsePage.ResponsePageBuilder pageBuilder = new ResponsePage.ResponsePageBuilder();
            pageBuilder.setBundleProvider((IBundleProvider)this);
            List<IBaseResource> remaining = super.getResources((int)fromIndex, theToIndex, pageBuilder);
            remaining.forEach(t -> {
                if (!existingIds.contains(t.getIdElement().getValue())) {
                    retVal.add(t);
                }
            });
            thePageBuilder.combineWith(pageBuilder);
        }
        ourLog.trace("Loaded resources to return");
        return retVal;
    }

    private boolean isInclude(IBaseResource theResource) {
        BundleEntrySearchModeEnum searchMode = (BundleEntrySearchModeEnum)ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.get(theResource);
        return BundleEntrySearchModeEnum.INCLUDE.equals((Object)searchMode);
    }

    @Override
    public Integer size() {
        ourLog.trace("size() - Waiting for initial sync");
        Integer size = this.mySearchTask.awaitInitialSync();
        ourLog.trace("size() - Finished waiting for local sync");
        this.ensureSearchEntityLoaded();
        QueryParameterUtils.verifySearchHasntFailedOrThrowInternalErrorException(this.getSearchEntity());
        if (size != null) {
            return size;
        }
        return super.size();
    }
}

