/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.jpa.dao.data.IResourceSearchUrlDao;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ResourceSearchUrlEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import jakarta.persistence.EntityManager;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class ResourceSearchUrlSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceSearchUrlSvc.class);
    private final EntityManager myEntityManager;
    private final IResourceSearchUrlDao myResourceSearchUrlDao;
    private final MatchUrlService myMatchUrlService;
    private final FhirContext myFhirContext;
    private final PartitionSettings myPartitionSettings;

    public ResourceSearchUrlSvc(EntityManager theEntityManager, IResourceSearchUrlDao theResourceSearchUrlDao, MatchUrlService theMatchUrlService, FhirContext theFhirContext, PartitionSettings thePartitionSettings) {
        this.myEntityManager = theEntityManager;
        this.myResourceSearchUrlDao = theResourceSearchUrlDao;
        this.myMatchUrlService = theMatchUrlService;
        this.myFhirContext = theFhirContext;
        this.myPartitionSettings = thePartitionSettings;
    }

    public void deleteEntriesOlderThan(Date theCutoffDate) {
        ourLog.debug("About to delete SearchUrl which are older than {}", (Object)theCutoffDate);
        int deletedCount = this.myResourceSearchUrlDao.deleteAllWhereCreatedBefore(theCutoffDate);
        ourLog.debug("Deleted {} SearchUrls", (Object)deletedCount);
    }

    public void deleteByResId(long theResId) {
        this.myResourceSearchUrlDao.deleteByResId(theResId);
    }

    public void enforceMatchUrlResourceUniqueness(String theResourceName, String theMatchUrl, ResourceTable theResourceTable) {
        String canonicalizedUrlForStorage = this.createCanonicalizedUrlForStorage(theResourceName, theMatchUrl);
        ResourceSearchUrlEntity searchUrlEntity = ResourceSearchUrlEntity.from((String)canonicalizedUrlForStorage, (ResourceTable)theResourceTable, (boolean)this.myPartitionSettings.isConditionalCreateDuplicateIdentifiersEnabled());
        this.myEntityManager.persist((Object)searchUrlEntity);
    }

    private String createCanonicalizedUrlForStorage(String theResourceName, String theMatchUrl) {
        RuntimeResourceDefinition resourceDef = this.myFhirContext.getResourceDefinition(theResourceName);
        SearchParameterMap matchUrlSearchParameterMap = this.myMatchUrlService.translateMatchUrl(theMatchUrl, resourceDef, new MatchUrlService.Flag[0]);
        String canonicalizedMatchUrl = matchUrlSearchParameterMap.toNormalizedQueryString(this.myFhirContext);
        return theResourceName + canonicalizedMatchUrl;
    }
}

