/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.jpa.api.svc.ISearchUrlJobMaintenanceSvc;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.search.ResourceSearchUrlSvc;
import java.util.Date;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchUrlJobMaintenanceSvcImpl
implements ISearchUrlJobMaintenanceSvc,
IHasScheduledJobs {
    private ResourceSearchUrlSvc myResourceSearchUrlSvc;
    public static final long OUR_CUTOFF_IN_MILLISECONDS = 3600000L;

    public SearchUrlJobMaintenanceSvcImpl(ResourceSearchUrlSvc theResourceSearchUrlSvc) {
        this.myResourceSearchUrlSvc = theResourceSearchUrlSvc;
    }

    public void removeStaleEntries() {
        Date cutoffDate = this.calculateCutoffDate();
        this.myResourceSearchUrlSvc.deleteEntriesOlderThan(cutoffDate);
    }

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(SearchUrlMaintenanceJob.class.getName());
        jobDetail.setJobClass(SearchUrlMaintenanceJob.class);
        theSchedulerService.scheduleClusteredJob(600000L, jobDetail);
    }

    private Date calculateCutoffDate() {
        return new Date(System.currentTimeMillis() - 3600000L);
    }

    public static class SearchUrlMaintenanceJob
    implements HapiJob {
        @Autowired
        private ISearchUrlJobMaintenanceSvc mySearchUrlJobMaintenanceSvc;

        public void execute(JobExecutionContext theJobExecutionContext) throws JobExecutionException {
            this.mySearchUrlJobMaintenanceSvc.removeStaleEntries();
        }
    }
}

