/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.models;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.security.InvalidParameterException;
import java.util.List;

public class MissingParameterQueryParams {
    private final SearchQueryBuilder mySqlBuilder;
    private final RestSearchParameterTypeEnum myParamType;
    private final List<? extends IQueryParameterType> myQueryParameterTypes;
    private final boolean myIsMissing;
    private final String myParamName;
    private final String myResourceType;
    private final DbColumn[] mySourceJoinColumn;
    private final RequestPartitionId myRequestPartitionId;

    public MissingParameterQueryParams(SearchQueryBuilder theSqlBuilder, RestSearchParameterTypeEnum theParamType, List<? extends IQueryParameterType> theList, String theParamName, String theResourceType, DbColumn[] theSourceJoinColumn, RequestPartitionId theRequestPartitionId) {
        this.mySqlBuilder = theSqlBuilder;
        this.myParamType = theParamType;
        this.myQueryParameterTypes = theList;
        if (theList.isEmpty()) {
            throw new InvalidParameterException(Msg.code((int)2140) + " Invalid search parameter list. Cannot be empty!");
        }
        this.myIsMissing = theList.get(0).getMissing();
        this.myParamName = theParamName;
        this.myResourceType = theResourceType;
        this.mySourceJoinColumn = theSourceJoinColumn;
        this.myRequestPartitionId = theRequestPartitionId;
    }

    public SearchQueryBuilder getSqlBuilder() {
        return this.mySqlBuilder;
    }

    public RestSearchParameterTypeEnum getParamType() {
        return this.myParamType;
    }

    public List<? extends IQueryParameterType> getQueryParameterTypes() {
        return this.myQueryParameterTypes;
    }

    public boolean isMissing() {
        return this.myIsMissing;
    }

    public String getParamName() {
        return this.myParamName;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public DbColumn[] getSourceJoinColumn() {
        return this.mySourceJoinColumn;
    }

    public RequestPartitionId getRequestPartitionId() {
        return this.myRequestPartitionId;
    }
}

