/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ParsedLocationParam;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.CoordCalculator;
import ca.uhn.fhir.model.api.IQueryParameterType;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import org.hibernate.search.engine.spatial.GeoBoundingBox;

public class CoordsPredicateBuilder
extends BaseSearchParamPredicateBuilder {
    private final DbColumn myColumnLatitude = this.getTable().addColumn("SP_LATITUDE");
    private final DbColumn myColumnLongitude = this.getTable().addColumn("SP_LONGITUDE");

    public CoordsPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_SPIDX_COORDS"));
    }

    public DbColumn getColumnLatitude() {
        return this.myColumnLatitude;
    }

    public DbColumn getColumnLongitude() {
        return this.myColumnLongitude;
    }

    public Condition createPredicateCoords(SearchParameterMap theParams, IQueryParameterType theParam, String theResourceName, RuntimeSearchParam theSearchParam, CoordsPredicateBuilder theFrom, RequestPartitionId theRequestPartitionId) {
        Condition longitudePredicate;
        Condition latitudePredicate;
        ParsedLocationParam params = ParsedLocationParam.from(theParams, theParam);
        double distanceKm = params.getDistanceKm();
        double latitudeValue = params.getLatitudeValue();
        double longitudeValue = params.getLongitudeValue();
        if (distanceKm == 0.0) {
            latitudePredicate = theFrom.createPredicateLatitudeExact(latitudeValue);
            longitudePredicate = theFrom.createPredicateLongitudeExact(longitudeValue);
        } else {
            if (distanceKm < 0.0) {
                throw new IllegalArgumentException(Msg.code((int)1233) + "Invalid near-distance parameter '" + distanceKm + "' must be >= 0.0");
            }
            if (distanceKm > 10000.0) {
                throw new IllegalArgumentException(Msg.code((int)1234) + "Invalid near-distance parameter '" + distanceKm + "' must be <= 10000.0");
            }
            GeoBoundingBox box = CoordCalculator.getBox(latitudeValue, longitudeValue, distanceKm);
            latitudePredicate = theFrom.createLatitudePredicateFromBox(box);
            longitudePredicate = theFrom.createLongitudePredicateFromBox(box);
        }
        ComboCondition singleCode = ComboCondition.and((Condition[])new Condition[]{latitudePredicate, longitudePredicate});
        return this.combineWithHashIdentityPredicate(theResourceName, theSearchParam.getName(), (Condition)singleCode);
    }

    public Condition createPredicateLatitudeExact(double theLatitudeValue) {
        return BinaryCondition.equalTo((Object)this.myColumnLatitude, (Object)this.generatePlaceholder(theLatitudeValue));
    }

    public Condition createPredicateLongitudeExact(double theLongitudeValue) {
        return BinaryCondition.equalTo((Object)this.myColumnLongitude, (Object)this.generatePlaceholder(theLongitudeValue));
    }

    public Condition createLatitudePredicateFromBox(GeoBoundingBox theBox) {
        return ComboCondition.and((Condition[])new Condition[]{BinaryCondition.greaterThanOrEq((Object)this.myColumnLatitude, (Object)this.generatePlaceholder(theBox.bottomRight().latitude())), BinaryCondition.lessThanOrEq((Object)this.myColumnLatitude, (Object)this.generatePlaceholder(theBox.topLeft().latitude()))});
    }

    public Condition createLongitudePredicateFromBox(GeoBoundingBox theBox) {
        if (theBox.bottomRight().longitude() < theBox.topLeft().longitude()) {
            return ComboCondition.or((Condition[])new Condition[]{BinaryCondition.greaterThanOrEq((Object)this.myColumnLongitude, (Object)this.generatePlaceholder(theBox.bottomRight().longitude())), BinaryCondition.lessThanOrEq((Object)this.myColumnLongitude, (Object)this.generatePlaceholder(theBox.topLeft().longitude()))});
        }
        return ComboCondition.and((Condition[])new Condition[]{BinaryCondition.greaterThanOrEq((Object)this.myColumnLongitude, (Object)this.generatePlaceholder(theBox.topLeft().longitude())), BinaryCondition.lessThanOrEq((Object)this.myColumnLongitude, (Object)this.generatePlaceholder(theBox.bottomRight().longitude()))});
    }
}

