/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.DateUtils;
import com.google.common.annotations.VisibleForTesting;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DatePredicateBuilder
extends BaseSearchParamPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(DatePredicateBuilder.class);
    private final DbColumn myColumnValueHigh;
    private final DbColumn myColumnValueLow = this.getTable().addColumn("SP_VALUE_LOW");
    private final DbColumn myColumnValueLowDateOrdinal;
    private final DbColumn myColumnValueHighDateOrdinal;
    @Autowired
    private JpaStorageSettings myStorageSettings;

    public DatePredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_SPIDX_DATE"));
        this.myColumnValueHigh = this.getTable().addColumn("SP_VALUE_HIGH");
        this.myColumnValueLowDateOrdinal = this.getTable().addColumn("SP_VALUE_LOW_DATE_ORDINAL");
        this.myColumnValueHighDateOrdinal = this.getTable().addColumn("SP_VALUE_HIGH_DATE_ORDINAL");
    }

    @VisibleForTesting
    public void setStorageSettingsForUnitTest(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }

    public Condition createPredicateDateWithoutIdentityPredicate(IQueryParameterType theParam, SearchFilterParser.CompareOperation theOperation) {
        Condition p;
        if (theParam instanceof DateParam) {
            DateParam date = (DateParam)theParam;
            if (!date.isEmpty()) {
                if (theOperation == SearchFilterParser.CompareOperation.ne) {
                    date = new DateParam(ParamPrefixEnum.EQUAL, date.getValueAsString());
                }
                DateRangeParam range = new DateRangeParam(date);
                p = this.createPredicateDateFromRange(range, theOperation);
            } else {
                p = null;
            }
        } else if (theParam instanceof DateRangeParam) {
            DateRangeParam range = (DateRangeParam)theParam;
            p = this.createPredicateDateFromRange(range, theOperation);
        } else {
            throw new IllegalArgumentException(Msg.code((int)1251) + "Invalid token type: " + theParam.getClass());
        }
        return p;
    }

    private Condition createPredicateDateFromRange(DateRangeParam theRange, SearchFilterParser.CompareOperation theOperation) {
        DatePredicateBounds datePredicateBounds = new DatePredicateBounds(theRange);
        return datePredicateBounds.calculate(theOperation);
    }

    public DbColumn getColumnValueLow() {
        return this.myColumnValueLow;
    }

    private boolean isNullOrDatePrecision(DateParam theDateParam) {
        return theDateParam == null || theDateParam.getPrecision().ordinal() <= TemporalPrecisionEnum.DAY.ordinal();
    }

    private Condition createPredicate(ColumnEnum theColumn, ParamPrefixEnum theComparator, Object theValue) {
        DbColumn column;
        switch (theColumn) {
            case LOW: {
                column = this.myColumnValueLow;
                break;
            }
            case LOW_DATE_ORDINAL: {
                column = this.myColumnValueLowDateOrdinal;
                break;
            }
            case HIGH: {
                column = this.myColumnValueHigh;
                break;
            }
            case HIGH_DATE_ORDINAL: {
                column = this.myColumnValueHighDateOrdinal;
                break;
            }
            default: {
                throw new IllegalArgumentException(Msg.code((int)1256));
            }
        }
        return this.createConditionForValueWithComparator(theComparator, column, theValue);
    }

    public class DatePredicateBounds {
        private ColumnEnum myLowValueField;
        private ColumnEnum myHighValueField;
        private Condition myLowerBoundCondition = null;
        private Condition myUpperBoundCondition = null;
        private final Date myLowerBoundInstant;
        private final Date myUpperBoundInstant;
        private final DateParam myLowerBound;
        private final DateParam myUpperBound;
        private final Integer myLowerBoundAsOrdinal;
        private final Integer myUpperBoundAsOrdinal;
        private Comparable<?> myGenericLowerBound;
        private Comparable<?> myGenericUpperBound;

        public DatePredicateBounds(DateRangeParam theRange) {
            this.myLowerBoundInstant = theRange.getLowerBoundAsInstant();
            this.myUpperBoundInstant = theRange.getUpperBoundAsInstant();
            this.myLowerBound = theRange.getLowerBound();
            this.myUpperBound = theRange.getUpperBound();
            this.myLowerBoundAsOrdinal = theRange.getLowerBoundAsDateInteger();
            this.myUpperBoundAsOrdinal = theRange.getUpperBoundAsDateInteger();
            this.init();
        }

        public Condition calculate(SearchFilterParser.CompareOperation theOperation) {
            if (theOperation == SearchFilterParser.CompareOperation.lt || theOperation == SearchFilterParser.CompareOperation.le) {
                this.handleLessThanAndLessThanOrEqualTo();
            } else if (theOperation == SearchFilterParser.CompareOperation.gt || theOperation == SearchFilterParser.CompareOperation.ge) {
                this.handleGreaterThanAndGreaterThanOrEqualTo();
            } else if (theOperation == SearchFilterParser.CompareOperation.ne) {
                if (this.myLowerBoundInstant == null || this.myUpperBoundInstant == null) {
                    throw new InvalidRequestException(Msg.code((int)1254) + "lowerBound and/or upperBound value not correctly specified for compare theOperation");
                }
                Condition lessThan = DatePredicateBuilder.this.createPredicate(this.myLowValueField, ParamPrefixEnum.LESSTHAN, this.myGenericLowerBound);
                Condition greaterThan = DatePredicateBuilder.this.createPredicate(this.myHighValueField, ParamPrefixEnum.GREATERTHAN, this.myGenericUpperBound);
                this.myLowerBoundCondition = ComboCondition.or((Condition[])new Condition[]{lessThan, greaterThan});
            } else if (theOperation == SearchFilterParser.CompareOperation.eq || theOperation == SearchFilterParser.CompareOperation.sa || theOperation == SearchFilterParser.CompareOperation.eb || theOperation == null) {
                this.handleEqualToCompareOperator();
            } else {
                throw new InvalidRequestException(Msg.code((int)1255) + String.format("Unsupported operator specified, operator=%s", theOperation.name()));
            }
            if (this.isOrdinalComparison()) {
                ourLog.trace("Ordinal date range is {} - {} ", (Object)this.myLowerBoundAsOrdinal, (Object)this.myUpperBoundAsOrdinal);
            } else {
                ourLog.trace("Date range is {} - {}", (Object)this.myLowerBoundInstant, (Object)this.myUpperBoundInstant);
            }
            if (this.myLowerBoundCondition != null && this.myUpperBoundCondition != null) {
                return ComboCondition.and((Condition[])new Condition[]{this.myLowerBoundCondition, this.myUpperBoundCondition});
            }
            if (this.myLowerBoundCondition != null) {
                return this.myLowerBoundCondition;
            }
            return this.myUpperBoundCondition;
        }

        private void handleEqualToCompareOperator() {
            if (this.myLowerBoundInstant != null && this.myUpperBoundInstant != null) {
                ComboCondition greaterThan = ComboCondition.and((Condition[])new Condition[]{DatePredicateBuilder.this.createPredicate(this.myLowValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, this.myGenericLowerBound), DatePredicateBuilder.this.createPredicate(this.myLowValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, this.myGenericUpperBound)});
                ComboCondition lessThan = ComboCondition.and((Condition[])new Condition[]{DatePredicateBuilder.this.createPredicate(this.myHighValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, this.myGenericUpperBound), DatePredicateBuilder.this.createPredicate(this.myHighValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, this.myGenericLowerBound)});
                this.myLowerBoundCondition = greaterThan;
                this.myUpperBoundCondition = lessThan;
            } else if (this.myLowerBoundInstant != null) {
                Condition greaterThan = DatePredicateBuilder.this.createPredicate(this.myLowValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, this.myGenericLowerBound);
                Condition lessThan = DatePredicateBuilder.this.createPredicate(this.myHighValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, this.myGenericLowerBound);
                this.myLowerBoundCondition = this.myLowerBound.getPrefix() == ParamPrefixEnum.STARTS_AFTER || this.myLowerBound.getPrefix() == ParamPrefixEnum.EQUAL ? greaterThan : ComboCondition.or((Condition[])new Condition[]{greaterThan, lessThan});
            } else {
                Condition greaterThan = DatePredicateBuilder.this.createPredicate(this.myLowValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, this.myGenericUpperBound);
                Condition lessThan = DatePredicateBuilder.this.createPredicate(this.myHighValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, this.myGenericUpperBound);
                this.myUpperBoundCondition = this.myUpperBound.getPrefix() == ParamPrefixEnum.ENDS_BEFORE || this.myUpperBound.getPrefix() == ParamPrefixEnum.EQUAL ? lessThan : ComboCondition.or((Condition[])new Condition[]{greaterThan, lessThan});
            }
        }

        private void handleGreaterThanAndGreaterThanOrEqualTo() {
            if (this.myUpperBoundInstant != null) {
                this.myUpperBoundCondition = DatePredicateBuilder.this.createPredicate(this.myHighValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, this.myGenericUpperBound);
                if (DatePredicateBuilder.this.myStorageSettings.isAccountForDateIndexNulls()) {
                    this.myUpperBoundCondition = ComboCondition.or((Condition[])new Condition[]{this.myUpperBoundCondition, DatePredicateBuilder.this.createPredicate(this.myLowValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, this.myGenericUpperBound)});
                }
            } else if (this.myLowerBoundInstant != null) {
                this.myLowerBoundCondition = DatePredicateBuilder.this.createPredicate(this.myHighValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, this.myGenericLowerBound);
                if (DatePredicateBuilder.this.myStorageSettings.isAccountForDateIndexNulls()) {
                    this.myLowerBoundCondition = ComboCondition.or((Condition[])new Condition[]{this.myLowerBoundCondition, DatePredicateBuilder.this.createPredicate(this.myLowValueField, ParamPrefixEnum.GREATERTHAN_OR_EQUALS, this.myGenericLowerBound)});
                }
            } else {
                throw new InvalidRequestException(Msg.code((int)1253) + "upperBound and lowerBound value not correctly specified for greater than (or equal to) compare operator");
            }
        }

        private void handleLessThanAndLessThanOrEqualTo() {
            if (this.myLowerBoundInstant != null) {
                this.myLowerBoundCondition = DatePredicateBuilder.this.createPredicate(this.myLowValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, this.myGenericLowerBound);
                if (DatePredicateBuilder.this.myStorageSettings.isAccountForDateIndexNulls()) {
                    this.myLowerBoundCondition = ComboCondition.or((Condition[])new Condition[]{this.myLowerBoundCondition, DatePredicateBuilder.this.createPredicate(this.myHighValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, this.myGenericLowerBound)});
                }
            } else if (this.myUpperBoundInstant != null) {
                this.myUpperBoundCondition = DatePredicateBuilder.this.createPredicate(this.myLowValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, this.myGenericUpperBound);
                if (DatePredicateBuilder.this.myStorageSettings.isAccountForDateIndexNulls()) {
                    this.myUpperBoundCondition = ComboCondition.or((Condition[])new Condition[]{this.myUpperBoundCondition, DatePredicateBuilder.this.createPredicate(this.myHighValueField, ParamPrefixEnum.LESSTHAN_OR_EQUALS, this.myGenericUpperBound)});
                }
            } else {
                throw new InvalidRequestException(Msg.code((int)1252) + "lowerBound and upperBound value not correctly specified for comparing using lower than (or equal to) compare operator");
            }
        }

        private void init() {
            if (this.isOrdinalComparison()) {
                this.myLowValueField = ColumnEnum.LOW_DATE_ORDINAL;
                this.myHighValueField = ColumnEnum.HIGH_DATE_ORDINAL;
                this.myGenericLowerBound = this.myLowerBoundAsOrdinal;
                this.myGenericUpperBound = this.myUpperBoundAsOrdinal;
                if (this.myUpperBound != null && this.myUpperBound.getPrecision().ordinal() <= TemporalPrecisionEnum.MONTH.ordinal()) {
                    this.myGenericUpperBound = Integer.parseInt(((String)DateUtils.getCompletedDate((String)this.myUpperBound.getValueAsString()).getRight()).replace("-", ""));
                }
            } else {
                this.myLowValueField = ColumnEnum.LOW;
                this.myHighValueField = ColumnEnum.HIGH;
                this.myGenericLowerBound = this.myLowerBoundInstant;
                this.myGenericUpperBound = this.myUpperBoundInstant;
                if (this.myUpperBound != null && this.myUpperBound.getPrecision().ordinal() <= TemporalPrecisionEnum.MONTH.ordinal()) {
                    String theCompleteDateStr = ((String)DateUtils.getCompletedDate((String)this.myUpperBound.getValueAsString()).getRight()).replace("-", "");
                    this.myGenericUpperBound = DateUtils.parseDate((String)theCompleteDateStr);
                }
            }
        }

        private boolean isOrdinalComparison() {
            return DatePredicateBuilder.this.isNullOrDatePrecision(this.myLowerBound) && DatePredicateBuilder.this.isNullOrDatePrecision(this.myUpperBound) && DatePredicateBuilder.this.myStorageSettings.getUseOrdinalDatesForDayPrecisionSearches();
        }
    }

    public static enum ColumnEnum {
        LOW,
        LOW_DATE_ORDINAL,
        HIGH,
        HIGH_DATE_ORDINAL;

    }
}

