/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.BasePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourceIdPredicateBuilder
extends BasePredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceIdPredicateBuilder.class);
    @Autowired
    private IIdHelperService<JpaPid> myIdHelperService;

    public ResourceIdPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder);
    }

    @Nullable
    public Condition createPredicateResourceId(@Nullable DbColumn[] theSourceJoinColumn, String theResourceName, List<List<IQueryParameterType>> theValues, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        HashSet<JpaPid> allOrPids = null;
        SearchFilterParser.CompareOperation defaultOperation = SearchFilterParser.CompareOperation.eq;
        boolean allIdsAreForcedIds = true;
        for (List<IQueryParameterType> nextValue : theValues) {
            HashSet<JpaPid> orPids = new HashSet<JpaPid>();
            boolean haveValue = false;
            for (IQueryParameterType next : nextValue) {
                String value = next.getValueAsQueryToken(this.getFhirContext());
                if (value != null && value.startsWith("|")) {
                    value = value.substring(1);
                }
                IdType valueAsId = new IdType(value);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    if (!this.myIdHelperService.idRequiresForcedId(valueAsId.getIdPart()) && allIdsAreForcedIds) {
                        allIdsAreForcedIds = false;
                    }
                    haveValue = true;
                    try {
                        boolean excludeDeleted = true;
                        JpaPid pid = (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(theRequestPartitionId, theResourceName, valueAsId.getIdPart(), excludeDeleted);
                        orPids.add(pid);
                    }
                    catch (ResourceNotFoundException e) {
                        ourLog.debug("Resource ID {} was requested but does not exist", (Object)valueAsId.getIdPart());
                    }
                }
                if (!(next instanceof TokenParam) || ((TokenParam)next).getModifier() != TokenParamModifier.NOT) continue;
                defaultOperation = SearchFilterParser.CompareOperation.ne;
            }
            if (!haveValue) continue;
            if (allOrPids == null) {
                allOrPids = orPids;
                continue;
            }
            allOrPids.retainAll(orPids);
        }
        if (allOrPids != null && allOrPids.isEmpty()) {
            this.setMatchNothing();
        } else if (allOrPids != null) {
            SearchFilterParser.CompareOperation operation = (SearchFilterParser.CompareOperation)((Object)ObjectUtils.defaultIfNull((Object)((Object)theOperation), (Object)((Object)defaultOperation)));
            assert (operation == SearchFilterParser.CompareOperation.eq || operation == SearchFilterParser.CompareOperation.ne);
            List resourceIds = JpaPid.toLongList((Collection)allOrPids);
            if (theSourceJoinColumn == null) {
                BaseJoiningPredicateBuilder queryRootTable = super.getOrCreateQueryRootTable(!allIdsAreForcedIds);
                switch (operation) {
                    default: {
                        Condition predicate = queryRootTable.createPredicateResourceIds(false, resourceIds);
                        return queryRootTable.combineWithRequestPartitionIdPredicate(theRequestPartitionId, predicate);
                    }
                    case ne: 
                }
                Condition predicate = queryRootTable.createPredicateResourceIds(true, resourceIds);
                return queryRootTable.combineWithRequestPartitionIdPredicate(theRequestPartitionId, predicate);
            }
            DbColumn resIdColumn = ResourceIdPredicateBuilder.getResourceIdColumn(theSourceJoinColumn);
            return QueryParameterUtils.toEqualToOrInPredicate(resIdColumn, this.generatePlaceholders(resourceIds), operation == SearchFilterParser.CompareOperation.ne);
        }
        return null;
    }

    @Nullable
    public static DbColumn getResourceIdColumn(@Nullable DbColumn[] theJoinColumns) {
        DbColumn resIdColumn;
        if (theJoinColumns == null) {
            return null;
        }
        if (theJoinColumns.length == 1) {
            resIdColumn = theJoinColumns[0];
        } else {
            assert (theJoinColumns.length == 2);
            resIdColumn = theJoinColumns[1];
        }
        return resIdColumn;
    }
}

