/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.sql;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ColumnTupleObject
extends SqlObject {
    private final List<Column> myColumns;

    public ColumnTupleObject(Column ... theColumns) {
        this.myColumns = List.of(theColumns);
    }

    protected void collectSchemaObjects(ValidationContext vContext) {
        this.myColumns.forEach(arg_0 -> ((ValidationContext)vContext).addColumn(arg_0));
    }

    public void appendTo(AppendableExt app) throws IOException {
        app.append('(');
        Iterator<Column> iter = this.myColumns.iterator();
        while (iter.hasNext()) {
            Column column = iter.next();
            ColumnTupleObject.appendTableAliasPrefix(app, column.getTable());
            app.append((CharSequence)column.getColumnNameSQL());
            if (!iter.hasNext()) continue;
            app.append(',');
        }
        app.append(')');
    }

    static void appendTableAliasPrefix(AppendableExt app, Table table) throws IOException {
        String alias;
        if (SqlContext.getContext((AppendableExt)app).getUseTableAliases() && StringUtils.isNotBlank((CharSequence)(alias = table.getAlias()))) {
            app.append((CharSequence)alias).append((CharSequence)".");
        }
    }

    public static Object from(DbColumn[] theJoinColumns) {
        if (theJoinColumns.length == 1) {
            return theJoinColumns[0];
        }
        return new ColumnTupleObject((Column[])theJoinColumns);
    }
}

