/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.sql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.config.HibernatePropertiesProvider;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ComboNonUniqueSearchParameterPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ComboUniqueSearchParameterPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.CoordsPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.DatePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.NumberPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.QuantityNormalizedPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.QuantityPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceIdPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceLinkPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceTablePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.SearchParamPresentPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.SourcePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.StringPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TagPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TokenPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.UriPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.GeneratedSql;
import ca.uhn.fhir.jpa.search.builder.sql.SqlObjectFactory;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.ComboExpression;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Join;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbJoin;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchQueryBuilder.class);
    private final String myBindVariableSubstitutionBase;
    private final ArrayList<Object> myBindVariableValues;
    private final DbSpec mySpec;
    private final DbSchema mySchema;
    private final SelectQuery mySelect;
    private final PartitionSettings myPartitionSettings;
    private final RequestPartitionId myRequestPartitionId;
    private final String myResourceType;
    private final StorageSettings myStorageSettings;
    private final FhirContext myFhirContext;
    private final SqlObjectFactory mySqlBuilderFactory;
    private final boolean myCountQuery;
    private final Dialect myDialect;
    private final boolean mySelectPartitionId;
    private boolean myMatchNothing;
    private ResourceTablePredicateBuilder myResourceTableRoot;
    private boolean myHaveAtLeastOnePredicate;
    private BaseJoiningPredicateBuilder myFirstPredicateBuilder;
    private boolean dialectIsMsSql;
    private boolean dialectIsMySql;
    private boolean myNeedResourceTableRoot;
    private int myNextNearnessColumnId = 0;
    private DbColumn mySelectedResourceIdColumn;
    private DbColumn mySelectedPartitionIdColumn;

    public SearchQueryBuilder(FhirContext theFhirContext, StorageSettings theStorageSettings, PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, SqlObjectFactory theSqlBuilderFactory, HibernatePropertiesProvider theDialectProvider, boolean theCountQuery) {
        this(theFhirContext, theStorageSettings, thePartitionSettings, theRequestPartitionId, theResourceType, theSqlBuilderFactory, UUID.randomUUID() + "-", theDialectProvider.getDialect(), theCountQuery, new ArrayList<Object>(), thePartitionSettings.isPartitioningEnabled());
    }

    private SearchQueryBuilder(FhirContext theFhirContext, StorageSettings theStorageSettings, PartitionSettings thePartitionSettings, RequestPartitionId theRequestPartitionId, String theResourceType, SqlObjectFactory theSqlBuilderFactory, String theBindVariableSubstitutionBase, Dialect theDialect, boolean theCountQuery, ArrayList<Object> theBindVariableValues, boolean theSelectPartitionId) {
        this.myFhirContext = theFhirContext;
        this.myStorageSettings = theStorageSettings;
        this.myPartitionSettings = thePartitionSettings;
        this.myRequestPartitionId = theRequestPartitionId;
        this.myResourceType = theResourceType;
        this.mySqlBuilderFactory = theSqlBuilderFactory;
        this.myCountQuery = theCountQuery;
        this.myDialect = theDialect;
        if (this.myDialect instanceof MySQLDialect) {
            this.dialectIsMySql = true;
        }
        if (this.myDialect instanceof SQLServerDialect) {
            this.dialectIsMsSql = true;
        }
        this.mySpec = new DbSpec();
        this.mySchema = this.mySpec.addDefaultSchema();
        this.mySelect = new SelectQuery();
        this.myBindVariableSubstitutionBase = theBindVariableSubstitutionBase;
        this.myBindVariableValues = theBindVariableValues;
        this.mySelectPartitionId = theSelectPartitionId;
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    public ComboUniqueSearchParameterPredicateBuilder addComboUniquePredicateBuilder() {
        ComboUniqueSearchParameterPredicateBuilder retVal = this.mySqlBuilderFactory.newComboUniqueSearchParameterPredicateBuilder(this);
        this.addTable(retVal, null);
        return retVal;
    }

    public ComboNonUniqueSearchParameterPredicateBuilder addComboNonUniquePredicateBuilder() {
        ComboNonUniqueSearchParameterPredicateBuilder retVal = this.mySqlBuilderFactory.newComboNonUniqueSearchParameterPredicateBuilder(this);
        this.addTable(retVal, null);
        return retVal;
    }

    public CoordsPredicateBuilder addCoordsPredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        CoordsPredicateBuilder retVal = this.mySqlBuilderFactory.coordsPredicateBuilder(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public DatePredicateBuilder addDatePredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        DatePredicateBuilder retVal = this.mySqlBuilderFactory.dateIndexTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public DatePredicateBuilder createDatePredicateBuilder() {
        return this.mySqlBuilderFactory.dateIndexTable(this);
    }

    public NumberPredicateBuilder addNumberPredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        NumberPredicateBuilder retVal = this.createNumberPredicateBuilder();
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public NumberPredicateBuilder createNumberPredicateBuilder() {
        return this.mySqlBuilderFactory.numberIndexTable(this);
    }

    public ResourceTablePredicateBuilder addResourceTablePredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        ResourceTablePredicateBuilder retVal = this.mySqlBuilderFactory.resourceTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public QuantityPredicateBuilder addQuantityPredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        QuantityPredicateBuilder retVal = this.createQuantityPredicateBuilder();
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public QuantityPredicateBuilder createQuantityPredicateBuilder() {
        return this.mySqlBuilderFactory.quantityIndexTable(this);
    }

    public QuantityNormalizedPredicateBuilder addQuantityNormalizedPredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        QuantityNormalizedPredicateBuilder retVal = this.mySqlBuilderFactory.quantityNormalizedIndexTable(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public SourcePredicateBuilder addSourcePredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn, SelectQuery.JoinType theJoinType) {
        SourcePredicateBuilder retVal = this.mySqlBuilderFactory.newSourcePredicateBuilder(this);
        this.addTable(retVal, theSourceJoinColumn, theJoinType);
        return retVal;
    }

    public ResourceLinkPredicateBuilder addReferencePredicateBuilder(QueryStack theQueryStack, @Nullable DbColumn[] theSourceJoinColumn) {
        ResourceLinkPredicateBuilder retVal = this.createReferencePredicateBuilder(theQueryStack);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public ResourceLinkPredicateBuilder createReferencePredicateBuilder(QueryStack theQueryStack) {
        return this.mySqlBuilderFactory.referenceIndexTable(theQueryStack, this, false);
    }

    public ResourceLinkPredicateBuilder addReferencePredicateBuilderReversed(QueryStack theQueryStack, DbColumn[] theSourceJoinColumn) {
        ResourceLinkPredicateBuilder retVal = this.mySqlBuilderFactory.referenceIndexTable(theQueryStack, this, true);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public StringPredicateBuilder addStringPredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        StringPredicateBuilder retVal = this.createStringPredicateBuilder();
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public StringPredicateBuilder createStringPredicateBuilder() {
        return this.mySqlBuilderFactory.stringIndexTable(this);
    }

    public TagPredicateBuilder addTagPredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        TagPredicateBuilder retVal = this.mySqlBuilderFactory.newTagPredicateBuilder(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public TokenPredicateBuilder addTokenPredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        TokenPredicateBuilder retVal = this.createTokenPredicateBuilder();
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public TokenPredicateBuilder createTokenPredicateBuilder() {
        return this.mySqlBuilderFactory.tokenIndexTable(this);
    }

    public void addCustomJoin(SelectQuery.JoinType theJoinType, DbTable theFromTable, DbTable theToTable, Condition theCondition) {
        this.mySelect.addCustomJoin(theJoinType, (Object)theFromTable, (Object)theToTable, theCondition);
    }

    public ComboCondition createOnCondition(DbColumn[] theSourceColumn, DbColumn[] theTargetColumn) {
        ComboCondition onCondition = ComboCondition.and();
        for (int i = 0; i < theSourceColumn.length; ++i) {
            onCondition.addCondition((Condition)BinaryCondition.equalTo((Object)theSourceColumn[i], (Object)theTargetColumn[i]));
        }
        return onCondition;
    }

    public SearchParamPresentPredicateBuilder addSearchParamPresentPredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        SearchParamPresentPredicateBuilder retVal = this.mySqlBuilderFactory.searchParamPresentPredicateBuilder(this);
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public UriPredicateBuilder addUriPredicateBuilder(@Nullable DbColumn[] theSourceJoinColumn) {
        UriPredicateBuilder retVal = this.createUriPredicateBuilder();
        this.addTable(retVal, theSourceJoinColumn);
        return retVal;
    }

    public UriPredicateBuilder createUriPredicateBuilder() {
        return this.mySqlBuilderFactory.uriIndexTable(this);
    }

    public SqlObjectFactory getSqlBuilderFactory() {
        return this.mySqlBuilderFactory;
    }

    public ResourceIdPredicateBuilder newResourceIdBuilder() {
        return this.mySqlBuilderFactory.resourceId(this);
    }

    private void addTable(BaseJoiningPredicateBuilder thePredicateBuilder, @Nullable DbColumn[] theSourceJoinColumn) {
        this.addTable(thePredicateBuilder, theSourceJoinColumn, SelectQuery.JoinType.INNER);
    }

    private void addTable(BaseJoiningPredicateBuilder thePredicateBuilder, @Nullable DbColumn[] theSourceJoinColumns, SelectQuery.JoinType theJoinType) {
        if (theSourceJoinColumns != null) {
            DbTable fromTable = theSourceJoinColumns[0].getTable();
            DbTable toTable = thePredicateBuilder.getTable();
            DbColumn[] toColumn = this.toJoinColumns(thePredicateBuilder);
            this.addJoin(fromTable, toTable, theSourceJoinColumns, toColumn, theJoinType);
        } else {
            if (this.myFirstPredicateBuilder == null) {
                BaseJoiningPredicateBuilder root = !this.myNeedResourceTableRoot ? thePredicateBuilder : (thePredicateBuilder instanceof ResourceTablePredicateBuilder ? thePredicateBuilder : this.mySqlBuilderFactory.resourceTable(this));
                if (this.myCountQuery) {
                    this.mySelect.addCustomColumns(new Object[]{FunctionCall.count().setIsDistinct(true).addColumnParams(new Column[]{root.getResourceIdColumn()})});
                } else if (this.mySelectPartitionId) {
                    this.mySelectedResourceIdColumn = root.getResourceIdColumn();
                    this.mySelectedPartitionIdColumn = root.getPartitionIdColumn();
                    this.mySelect.addColumns(new Column[]{this.mySelectedPartitionIdColumn, this.mySelectedResourceIdColumn});
                } else {
                    this.mySelectedResourceIdColumn = root.getResourceIdColumn();
                    this.mySelect.addColumns(new Column[]{this.mySelectedResourceIdColumn});
                }
                this.mySelect.addFromTable((Table)root.getTable());
                this.myFirstPredicateBuilder = root;
                if (!this.myNeedResourceTableRoot || thePredicateBuilder instanceof ResourceTablePredicateBuilder) {
                    return;
                }
            }
            DbTable fromTable = this.myFirstPredicateBuilder.getTable();
            DbTable toTable = thePredicateBuilder.getTable();
            DbColumn[] fromColumn = this.toJoinColumns(this.myFirstPredicateBuilder);
            DbColumn[] toColumn = this.toJoinColumns(thePredicateBuilder);
            this.addJoin(fromTable, toTable, fromColumn, toColumn, theJoinType);
        }
    }

    @Nonnull
    public DbColumn[] toJoinColumns(BaseJoiningPredicateBuilder theBuilder) {
        DbColumn partitionIdColumn = theBuilder.getPartitionIdColumn();
        DbColumn resourceIdColumn = theBuilder.getResourceIdColumn();
        return this.toJoinColumns(partitionIdColumn, resourceIdColumn);
    }

    @Nonnull
    public DbColumn[] toJoinColumns(DbColumn partitionIdColumn, DbColumn resourceIdColumn) {
        if (this.isIncludePartitionIdInJoins()) {
            return new DbColumn[]{partitionIdColumn, resourceIdColumn};
        }
        return new DbColumn[]{resourceIdColumn};
    }

    public boolean isIncludePartitionIdInJoins() {
        return this.mySelectPartitionId && this.myPartitionSettings.isPartitionIdsInPrimaryKeys();
    }

    public void addJoin(DbTable theFromTable, DbTable theToTable, DbColumn[] theFromColumn, DbColumn[] theToColumn) {
        this.addJoin(theFromTable, theToTable, theFromColumn, theToColumn, SelectQuery.JoinType.INNER);
    }

    public void addJoin(DbTable theFromTable, DbTable theToTable, DbColumn[] theFromColumn, DbColumn[] theToColumn, SelectQuery.JoinType theJoinType) {
        assert (theFromColumn.length == theToColumn.length);
        DbJoin join = new DbJoin(this.mySpec, theFromTable, theToTable, theFromColumn, theToColumn);
        this.mySelect.addJoins(theJoinType, new Join[]{join});
    }

    public boolean isSelectPartitionId() {
        return this.mySelectPartitionId;
    }

    public GeneratedSql generate(@Nullable Integer theOffset, @Nullable Integer theMaxResultsToFetch) {
        int idx;
        this.getOrCreateFirstPredicateBuilder();
        this.mySelect.validate();
        Object sql = this.mySelect.toString();
        ArrayList<Object> bindVariables = new ArrayList<Object>();
        while ((idx = ((String)sql).indexOf(this.myBindVariableSubstitutionBase)) != -1) {
            int endIdx = ((String)sql).indexOf("'", idx + this.myBindVariableSubstitutionBase.length());
            String substitutionIndexString = ((String)sql).substring(idx + this.myBindVariableSubstitutionBase.length(), endIdx);
            int substitutionIndex = Integer.parseInt(substitutionIndexString);
            bindVariables.add(this.myBindVariableValues.get(substitutionIndex));
            sql = ((String)sql).substring(0, idx - 1) + "?" + ((String)sql).substring(endIdx + 1);
        }
        Integer maxResultsToFetch = theMaxResultsToFetch;
        Integer offset = theOffset;
        if (offset != null && offset == 0) {
            offset = null;
        }
        if (maxResultsToFetch != null || offset != null) {
            maxResultsToFetch = (Integer)ObjectUtils.defaultIfNull((Object)maxResultsToFetch, (Object)10000);
            String selectedResourceIdColumn = this.mySelectedResourceIdColumn.getColumnNameSQL();
            sql = SearchQueryBuilder.applyLimitToSql(this.myDialect, offset, maxResultsToFetch, (String)sql, selectedResourceIdColumn, bindVariables);
        }
        return new GeneratedSql(this.myMatchNothing, (String)sql, bindVariables);
    }

    public static String applyLimitToSql(Dialect theDialect, Integer theOffset, Integer theMaxResultsToFetch, String theInputSql, @Nullable String theSelectedColumnOrNull, List<Object> theBindVariables) {
        AbstractLimitHandler limitHandler = (AbstractLimitHandler)theDialect.getLimitHandler();
        Limit selection = new Limit();
        selection.setFirstRow(theOffset);
        selection.setMaxRows(theMaxResultsToFetch);
        QueryOptionsImpl queryOptions = new QueryOptionsImpl();
        theInputSql = limitHandler.processSql(theInputSql, selection, (QueryOptions)queryOptions);
        int startOfQueryParameterIndex = 0;
        boolean isSqlServer = theDialect instanceof SQLServerDialect;
        if (isSqlServer) {
            if (theInputSql.contains("order by @@version")) {
                theInputSql = theSelectedColumnOrNull != null ? theInputSql.replace("order by @@version", "order by " + theSelectedColumnOrNull) : theInputSql.replace("order by @@version", "order by 1");
            }
            if (theInputSql.contains("top(?)")) {
                theBindVariables.add(0, theMaxResultsToFetch);
            }
            if (theInputSql.contains("offset 0 rows fetch first ? rows only")) {
                theBindVariables.add(theMaxResultsToFetch);
            }
            if (theInputSql.contains("offset ? rows fetch next ? rows only")) {
                theBindVariables.add(theOffset);
                theBindVariables.add(theMaxResultsToFetch);
            }
            if (theOffset != null && theInputSql.contains("rownumber_")) {
                theBindVariables.add(theOffset + 1);
                theBindVariables.add(theOffset + theMaxResultsToFetch + 1);
            }
        } else if (limitHandler.supportsVariableLimit()) {
            boolean bindLimitParametersFirst = limitHandler.bindLimitParametersFirst();
            if (limitHandler.useMaxForLimit() && theOffset != null) {
                theMaxResultsToFetch = theMaxResultsToFetch + theOffset;
            }
            if (limitHandler.bindLimitParametersInReverseOrder()) {
                startOfQueryParameterIndex = SearchQueryBuilder.bindCountParameter(theBindVariables, theMaxResultsToFetch, limitHandler, startOfQueryParameterIndex, bindLimitParametersFirst);
                SearchQueryBuilder.bindOffsetParameter(theBindVariables, theOffset, limitHandler, startOfQueryParameterIndex, bindLimitParametersFirst);
            } else {
                startOfQueryParameterIndex = SearchQueryBuilder.bindOffsetParameter(theBindVariables, theOffset, limitHandler, startOfQueryParameterIndex, bindLimitParametersFirst);
                SearchQueryBuilder.bindCountParameter(theBindVariables, theMaxResultsToFetch, limitHandler, startOfQueryParameterIndex, bindLimitParametersFirst);
            }
        }
        return theInputSql;
    }

    private static int bindCountParameter(List<Object> bindVariables, Integer maxResultsToFetch, AbstractLimitHandler limitHandler, int startOfQueryParameterIndex, boolean bindLimitParametersFirst) {
        if (limitHandler.supportsLimit()) {
            if (bindLimitParametersFirst) {
                bindVariables.add(startOfQueryParameterIndex++, maxResultsToFetch);
            } else {
                bindVariables.add(maxResultsToFetch);
            }
        }
        return startOfQueryParameterIndex;
    }

    public static int bindOffsetParameter(List<Object> theBindVariables, @Nullable Integer theOffset, AbstractLimitHandler theLimitHandler, int theStartOfQueryParameterIndex, boolean theBindLimitParametersFirst) {
        if (theLimitHandler.supportsLimitOffset() && theOffset != null) {
            if (theBindLimitParametersFirst) {
                theBindVariables.add(theStartOfQueryParameterIndex++, theOffset);
            } else {
                theBindVariables.add(theOffset);
            }
        }
        return theStartOfQueryParameterIndex;
    }

    public BaseJoiningPredicateBuilder getOrCreateFirstPredicateBuilder() {
        return this.getOrCreateFirstPredicateBuilder(true);
    }

    public BaseJoiningPredicateBuilder getOrCreateFirstPredicateBuilder(boolean theIncludeResourceTypeAndNonDeletedFlag) {
        if (this.myFirstPredicateBuilder == null) {
            this.getOrCreateResourceTablePredicateBuilder(theIncludeResourceTypeAndNonDeletedFlag);
        }
        return this.myFirstPredicateBuilder;
    }

    public ResourceTablePredicateBuilder getOrCreateResourceTablePredicateBuilder() {
        return this.getOrCreateResourceTablePredicateBuilder(true);
    }

    public ResourceTablePredicateBuilder getOrCreateResourceTablePredicateBuilder(boolean theIncludeResourceTypeAndNonDeletedFlag) {
        if (this.myResourceTableRoot == null) {
            ResourceTablePredicateBuilder resourceTable = this.mySqlBuilderFactory.resourceTable(this);
            this.addTable(resourceTable, null);
            if (theIncludeResourceTypeAndNonDeletedFlag) {
                Condition typeAndDeletionPredicate = resourceTable.createResourceTypeAndNonDeletedPredicates();
                this.addPredicate(typeAndDeletionPredicate);
            }
            this.myResourceTableRoot = resourceTable;
        }
        return this.myResourceTableRoot;
    }

    public String generatePlaceholder(Object theValue) {
        String placeholder = this.myBindVariableSubstitutionBase + this.myBindVariableValues.size();
        this.myBindVariableValues.add(theValue);
        return placeholder;
    }

    public List<String> generatePlaceholders(Collection<?> theValues) {
        return theValues.stream().map(this::generatePlaceholder).collect(Collectors.toList());
    }

    public int countBindVariables() {
        return this.myBindVariableValues.size();
    }

    public void setMatchNothing() {
        this.myMatchNothing = true;
    }

    public DbTable addTable(String theTableName) {
        return this.mySchema.addTable(theTableName);
    }

    public PartitionSettings getPartitionSettings() {
        return this.myPartitionSettings;
    }

    public RequestPartitionId getRequestPartitionId() {
        return this.myRequestPartitionId;
    }

    public String getResourceType() {
        return this.myResourceType;
    }

    public StorageSettings getStorageSettings() {
        return this.myStorageSettings;
    }

    public void addPredicate(@Nonnull Condition theCondition) {
        assert (theCondition != null);
        this.mySelect.addCondition(theCondition);
        this.myHaveAtLeastOnePredicate = true;
    }

    public ComboCondition addPredicateLastUpdated(DateRangeParam theDateRange) {
        ResourceTablePredicateBuilder resourceTableRoot = this.getOrCreateResourceTablePredicateBuilder(false);
        return this.addPredicateLastUpdated(theDateRange, resourceTableRoot);
    }

    public ComboCondition addPredicateLastUpdated(DateRangeParam theDateRange, ResourceTablePredicateBuilder theResourceTablePredicateBuilder) {
        BinaryCondition condition;
        ArrayList<BinaryCondition> conditions = new ArrayList<BinaryCondition>(2);
        if (this.isNotEqualsComparator(theDateRange)) {
            BinaryCondition condition2 = this.createConditionForValueWithComparator(ParamPrefixEnum.LESSTHAN, theResourceTablePredicateBuilder.getLastUpdatedColumn(), theDateRange.getLowerBoundAsInstant());
            conditions.add(condition2);
            condition2 = this.createConditionForValueWithComparator(ParamPrefixEnum.GREATERTHAN, theResourceTablePredicateBuilder.getLastUpdatedColumn(), theDateRange.getUpperBoundAsInstant());
            conditions.add(condition2);
            return ComboCondition.or((Condition[])conditions.toArray(new Condition[0]));
        }
        if (theDateRange.getLowerBoundAsInstant() != null) {
            condition = this.createConditionForValueWithComparator(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, theResourceTablePredicateBuilder.getLastUpdatedColumn(), theDateRange.getLowerBoundAsInstant());
            conditions.add(condition);
        }
        if (theDateRange.getUpperBoundAsInstant() != null) {
            condition = this.createConditionForValueWithComparator(ParamPrefixEnum.LESSTHAN_OR_EQUALS, theResourceTablePredicateBuilder.getLastUpdatedColumn(), theDateRange.getUpperBoundAsInstant());
            conditions.add(condition);
        }
        return ComboCondition.and((Condition[])conditions.toArray(new Condition[0]));
    }

    private boolean isNotEqualsComparator(DateRangeParam theDateRange) {
        if (theDateRange != null) {
            DateParam lb = theDateRange.getLowerBound();
            DateParam ub = theDateRange.getUpperBound();
            return lb != null && ub != null && lb.getPrefix().equals((Object)ParamPrefixEnum.NOT_EQUAL) && ub.getPrefix().equals((Object)ParamPrefixEnum.NOT_EQUAL);
        }
        return false;
    }

    public void addResourceIdsPredicate(List<Long> thePidList) {
        DbColumn resourceIdColumn = this.getOrCreateFirstPredicateBuilder().getResourceIdColumn();
        InCondition predicate = new InCondition((Object)resourceIdColumn, this.generatePlaceholders(thePidList));
        this.addPredicate((Condition)predicate);
    }

    public void excludeResourceIdsPredicate(Set<JpaPid> theExistingPidSetToExclude) {
        if (theExistingPidSetToExclude == null || theExistingPidSetToExclude.isEmpty()) {
            return;
        }
        List excludePids = JpaPid.toLongList(theExistingPidSetToExclude);
        ourLog.trace("excludePids = {}", (Object)excludePids);
        DbColumn resourceIdColumn = this.getOrCreateFirstPredicateBuilder().getResourceIdColumn();
        InCondition predicate = new InCondition((Object)resourceIdColumn, this.generatePlaceholders(excludePids));
        predicate.setNegate(true);
        this.addPredicate((Condition)predicate);
    }

    public BinaryCondition createConditionForValueWithComparator(ParamPrefixEnum theComparator, DbColumn theColumn, Object theValue) {
        switch (theComparator) {
            case LESSTHAN: {
                return BinaryCondition.lessThan((Object)theColumn, (Object)this.generatePlaceholder(theValue));
            }
            case LESSTHAN_OR_EQUALS: {
                return BinaryCondition.lessThanOrEq((Object)theColumn, (Object)this.generatePlaceholder(theValue));
            }
            case GREATERTHAN: {
                return BinaryCondition.greaterThan((Object)theColumn, (Object)this.generatePlaceholder(theValue));
            }
            case GREATERTHAN_OR_EQUALS: {
                return BinaryCondition.greaterThanOrEq((Object)theColumn, (Object)this.generatePlaceholder(theValue));
            }
            case NOT_EQUAL: {
                return BinaryCondition.notEqualTo((Object)theColumn, (Object)this.generatePlaceholder(theValue));
            }
        }
        throw new IllegalArgumentException(Msg.code((int)1263));
    }

    public SearchQueryBuilder newChildSqlBuilder(boolean theSelectPartitionId) {
        return new SearchQueryBuilder(this.myFhirContext, this.myStorageSettings, this.myPartitionSettings, this.myRequestPartitionId, this.myResourceType, this.mySqlBuilderFactory, this.myBindVariableSubstitutionBase, this.myDialect, false, this.myBindVariableValues, theSelectPartitionId);
    }

    public SelectQuery getSelect() {
        return this.mySelect;
    }

    public boolean haveAtLeastOnePredicate() {
        return this.myHaveAtLeastOnePredicate;
    }

    public void addSortCoordsNear(CoordsPredicateBuilder theCoordsBuilder, double theLatitudeValue, double theLongitudeValue, boolean theAscending) {
        FunctionCall absLatitude = new FunctionCall((Object)"ABS");
        String latitudePlaceholder = this.generatePlaceholder(theLatitudeValue);
        ComboExpression absLatitudeMiddle = new ComboExpression(ComboExpression.Op.SUBTRACT, new Object[]{theCoordsBuilder.getColumnLatitude(), latitudePlaceholder});
        absLatitude = absLatitude.addCustomParams(new Object[]{absLatitudeMiddle});
        FunctionCall absLongitude = new FunctionCall((Object)"ABS");
        String longitudePlaceholder = this.generatePlaceholder(theLongitudeValue);
        ComboExpression absLongitudeMiddle = new ComboExpression(ComboExpression.Op.SUBTRACT, new Object[]{theCoordsBuilder.getColumnLongitude(), longitudePlaceholder});
        absLongitude = absLongitude.addCustomParams(new Object[]{absLongitudeMiddle});
        ComboExpression sum = new ComboExpression(ComboExpression.Op.ADD, new Object[]{absLatitude, absLongitude});
        String ordering = theAscending ? "" : " DESC";
        String columnName = "MHD" + this.myNextNearnessColumnId++;
        this.mySelect.addAliasedColumn((Object)sum, columnName);
        this.mySelect.addCustomOrderings(new Object[]{columnName + ordering});
    }

    public void addSortString(DbColumn theColumnValueNormalized, boolean theAscending) {
        this.addSortString(theColumnValueNormalized, theAscending, false);
    }

    public void addSortString(DbColumn theColumnValueNormalized, boolean theAscending, boolean theUseAggregate) {
        OrderObject.NullOrder nullOrder = OrderObject.NullOrder.LAST;
        this.addSortString(theColumnValueNormalized, theAscending, nullOrder, theUseAggregate);
    }

    public void addSortNumeric(DbColumn theColumnValueNormalized, boolean theAscending) {
        this.addSortNumeric(theColumnValueNormalized, theAscending, false);
    }

    public void addSortNumeric(DbColumn theColumnValueNormalized, boolean theAscending, boolean theUseAggregate) {
        OrderObject.NullOrder nullOrder = OrderObject.NullOrder.LAST;
        this.addSortNumeric(theColumnValueNormalized, theAscending, nullOrder, theUseAggregate);
    }

    public void addSortDate(DbColumn theColumnValueNormalized, boolean theAscending) {
        this.addSortDate(theColumnValueNormalized, theAscending, false);
    }

    public void addSortDate(DbColumn theColumnValueNormalized, boolean theAscending, boolean theUseAggregate) {
        OrderObject.NullOrder nullOrder = OrderObject.NullOrder.LAST;
        this.addSortDate(theColumnValueNormalized, theAscending, nullOrder, theUseAggregate);
    }

    public void addSortString(DbColumn theTheColumnValueNormalized, boolean theTheAscending, OrderObject.NullOrder theNullOrder, boolean theUseAggregate) {
        if (this.dialectIsMySql || this.dialectIsMsSql) {
            String direction = theTheAscending ? " ASC" : " DESC";
            Object sortColumnName = theTheColumnValueNormalized.getTable().getAlias() + "." + theTheColumnValueNormalized.getName();
            StringBuilder sortColumnNameBuilder = new StringBuilder();
            sortColumnName = SearchQueryBuilder.formatColumnNameForAggregate(theTheAscending, theUseAggregate, (String)sortColumnName);
            sortColumnNameBuilder.append((String)sortColumnName).append(direction);
            this.mySelect.addCustomOrderings(new Object[]{sortColumnNameBuilder.toString()});
        } else {
            this.addSort(theTheColumnValueNormalized, theTheAscending, theNullOrder, theUseAggregate);
        }
    }

    private static String formatColumnNameForAggregate(boolean theTheAscending, boolean theUseAggregate, String sortColumnName) {
        if (theUseAggregate) {
            String aggregateFunction = theTheAscending ? "MIN" : "MAX";
            sortColumnName = aggregateFunction + "(" + (String)sortColumnName + ")";
        }
        return sortColumnName;
    }

    public void addSortNumeric(DbColumn theTheColumnValueNormalized, boolean theAscending, OrderObject.NullOrder theNullOrder, boolean theUseAggregate) {
        if (this.dialectIsMySql || this.dialectIsMsSql) {
            String direction;
            Object sortColumnName = theTheColumnValueNormalized.getTable().getAlias() + "." + theTheColumnValueNormalized.getName();
            if (theAscending && theNullOrder == OrderObject.NullOrder.LAST || !theAscending && theNullOrder == OrderObject.NullOrder.FIRST) {
                direction = theAscending ? " DESC" : " ASC";
                sortColumnName = "-" + (String)sortColumnName;
            } else {
                direction = theAscending ? " ASC" : " DESC";
            }
            sortColumnName = SearchQueryBuilder.formatColumnNameForAggregate(theAscending, theUseAggregate, (String)sortColumnName);
            this.mySelect.addCustomOrderings(new Object[]{(String)sortColumnName + direction});
        } else {
            this.addSort(theTheColumnValueNormalized, theAscending, theNullOrder, theUseAggregate);
        }
    }

    public void addSortDate(DbColumn theTheColumnValueNormalized, boolean theTheAscending, OrderObject.NullOrder theNullOrder, boolean theUseAggregate) {
        if (this.dialectIsMySql || this.dialectIsMsSql) {
            String direction = theTheAscending ? " ASC" : " DESC";
            Object sortColumnName = theTheColumnValueNormalized.getTable().getAlias() + "." + theTheColumnValueNormalized.getName();
            StringBuilder sortColumnNameBuilder = new StringBuilder();
            sortColumnName = SearchQueryBuilder.formatColumnNameForAggregate(theTheAscending, theUseAggregate, (String)sortColumnName);
            sortColumnNameBuilder.append((String)sortColumnName).append(direction);
            this.mySelect.addCustomOrderings(new Object[]{sortColumnNameBuilder.toString()});
        } else {
            this.addSort(theTheColumnValueNormalized, theTheAscending, theNullOrder, theUseAggregate);
        }
    }

    private void addSort(DbColumn theTheColumnValueNormalized, boolean theTheAscending, OrderObject.NullOrder theNullOrder, boolean theUseAggregate) {
        OrderObject.Dir direction = theTheAscending ? OrderObject.Dir.ASCENDING : OrderObject.Dir.DESCENDING;
        DbColumn columnToOrder = theTheColumnValueNormalized;
        if (theUseAggregate) {
            columnToOrder = theTheAscending ? FunctionCall.min().addColumnParams(new Column[]{theTheColumnValueNormalized}) : FunctionCall.max().addColumnParams(new Column[]{theTheColumnValueNormalized});
        }
        OrderObject orderObject = new OrderObject(direction, (Object)columnToOrder);
        orderObject.setNullOrder(theNullOrder);
        this.mySelect.addCustomOrderings(new Object[]{orderObject});
    }

    public void setNeedResourceTableRoot(boolean theNeedResourceTableRoot) {
        this.myNeedResourceTableRoot = theNeedResourceTableRoot;
    }
}

