/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.sql;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.search.builder.ISearchQueryExecutor;
import ca.uhn.fhir.jpa.search.builder.sql.GeneratedSql;
import ca.uhn.fhir.jpa.util.ScrollableResultsIterator;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.IoUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.Query;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryExecutor
implements ISearchQueryExecutor {
    private static final Long NO_MORE = -1L;
    private static final SearchQueryExecutor NO_VALUE_EXECUTOR = new SearchQueryExecutor();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Logger ourLog = LoggerFactory.getLogger(SearchQueryExecutor.class);
    private final GeneratedSql myGeneratedSql;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    private boolean myQueryInitialized;
    private ScrollableResultsIterator<Object> myResultSet;
    private Long myNext;

    public SearchQueryExecutor(GeneratedSql theGeneratedSql, Integer theMaxResultsToFetch) {
        Validate.notNull((Object)theGeneratedSql, (String)"theGeneratedSql must not be null", (Object[])new Object[0]);
        this.myGeneratedSql = theGeneratedSql;
        this.myQueryInitialized = false;
    }

    private SearchQueryExecutor() {
        assert (NO_MORE != null);
        this.myGeneratedSql = null;
        this.myNext = NO_MORE;
    }

    @Override
    public void close() {
        IoUtil.closeQuietly(this.myResultSet);
    }

    @Override
    public boolean hasNext() {
        this.fetchNext();
        return !NO_MORE.equals(this.myNext);
    }

    @Override
    public Long next() {
        this.fetchNext();
        Validate.isTrue((boolean)this.hasNext(), (String)"Can not call next() right now, no data remains", (Object[])new Object[0]);
        Long next = this.myNext;
        this.myNext = null;
        return next;
    }

    private void fetchNext() {
        if (this.myNext == null) {
            String sql = this.myGeneratedSql.getSql();
            Object[] args = this.myGeneratedSql.getBindVariables().toArray(EMPTY_OBJECT_ARRAY);
            try {
                if (!this.myQueryInitialized) {
                    HapiTransactionService.requireTransaction();
                    ourLog.trace("About to execute SQL: {}. Parameters: {}", (Object)sql, (Object)Arrays.toString(args));
                    Query nativeQuery = this.myEntityManager.createNativeQuery(sql);
                    org.hibernate.query.Query hibernateQuery = (org.hibernate.query.Query)nativeQuery;
                    for (int i = 1; i <= args.length; ++i) {
                        hibernateQuery.setParameter(i, args[i - 1]);
                    }
                    hibernateQuery.setFetchSize(500000);
                    hibernateQuery.setCacheable(false);
                    hibernateQuery.setCacheMode(CacheMode.IGNORE);
                    hibernateQuery.setReadOnly(true);
                    hibernateQuery.setFlushMode(FlushModeType.COMMIT);
                    ScrollableResults scrollableResults = hibernateQuery.scroll(ScrollMode.FORWARD_ONLY);
                    this.myResultSet = new ScrollableResultsIterator(scrollableResults);
                    this.myQueryInitialized = true;
                }
                this.myNext = this.myResultSet == null || !this.myResultSet.hasNext() ? NO_MORE : Long.valueOf(this.getNextPid(this.myResultSet));
            }
            catch (Exception e) {
                ourLog.error("Failed to create or execute SQL query", (Throwable)e);
                this.close();
                throw new InternalErrorException(Msg.code((int)1262) + e, (Throwable)e);
            }
        }
    }

    private long getNextPid(ScrollableResultsIterator<Object> theResultSet) {
        Object nextRow = Objects.requireNonNull(theResultSet.next());
        if (nextRow instanceof Number) {
            return ((Number)nextRow).longValue();
        }
        Object[] nextRowAsArray = (Object[])nextRow;
        if (nextRowAsArray.length == 1) {
            return (Long)nextRowAsArray[0];
        }
        if (nextRowAsArray[0] instanceof Long) {
            return (Long)nextRowAsArray[0];
        }
        return (Long)nextRowAsArray[1];
    }

    public static SearchQueryExecutor emptyExecutor() {
        return NO_VALUE_EXECUTOR;
    }
}

