/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.tasks;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.search.ExceptionService;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchTask;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchTaskParameters;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import ca.uhn.fhir.jpa.search.cache.ISearchResultCacheSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchContinuationTask
extends SearchTask {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchContinuationTask.class);
    private final ExceptionService myExceptionSvc;
    private final RequestDetails myRequestDetails;

    public SearchContinuationTask(SearchTaskParameters theCreationParams, HapiTransactionService theTxService, FhirContext theContext, IInterceptorBroadcaster theInterceptorBroadcaster, SearchBuilderFactory theSearchBuilderFactory, ISearchResultCacheSvc theSearchResultCacheSvc, JpaStorageSettings theStorageSettings, ISearchCacheSvc theSearchCacheSvc, IPagingProvider thePagingProvider, ExceptionService theExceptionSvc) {
        super(theCreationParams, theTxService, theContext, theInterceptorBroadcaster, theSearchBuilderFactory, theSearchResultCacheSvc, theStorageSettings, theSearchCacheSvc, thePagingProvider);
        this.myRequestDetails = theCreationParams.Request;
        this.myExceptionSvc = theExceptionSvc;
    }

    @Override
    public Void call() {
        try {
            RequestPartitionId requestPartitionId = this.getRequestPartitionId();
            this.myTxService.withRequest(this.myRequestDetails).withRequestPartitionId(requestPartitionId).execute(() -> {
                List<JpaPid> previouslyAddedResourcePids = this.mySearchResultCacheSvc.fetchAllResultPids(this.getSearch(), this.myRequestDetails, requestPartitionId);
                if (previouslyAddedResourcePids == null) {
                    throw this.myExceptionSvc.newUnknownSearchException(this.getSearch().getUuid());
                }
                ourLog.trace("Have {} previously added IDs in search: {}", (Object)previouslyAddedResourcePids.size(), (Object)this.getSearch().getUuid());
                this.setPreviouslyAddedResourcePids(previouslyAddedResourcePids);
            });
        }
        catch (Throwable e) {
            ourLog.error("Failure processing search", e);
            this.getSearch().setFailureMessage(e.getMessage());
            this.getSearch().setStatus(SearchStatusEnum.FAILED);
            if (e instanceof BaseServerResponseException) {
                this.getSearch().setFailureCode(((BaseServerResponseException)e).getStatusCode());
            }
            this.saveSearch();
            return null;
        }
        return super.call();
    }
}

