/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.lastn;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.dao.TolerantJsonParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.search.lastn.ElasticsearchRestClientFactory;
import ca.uhn.fhir.jpa.search.lastn.IElasticsearchSvc;
import ca.uhn.fhir.jpa.search.lastn.json.ObservationJson;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.util.ObjectBuilder;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;

public class ElasticsearchSvcImpl
implements IElasticsearchSvc {
    public static final String OBSERVATION_INDEX = "observation_index";
    public static final String OBSERVATION_CODE_INDEX = "code_index";
    public static final String OBSERVATION_INDEX_SCHEMA_FILE = "ObservationIndexSchema.json";
    public static final String OBSERVATION_CODE_INDEX_SCHEMA_FILE = "ObservationCodeIndexSchema.json";
    private static final String OBSERVATION_IDENTIFIER_FIELD_NAME = "identifier";
    private static final String CODE_HASH = "codingcode_system_hash";
    private static final String CODE_TEXT = "text";
    private static final String OBSERVATION_RESOURCE_NAME = "Observation";
    private final ElasticsearchClient myRestHighLevelClient;
    @Autowired
    private FhirContext myContext;

    public ElasticsearchSvcImpl(PartitionSettings thePartitionSetings, String theProtocol, String theHostname, @Nullable String theUsername, @Nullable String thePassword) {
        this(theProtocol, theHostname, theUsername, thePassword);
    }

    public ElasticsearchSvcImpl(String theProtocol, String theHostname, @Nullable String theUsername, @Nullable String thePassword) {
        this.myRestHighLevelClient = ElasticsearchRestClientFactory.createElasticsearchHighLevelRestClient(theProtocol, theHostname, theUsername, thePassword);
        try {
            this.createObservationIndexIfMissing();
            this.createObservationCodeIndexIfMissing();
        }
        catch (IOException theE) {
            throw new RuntimeException(Msg.code((int)1175) + "Failed to create document index", theE);
        }
    }

    private String getIndexSchema(String theSchemaFileName) throws IOException {
        String str;
        InputStreamReader input = new InputStreamReader(ElasticsearchSvcImpl.class.getResourceAsStream(theSchemaFileName));
        BufferedReader reader = new BufferedReader(input);
        StringBuilder sb = new StringBuilder();
        while ((str = reader.readLine()) != null) {
            sb.append(str);
        }
        return sb.toString();
    }

    private void createObservationIndexIfMissing() throws IOException {
        if (this.indexExists(OBSERVATION_INDEX)) {
            return;
        }
        String observationMapping = this.getIndexSchema(OBSERVATION_INDEX_SCHEMA_FILE);
        if (!this.createIndex(OBSERVATION_INDEX, observationMapping)) {
            throw new RuntimeException(Msg.code((int)1176) + "Failed to create observation index");
        }
    }

    private void createObservationCodeIndexIfMissing() throws IOException {
        if (this.indexExists(OBSERVATION_CODE_INDEX)) {
            return;
        }
        String observationCodeMapping = this.getIndexSchema(OBSERVATION_CODE_INDEX_SCHEMA_FILE);
        if (!this.createIndex(OBSERVATION_CODE_INDEX, observationCodeMapping)) {
            throw new RuntimeException(Msg.code((int)1177) + "Failed to create observation code index");
        }
    }

    private boolean createIndex(String theIndexName, String theMapping) throws IOException {
        return this.myRestHighLevelClient.indices().create(cir -> (ObjectBuilder)cir.index(theIndexName).withJson((Reader)new StringReader(theMapping))).acknowledged();
    }

    private boolean indexExists(String theIndexName) throws IOException {
        ExistsRequest request = new ExistsRequest.Builder().index(theIndexName, new String[0]).build();
        return this.myRestHighLevelClient.indices().exists(request).value();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<IBaseResource> getObservationResources(Collection<? extends IResourcePersistentId> thePids) {
        SearchRequest searchRequest = this.buildObservationResourceSearchRequest(thePids);
        try {
            SearchResponse observationDocumentResponse = this.myRestHighLevelClient.search(searchRequest, ObservationJson.class);
            List observationDocumentHits = observationDocumentResponse.hits().hits();
            TolerantJsonParser parser = TolerantJsonParser.createWithLenientErrorHandling(this.myContext, null);
            Class resourceType = this.myContext.getResourceDefinition(OBSERVATION_RESOURCE_NAME).getImplementingClass();
            return observationDocumentHits.stream().map(Hit::source).map(arg_0 -> ElasticsearchSvcImpl.lambda$getObservationResources$1((IParser)parser, resourceType, arg_0)).collect(Collectors.toList());
        }
        catch (IOException theE) {
            throw new InvalidRequestException(Msg.code((int)2003) + "Unable to execute observation document query for provided IDs " + thePids, (Throwable)theE);
        }
    }

    private SearchRequest buildObservationResourceSearchRequest(Collection<? extends IResourcePersistentId> thePids) {
        List values = thePids.stream().map(Object::toString).map(v -> FieldValue.of((String)v)).collect(Collectors.toList());
        return SearchRequest.of(sr -> sr.index(OBSERVATION_INDEX, new String[0]).query(qb -> qb.bool(bb -> bb.must(bbm -> {
            bbm.terms(terms -> terms.field(OBSERVATION_IDENTIFIER_FIELD_NAME).terms(termsb -> termsb.value(values)));
            return bbm;
        }))).size(Integer.valueOf(thePids.size())));
    }

    @VisibleForTesting
    public void refreshIndex(String theIndexName) throws IOException {
        this.myRestHighLevelClient.indices().refresh(fn -> fn.index(theIndexName, new String[0]));
    }

    private static /* synthetic */ IBaseResource lambda$getObservationResources$1(IParser parser, Class resourceType, ObservationJson observationJson) {
        return parser.parseResource(resourceType, observationJson.getResource());
    }
}

