/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.dao.data.IResourceModifiedDao;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.model.entity.IPersistedResourceModifiedMessage;
import ca.uhn.fhir.jpa.model.entity.IPersistedResourceModifiedMessagePK;
import ca.uhn.fhir.jpa.model.entity.PersistedResourceModifiedMessageEntityPK;
import ca.uhn.fhir.jpa.model.entity.ResourceModifiedEntity;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedMessage;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.messaging.BaseResourceMessage;
import ca.uhn.fhir.subscription.api.IResourceModifiedMessagePersistenceSvc;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class ResourceModifiedMessagePersistenceSvcImpl
implements IResourceModifiedMessagePersistenceSvc {
    private final FhirContext myFhirContext;
    private final IResourceModifiedDao myResourceModifiedDao;
    private final DaoRegistry myDaoRegistry;
    private final ObjectMapper myObjectMapper;
    private final HapiTransactionService myHapiTransactionService;
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceModifiedMessagePersistenceSvcImpl.class);

    public ResourceModifiedMessagePersistenceSvcImpl(FhirContext theFhirContext, IResourceModifiedDao theResourceModifiedDao, DaoRegistry theDaoRegistry, HapiTransactionService theHapiTransactionService) {
        this.myFhirContext = theFhirContext;
        this.myResourceModifiedDao = theResourceModifiedDao;
        this.myDaoRegistry = theDaoRegistry;
        this.myHapiTransactionService = theHapiTransactionService;
        this.myObjectMapper = new ObjectMapper();
    }

    public Page<IPersistedResourceModifiedMessage> findAllOrderedByCreatedTime(Pageable thePageable) {
        return (Page)this.myHapiTransactionService.withSystemRequest().execute(() -> this.myResourceModifiedDao.findAllOrderedByCreatedTime(thePageable));
    }

    public IPersistedResourceModifiedMessage persist(ResourceModifiedMessage theMsg) {
        ResourceModifiedEntity resourceModifiedEntity = this.createEntityFrom(theMsg);
        return (IPersistedResourceModifiedMessage)this.myResourceModifiedDao.save(resourceModifiedEntity);
    }

    public ResourceModifiedMessage inflatePersistedResourceModifiedMessage(ResourceModifiedMessage theResourceModifiedMessage) {
        return this.inflateResourceModifiedMessageFromEntity(this.createEntityFrom(theResourceModifiedMessage));
    }

    public Optional<ResourceModifiedMessage> inflatePersistedResourceModifiedMessageOrNull(ResourceModifiedMessage theResourceModifiedMessage) {
        ResourceModifiedMessage inflatedResourceModifiedMessage = null;
        try {
            inflatedResourceModifiedMessage = this.inflatePersistedResourceModifiedMessage(theResourceModifiedMessage);
        }
        catch (ResourceNotFoundException e) {
            IdDt idDt = new IdDt(theResourceModifiedMessage.getPayloadType(this.myFhirContext), theResourceModifiedMessage.getPayloadId(), theResourceModifiedMessage.getPayloadVersion());
            ourLog.warn("Scheduled submission will be ignored since resource {} cannot be found", (Object)idDt.getIdPart(), (Object)e);
        }
        catch (Exception ex) {
            ourLog.error("Unknown error encountered on inflation of resources.", (Throwable)ex);
        }
        return Optional.ofNullable(inflatedResourceModifiedMessage);
    }

    public ResourceModifiedMessage createResourceModifiedMessageFromEntityWithoutInflation(IPersistedResourceModifiedMessage thePersistedResourceModifiedMessage) {
        ResourceModifiedMessage resourceModifiedMessage = this.getPayloadLessMessageFromString(((ResourceModifiedEntity)thePersistedResourceModifiedMessage).getSummaryResourceModifiedMessage());
        IdDt resourceId = this.createIdDtFromResourceModifiedEntity((ResourceModifiedEntity)thePersistedResourceModifiedMessage);
        resourceModifiedMessage.setPayloadId((IIdType)resourceId);
        return resourceModifiedMessage;
    }

    public long getMessagePersistedCount() {
        return this.myResourceModifiedDao.count();
    }

    public boolean deleteByPK(IPersistedResourceModifiedMessagePK theResourceModifiedPK) {
        int removedCount = this.myResourceModifiedDao.removeById((PersistedResourceModifiedMessageEntityPK)theResourceModifiedPK);
        return removedCount == 1;
    }

    protected ResourceModifiedMessage inflateResourceModifiedMessageFromEntity(ResourceModifiedEntity theResourceModifiedEntity) {
        String resourceType = theResourceModifiedEntity.getResourceType();
        ResourceModifiedMessage retVal = this.getPayloadLessMessageFromString(theResourceModifiedEntity.getSummaryResourceModifiedMessage());
        SystemRequestDetails systemRequestDetails = new SystemRequestDetails().setRequestPartitionId(retVal.getPartitionId());
        IdDt resourceIdDt = this.createIdDtFromResourceModifiedEntity(theResourceModifiedEntity);
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
        IBaseResource iBaseResource = dao.read((IIdType)resourceIdDt, (RequestDetails)systemRequestDetails, true);
        retVal.setNewPayload(this.myFhirContext, iBaseResource);
        return retVal;
    }

    ResourceModifiedEntity createEntityFrom(ResourceModifiedMessage theMsg) {
        IIdType theMsgId = theMsg.getPayloadId(this.myFhirContext);
        ResourceModifiedEntity resourceModifiedEntity = new ResourceModifiedEntity();
        resourceModifiedEntity.setResourceModifiedEntityPK(PersistedResourceModifiedMessageEntityPK.with((String)theMsgId.getIdPart(), (String)theMsgId.getVersionIdPart()));
        String partialModifiedMessage = this.getPayloadLessMessageAsString(theMsg);
        resourceModifiedEntity.setSummaryResourceModifiedMessage(partialModifiedMessage);
        resourceModifiedEntity.setResourceType(theMsgId.getResourceType());
        resourceModifiedEntity.setCreatedTime(new Date());
        return resourceModifiedEntity;
    }

    private ResourceModifiedMessage getPayloadLessMessageFromString(String thePayloadLessMessage) {
        try {
            return (ResourceModifiedMessage)this.myObjectMapper.readValue(thePayloadLessMessage, ResourceModifiedMessage.class);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(Msg.code((int)2334) + "Failed to json deserialize payloadless  message", (Throwable)e);
        }
    }

    private String getPayloadLessMessageAsString(ResourceModifiedMessage theMsg) {
        PayloadLessResourceModifiedMessage tempMessage = new PayloadLessResourceModifiedMessage(theMsg);
        try {
            return this.myObjectMapper.writeValueAsString((Object)tempMessage);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException(Msg.code((int)2335) + "Failed to serialize empty ResourceModifiedMessage", (Throwable)e);
        }
    }

    private IdDt createIdDtFromResourceModifiedEntity(ResourceModifiedEntity theResourceModifiedEntity) {
        String resourcePid = theResourceModifiedEntity.getResourceModifiedEntityPK().getResourcePid();
        String resourceVersion = theResourceModifiedEntity.getResourceModifiedEntityPK().getResourceVersion();
        String resourceType = theResourceModifiedEntity.getResourceType();
        return new IdDt(resourceType, resourcePid, resourceVersion);
    }

    private static class PayloadLessResourceModifiedMessage
    extends ResourceModifiedMessage {
        public PayloadLessResourceModifiedMessage(ResourceModifiedMessage theMsg) {
            this.myPayloadId = theMsg.getPayloadId();
            this.myPayloadVersion = theMsg.getPayloadVersion();
            this.setSubscriptionId(theMsg.getSubscriptionId());
            this.setMediaType(theMsg.getMediaType());
            this.setOperationType(theMsg.getOperationType());
            this.setPartitionId(theMsg.getPartitionId());
            this.setTransactionId(theMsg.getTransactionId());
            this.setMessageKey(theMsg.getMessageKeyOrNull());
            this.copyAdditionalPropertiesFrom((BaseResourceMessage)theMsg);
        }
    }
}

