/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResult;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.model.TranslationRequest;
import ca.uhn.fhir.jpa.dao.data.ITermConceptMapGroupDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptMapGroupElementDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptMapGroupElementTargetDao;
import ca.uhn.fhir.jpa.entity.TermConceptMap;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroup;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElement;
import ca.uhn.fhir.jpa.entity.TermConceptMapGroupElementTarget;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.TermConceptClientMappingSvcImpl;
import ca.uhn.fhir.jpa.term.TermReadSvcImpl;
import ca.uhn.fhir.jpa.term.api.ITermConceptMappingSvc;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.util.ValidateUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class TermConceptMappingSvcImpl
extends TermConceptClientMappingSvcImpl
implements ITermConceptMappingSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(TermConceptMappingSvcImpl.class);
    @Autowired
    protected ITermConceptMapGroupDao myConceptMapGroupDao;
    @Autowired
    protected ITermConceptMapGroupElementDao myConceptMapGroupElementDao;
    @Autowired
    protected ITermConceptMapGroupElementTargetDao myConceptMapGroupElementTargetDao;

    public String getName() {
        return this.getFhirContext().getVersion().getVersion() + " ConceptMap Validation Support";
    }

    @Override
    @Transactional
    public void deleteConceptMapAndChildren(ResourceTable theResourceTable) {
        this.deleteConceptMap(theResourceTable);
    }

    @Transactional
    public TranslateConceptResults translateConcept(IValidationSupport.TranslateCodeRequest theRequest) {
        TranslationRequest request = TranslationRequest.fromTranslateCodeRequest((IValidationSupport.TranslateCodeRequest)theRequest);
        if (request.hasReverse() && request.getReverseAsBoolean()) {
            return this.translateWithReverse(request);
        }
        return this.translate(request);
    }

    @Override
    @Transactional
    public void storeTermConceptMapAndChildren(ResourceTable theResourceTable, ConceptMap theConceptMap) {
        String target;
        ValidateUtil.isTrueOrThrowInvalidRequest((theResourceTable != null ? 1 : 0) != 0, (String)"No resource supplied", (Object[])new Object[0]);
        if (TermReadSvcImpl.isPlaceholder((DomainResource)theConceptMap)) {
            ourLog.info("Not storing TermConceptMap for placeholder {}", (Object)theConceptMap.getIdElement().toVersionless().getValueAsString());
            return;
        }
        ValidateUtil.isNotBlankOrThrowUnprocessableEntity((String)theConceptMap.getUrl(), (String)"ConceptMap has no value for ConceptMap.url");
        ourLog.info("Storing TermConceptMap for {}", (Object)theConceptMap.getIdElement().toVersionless().getValueAsString());
        TermConceptMap termConceptMap = new TermConceptMap();
        termConceptMap.setResource(theResourceTable);
        termConceptMap.setUrl(theConceptMap.getUrl());
        termConceptMap.setVersion(theConceptMap.getVersion());
        String source = theConceptMap.hasSourceUriType() ? theConceptMap.getSourceUriType().getValueAsString() : null;
        String string = target = theConceptMap.hasTargetUriType() ? theConceptMap.getTargetUriType().getValueAsString() : null;
        if ("StructureDefinition".equals(new IdType(source).getResourceType()) || "StructureDefinition".equals(new IdType(target).getResourceType())) {
            return;
        }
        if (source == null && theConceptMap.hasSourceCanonicalType()) {
            source = theConceptMap.getSourceCanonicalType().getValueAsString();
        }
        if (target == null && theConceptMap.hasTargetCanonicalType()) {
            target = theConceptMap.getTargetCanonicalType().getValueAsString();
        }
        this.deleteConceptMap(theResourceTable);
        String conceptMapUrl = termConceptMap.getUrl();
        String conceptMapVersion = termConceptMap.getVersion();
        Optional<TermConceptMap> optionalExistingTermConceptMapByUrl = StringUtils.isBlank((CharSequence)conceptMapVersion) ? this.myConceptMapDao.findTermConceptMapByUrlAndNullVersion(conceptMapUrl) : this.myConceptMapDao.findTermConceptMapByUrlAndVersion(conceptMapUrl, conceptMapVersion);
        if (optionalExistingTermConceptMapByUrl.isEmpty()) {
            try {
                if (StringUtils.isNotBlank((CharSequence)source)) {
                    termConceptMap.setSource(source);
                }
                if (StringUtils.isNotBlank((CharSequence)target)) {
                    termConceptMap.setTarget(target);
                }
            }
            catch (FHIRException fe) {
                throw new InternalErrorException(Msg.code((int)837) + fe);
            }
            termConceptMap = (TermConceptMap)this.myConceptMapDao.save(termConceptMap);
            int codesSaved = 0;
            for (ConceptMap.ConceptMapGroupComponent group : theConceptMap.getGroup()) {
                String groupSource = group.getSource();
                if (StringUtils.isBlank((CharSequence)groupSource)) {
                    groupSource = source;
                }
                if (StringUtils.isBlank((CharSequence)groupSource)) {
                    throw new UnprocessableEntityException(Msg.code((int)838) + "ConceptMap[url='" + theConceptMap.getUrl() + "'] contains at least one group without a value in ConceptMap.group.source");
                }
                String groupTarget = group.getTarget();
                if (StringUtils.isBlank((CharSequence)groupTarget)) {
                    groupTarget = target;
                }
                if (StringUtils.isBlank((CharSequence)groupTarget)) {
                    throw new UnprocessableEntityException(Msg.code((int)839) + "ConceptMap[url='" + theConceptMap.getUrl() + "'] contains at least one group without a value in ConceptMap.group.target");
                }
                TermConceptMapGroup termConceptMapGroup = new TermConceptMapGroup();
                termConceptMapGroup.setConceptMap(termConceptMap);
                termConceptMapGroup.setSource(groupSource);
                termConceptMapGroup.setSourceVersion(group.getSourceVersion());
                termConceptMapGroup.setTarget(groupTarget);
                termConceptMapGroup.setTargetVersion(group.getTargetVersion());
                termConceptMap.getConceptMapGroups().add(termConceptMapGroup);
                termConceptMapGroup = (TermConceptMapGroup)this.myConceptMapGroupDao.save(termConceptMapGroup);
                if (!group.hasElement()) continue;
                for (ConceptMap.SourceElementComponent element : group.getElement()) {
                    if (StringUtils.isBlank((CharSequence)element.getCode())) continue;
                    TermConceptMapGroupElement termConceptMapGroupElement = new TermConceptMapGroupElement();
                    termConceptMapGroupElement.setConceptMapGroup(termConceptMapGroup);
                    termConceptMapGroupElement.setCode(element.getCode());
                    termConceptMapGroupElement.setDisplay(element.getDisplay());
                    termConceptMapGroup.getConceptMapGroupElements().add(termConceptMapGroupElement);
                    termConceptMapGroupElement = (TermConceptMapGroupElement)this.myConceptMapGroupElementDao.save(termConceptMapGroupElement);
                    if (!element.hasTarget()) continue;
                    for (ConceptMap.TargetElementComponent elementTarget : element.getTarget()) {
                        if (StringUtils.isBlank((CharSequence)elementTarget.getCode()) && elementTarget.getEquivalence() != Enumerations.ConceptMapEquivalence.UNMATCHED) continue;
                        TermConceptMapGroupElementTarget termConceptMapGroupElementTarget = new TermConceptMapGroupElementTarget();
                        termConceptMapGroupElementTarget.setConceptMapGroupElement(termConceptMapGroupElement);
                        if (StringUtils.isNotBlank((CharSequence)elementTarget.getCode())) {
                            termConceptMapGroupElementTarget.setCode(elementTarget.getCode());
                            termConceptMapGroupElementTarget.setDisplay(elementTarget.getDisplay());
                        }
                        termConceptMapGroupElementTarget.setEquivalence(elementTarget.getEquivalence());
                        termConceptMapGroupElement.getConceptMapGroupElementTargets().add(termConceptMapGroupElementTarget);
                        this.myConceptMapGroupElementTargetDao.save(termConceptMapGroupElementTarget);
                        if (++codesSaved % 250 != 0) continue;
                        ourLog.info("Have saved {} codes in ConceptMap", (Object)codesSaved);
                        this.myConceptMapGroupElementTargetDao.flush();
                    }
                }
            }
        } else {
            TermConceptMap existingTermConceptMap = optionalExistingTermConceptMapByUrl.get();
            if (StringUtils.isBlank((CharSequence)conceptMapVersion)) {
                String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "cannotCreateDuplicateConceptMapUrl", new Object[]{conceptMapUrl, existingTermConceptMap.getResource().getIdDt().toUnqualifiedVersionless().getValue()});
                throw new UnprocessableEntityException(Msg.code((int)840) + msg);
            }
            String msg = this.myContext.getLocalizer().getMessage(TermReadSvcImpl.class, "cannotCreateDuplicateConceptMapUrlAndVersion", new Object[]{conceptMapUrl, conceptMapVersion, existingTermConceptMap.getResource().getIdDt().toUnqualifiedVersionless().getValue()});
            throw new UnprocessableEntityException(Msg.code((int)841) + msg);
        }
        ourLog.info("Done storing TermConceptMap[{}] for {}", (Object)termConceptMap.getId(), (Object)theConceptMap.getIdElement().toVersionless().getValueAsString());
    }

    public void deleteConceptMap(ResourceTable theResourceTable) {
        Optional<TermConceptMap> optionalExistingTermConceptMapById = this.myConceptMapDao.findTermConceptMapByResourcePid(theResourceTable.getId());
        if (optionalExistingTermConceptMapById.isPresent()) {
            TermConceptMap existingTermConceptMap = optionalExistingTermConceptMapById.get();
            ourLog.info("Deleting existing TermConceptMap[{}] and its children...", (Object)existingTermConceptMap.getId());
            for (TermConceptMapGroup group : existingTermConceptMap.getConceptMapGroups()) {
                for (TermConceptMapGroupElement element : group.getConceptMapGroupElements()) {
                    for (TermConceptMapGroupElementTarget target : element.getConceptMapGroupElementTargets()) {
                        this.myConceptMapGroupElementTargetDao.deleteTermConceptMapGroupElementTargetById(target.getId());
                    }
                    this.myConceptMapGroupElementDao.deleteTermConceptMapGroupElementById(element.getId());
                }
                this.myConceptMapGroupDao.deleteTermConceptMapGroupById(group.getId());
            }
            this.myConceptMapDao.deleteTermConceptMapById(existingTermConceptMap.getId());
            ourLog.info("Done deleting existing TermConceptMap[{}] and its children.", (Object)existingTermConceptMap.getId());
        }
    }

    @VisibleForTesting
    public static void clearOurLastResultsFromTranslationCache() {
        ourLastResultsFromTranslationCache = false;
    }

    @VisibleForTesting
    public static void clearOurLastResultsFromTranslationWithReverseCache() {
        ourLastResultsFromTranslationWithReverseCache = false;
    }

    @VisibleForTesting
    static boolean isOurLastResultsFromTranslationCache() {
        return ourLastResultsFromTranslationCache;
    }

    @VisibleForTesting
    static boolean isOurLastResultsFromTranslationWithReverseCache() {
        return ourLastResultsFromTranslationWithReverseCache;
    }

    public static Parameters toParameters(TranslateConceptResults theTranslationResult) {
        Parameters retVal = new Parameters();
        retVal.addParameter().setName("result").setValue((Type)new BooleanType(theTranslationResult.getResult()));
        if (theTranslationResult.getMessage() != null) {
            retVal.addParameter().setName("message").setValue((Type)new StringType(theTranslationResult.getMessage()));
        }
        for (TranslateConceptResult translationMatch : theTranslationResult.getResults()) {
            Parameters.ParametersParameterComponent matchParam = retVal.addParameter().setName("match");
            TermConceptMappingSvcImpl.populateTranslateMatchParts(translationMatch, matchParam);
        }
        return retVal;
    }

    private static void populateTranslateMatchParts(TranslateConceptResult theTranslationMatch, Parameters.ParametersParameterComponent theParam) {
        if (theTranslationMatch.getEquivalence() != null) {
            theParam.addPart().setName("equivalence").setValue((Type)new CodeType(theTranslationMatch.getEquivalence()));
        }
        if (StringUtils.isNotBlank((CharSequence)theTranslationMatch.getSystem()) || StringUtils.isNotBlank((CharSequence)theTranslationMatch.getCode()) || StringUtils.isNotBlank((CharSequence)theTranslationMatch.getDisplay())) {
            Coding value = new Coding(theTranslationMatch.getSystem(), theTranslationMatch.getCode(), theTranslationMatch.getDisplay());
            if (StringUtils.isNotBlank((CharSequence)theTranslationMatch.getSystemVersion())) {
                value.setVersion(theTranslationMatch.getSystemVersion());
            }
            theParam.addPart().setName("concept").setValue((Type)value);
        }
        if (StringUtils.isNotBlank((CharSequence)theTranslationMatch.getConceptMapUrl())) {
            theParam.addPart().setName("source").setValue((Type)new UriType(theTranslationMatch.getConceptMapUrl()));
        }
    }
}

