/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.jpa.batch.models.Batch2JobStartResponse;
import ca.uhn.fhir.jpa.dao.data.ITermCodeSystemDao;
import ca.uhn.fhir.jpa.dao.data.ITermCodeSystemVersionDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptParentChildLinkDao;
import ca.uhn.fhir.jpa.entity.TermCodeSystem;
import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.term.TermConceptDaoSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.jpa.term.models.TermCodeSystemDeleteJobParameters;
import ca.uhn.fhir.jpa.term.models.TermCodeSystemDeleteVersionJobParameters;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.TimeoutManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ValueSet;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TermDeferredStorageSvcImpl
implements ITermDeferredStorageSvc,
IHasScheduledJobs {
    private static final Logger ourLog = LoggerFactory.getLogger(TermDeferredStorageSvcImpl.class);
    private static final long SAVE_ALL_DEFERRED_WARN_MINUTES = 1L;
    private static final long SAVE_ALL_DEFERRED_ERROR_MINUTES = 5L;
    private boolean myAllowDeferredTasksTimeout = true;
    private static final List<String> BATCH_JOBS_TO_CARE_ABOUT = List.of("termCodeSystemDeleteJob", "termCodeSystemVersionDeleteJob");
    private final List<TermCodeSystem> myDeferredCodeSystemsDeletions = Collections.synchronizedList(new ArrayList());
    private final Queue<TermCodeSystemVersion> myDeferredCodeSystemVersionsDeletions = new ConcurrentLinkedQueue<TermCodeSystemVersion>();
    private final List<TermConcept> myDeferredConcepts = Collections.synchronizedList(new ArrayList());
    private final List<ValueSet> myDeferredValueSets = Collections.synchronizedList(new ArrayList());
    private final List<ConceptMap> myDeferredConceptMaps = Collections.synchronizedList(new ArrayList());
    private final List<TermConceptParentChildLink> myConceptLinksToSaveLater = Collections.synchronizedList(new ArrayList());
    private final List<String> myJobExecutions = Collections.synchronizedList(new ArrayList());
    @Autowired
    protected ITermConceptDao myConceptDao;
    @Autowired
    protected ITermCodeSystemDao myCodeSystemDao;
    @Autowired
    protected ITermCodeSystemVersionDao myCodeSystemVersionDao;
    @Autowired
    protected PlatformTransactionManager myTransactionMgr;
    private boolean myProcessDeferred = true;
    @Autowired
    private ITermConceptParentChildLinkDao myConceptParentChildLinkDao;
    @Autowired
    private ITermVersionAdapterSvc myTerminologyVersionAdapterSvc;
    @Autowired
    private TermConceptDaoSvc myTermConceptDaoSvc;
    @Autowired
    private IJobCoordinator myJobCoordinator;

    @Override
    public void addConceptToStorageQueue(TermConcept theConcept) {
        Validate.notNull((Object)theConcept);
        this.myDeferredConcepts.add(theConcept);
    }

    @Override
    public void addConceptLinkToStorageQueue(TermConceptParentChildLink theConceptLink) {
        Validate.notNull((Object)theConceptLink);
        this.myConceptLinksToSaveLater.add(theConceptLink);
    }

    @Override
    public void addConceptMapsToStorageQueue(List<ConceptMap> theConceptMaps) {
        Validate.notNull(theConceptMaps);
        this.myDeferredConceptMaps.addAll(theConceptMaps);
    }

    @Override
    public void addValueSetsToStorageQueue(List<ValueSet> theValueSets) {
        Validate.notNull(theValueSets);
        this.myDeferredValueSets.addAll(theValueSets);
    }

    @Override
    public void deleteCodeSystemForResource(ResourceTable theCodeSystemToDelete) {
        TermCodeSystem termCodeSystemToDelete = this.myCodeSystemDao.findByResourcePid(theCodeSystemToDelete.getResourceId());
        if (termCodeSystemToDelete != null) {
            termCodeSystemToDelete.setCodeSystemUri("urn:uuid:" + UUID.randomUUID());
            this.myCodeSystemDao.save(termCodeSystemToDelete);
            this.myDeferredCodeSystemsDeletions.add(termCodeSystemToDelete);
            return;
        }
        List<TermCodeSystemVersion> codeSystemVersionsToDelete = this.myCodeSystemVersionDao.findByCodeSystemResourcePid(theCodeSystemToDelete.getResourceId());
        for (TermCodeSystemVersion codeSystemVersionToDelete : codeSystemVersionsToDelete) {
            if (codeSystemVersionToDelete == null) continue;
            this.myDeferredCodeSystemVersionsDeletions.add(codeSystemVersionToDelete);
        }
    }

    @Override
    public void setProcessDeferred(boolean theProcessDeferred) {
        this.myProcessDeferred = theProcessDeferred;
    }

    private void processDeferredConceptMaps() {
        int count = Math.min(this.myDeferredConceptMaps.size(), 20);
        for (ConceptMap nextConceptMap : new ArrayList<ConceptMap>(this.myDeferredConceptMaps.subList(0, count))) {
            ourLog.info("Creating ConceptMap: {}", (Object)nextConceptMap.getId());
            this.myTerminologyVersionAdapterSvc.createOrUpdateConceptMap(nextConceptMap);
            this.myDeferredConceptMaps.remove(nextConceptMap);
        }
        ourLog.info("Saved {} deferred ConceptMap resources, have {} remaining", (Object)count, (Object)this.myDeferredConceptMaps.size());
    }

    private void processDeferredConcepts() {
        Serializable next;
        int codeCount = 0;
        int relCount = 0;
        StopWatch stopwatch = new StopWatch();
        int count = Math.min(1000, this.myDeferredConcepts.size());
        ourLog.debug("Saving {} deferred concepts...", (Object)count);
        while (codeCount < count && this.myDeferredConcepts.size() > 0) {
            next = this.myDeferredConcepts.remove(0);
            if (this.myCodeSystemVersionDao.findById(((TermConcept)next).getCodeSystemVersion().getPid()).isPresent()) {
                try {
                    codeCount += this.myTermConceptDaoSvc.saveConcept((TermConcept)next);
                }
                catch (Exception theE) {
                    ourLog.error("Exception thrown when attempting to save TermConcept {} in Code System {}", new Object[]{((TermConcept)next).getCode(), ((TermConcept)next).getCodeSystemVersion().getCodeSystemDisplayName(), theE});
                }
                continue;
            }
            ourLog.warn("Unable to save deferred TermConcept {} because Code System {} version PID {} is no longer valid. Code system may have since been replaced.", new Object[]{((TermConcept)next).getCode(), ((TermConcept)next).getCodeSystemVersion().getCodeSystemDisplayName(), ((TermConcept)next).getCodeSystemVersion().getPid()});
        }
        if (codeCount > 0) {
            ourLog.info("Saved {} deferred concepts ({} codes remain and {} relationships remain) in {}ms ({} codes/sec)", new Object[]{codeCount, this.myDeferredConcepts.size(), this.myConceptLinksToSaveLater.size(), stopwatch.getMillis(), stopwatch.formatThroughput((long)codeCount, TimeUnit.SECONDS)});
        }
        if (codeCount == 0) {
            count = Math.min(1000, this.myConceptLinksToSaveLater.size());
            ourLog.info("Saving {} deferred concept relationships...", (Object)count);
            while (relCount < count && this.myConceptLinksToSaveLater.size() > 0) {
                next = this.myConceptLinksToSaveLater.remove(0);
                assert (((TermConceptParentChildLink)next).getChild() != null);
                assert (((TermConceptParentChildLink)next).getParent() != null);
                if (((TermConceptParentChildLink)next).getChild().getId() == null || !this.myConceptDao.findById(((TermConceptParentChildLink)next).getChild().getId()).isPresent() || ((TermConceptParentChildLink)next).getParent().getId() == null || !this.myConceptDao.findById(((TermConceptParentChildLink)next).getParent().getId()).isPresent()) {
                    ourLog.warn("Not inserting link from child {} to parent {} because it appears to have been deleted", (Object)((TermConceptParentChildLink)next).getParent().getCode(), (Object)((TermConceptParentChildLink)next).getChild().getCode());
                    continue;
                }
                this.saveConceptLink((TermConceptParentChildLink)next);
                ++relCount;
            }
        }
        if (relCount > 0) {
            ourLog.info("Saved {} deferred relationships ({} remain) in {}ms ({} entries/sec)", new Object[]{relCount, this.myConceptLinksToSaveLater.size(), stopwatch.getMillis(), stopwatch.formatThroughput((long)relCount, TimeUnit.SECONDS)});
        }
        if (this.myDeferredConcepts.size() + this.myConceptLinksToSaveLater.size() == 0) {
            ourLog.info("All deferred concepts and relationships have now been synchronized to the database");
        }
    }

    private void processDeferredValueSets() {
        int count = Math.min(this.myDeferredValueSets.size(), 200);
        for (ValueSet nextValueSet : new ArrayList<ValueSet>(this.myDeferredValueSets.subList(0, count))) {
            ourLog.info("Creating ValueSet: {}", (Object)nextValueSet.getId());
            this.myTerminologyVersionAdapterSvc.createOrUpdateValueSet(nextValueSet);
            this.myDeferredValueSets.remove(nextValueSet);
        }
        ourLog.info("Saved {} deferred ValueSet resources, have {} remaining", (Object)count, (Object)this.myDeferredValueSets.size());
    }

    @VisibleForTesting
    public synchronized void clearDeferred() {
        this.myProcessDeferred = true;
        this.myDeferredValueSets.clear();
        this.myDeferredConceptMaps.clear();
        this.myDeferredConcepts.clear();
        this.myDeferredCodeSystemsDeletions.clear();
        this.myConceptLinksToSaveLater.clear();
        this.myDeferredCodeSystemVersionsDeletions.clear();
        this.clearJobExecutions();
    }

    private void clearJobExecutions() {
        for (String id : new ArrayList<String>(this.myJobExecutions)) {
            this.myJobCoordinator.cancelInstance(id);
        }
        this.myJobExecutions.clear();
    }

    @Override
    public void notifyJobEnded(String theId) {
        this.myJobExecutions.remove(theId);
    }

    private <T> T runInTransaction(Supplier<T> theRunnable) {
        assert (!TransactionSynchronizationManager.isActualTransactionActive());
        return (T)new TransactionTemplate(this.myTransactionMgr).execute(tx -> theRunnable.get());
    }

    @Override
    public void saveAllDeferred() {
        TimeoutManager timeoutManager = null;
        if (this.myAllowDeferredTasksTimeout) {
            timeoutManager = new TimeoutManager(TermDeferredStorageSvcImpl.class.getName() + ".saveAllDeferred()", Duration.of(1L, ChronoUnit.MINUTES), Duration.of(5L, ChronoUnit.MINUTES));
        }
        while (!this.isStorageQueueEmpty(false)) {
            if (this.myAllowDeferredTasksTimeout && timeoutManager.checkTimeout()) {
                ourLog.info(this.toString());
            }
            this.saveDeferred();
        }
    }

    @Override
    @Transactional(propagation=Propagation.NEVER)
    public synchronized void saveDeferred() {
        if (this.isProcessDeferredPaused()) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (!(this.isDeferredConcepts() || this.isConceptLinksToSaveLater() || this.isDeferredValueSets() || this.isDeferredConceptMaps() || this.isDeferredCodeSystemDeletions())) {
                return;
            }
            if (this.isDeferredConceptsOrConceptLinksToSaveLater()) {
                this.runInTransaction(() -> {
                    this.processDeferredConcepts();
                    return null;
                });
                continue;
            }
            if (this.isDeferredValueSets()) {
                this.runInTransaction(() -> {
                    this.processDeferredValueSets();
                    return null;
                });
                continue;
            }
            if (this.isDeferredConceptMaps()) {
                this.runInTransaction(() -> {
                    this.processDeferredConceptMaps();
                    return null;
                });
                continue;
            }
            if (this.isDeferredCodeSystemVersionDeletions()) {
                this.processDeferredCodeSystemVersionDeletions();
            }
            if (!this.isDeferredCodeSystemDeletions()) continue;
            this.processDeferredCodeSystemDeletions();
        }
    }

    private boolean isDeferredCodeSystemVersionDeletions() {
        return !this.myDeferredCodeSystemVersionsDeletions.isEmpty();
    }

    private void processDeferredCodeSystemDeletions() {
        for (TermCodeSystem next : this.myDeferredCodeSystemsDeletions) {
            this.deleteTermCodeSystemOffline(next.getPid());
        }
        this.myDeferredCodeSystemsDeletions.clear();
    }

    private void processDeferredCodeSystemVersionDeletions() {
        for (TermCodeSystemVersion next : this.myDeferredCodeSystemVersionsDeletions) {
            this.deleteTermCodeSystemVersionOffline(next.getPid());
        }
        this.myDeferredCodeSystemVersionsDeletions.clear();
    }

    private void deleteTermCodeSystemVersionOffline(Long theCodeSystemVersionPid) {
        JobInstanceStartRequest request = new JobInstanceStartRequest();
        request.setJobDefinitionId("termCodeSystemVersionDeleteJob");
        TermCodeSystemDeleteVersionJobParameters parameters = new TermCodeSystemDeleteVersionJobParameters();
        parameters.setCodeSystemVersionPid(theCodeSystemVersionPid.longValue());
        request.setParameters((IModelJson)parameters);
        Batch2JobStartResponse response = this.myJobCoordinator.startInstance((RequestDetails)new SystemRequestDetails(), request);
        this.myJobExecutions.add(response.getInstanceId());
    }

    private void deleteTermCodeSystemOffline(Long theCodeSystemPid) {
        TermCodeSystemDeleteJobParameters parameters = new TermCodeSystemDeleteJobParameters();
        parameters.setTermPid(theCodeSystemPid.longValue());
        JobInstanceStartRequest request = new JobInstanceStartRequest();
        request.setParameters((IModelJson)parameters);
        request.setJobDefinitionId("termCodeSystemDeleteJob");
        Batch2JobStartResponse response = this.myJobCoordinator.startInstance((RequestDetails)new SystemRequestDetails(), request);
        this.myJobExecutions.add(response.getInstanceId());
    }

    @Override
    public boolean isStorageQueueEmpty(boolean theIncludeExecutingJobs) {
        boolean retVal = !this.isProcessDeferredPaused();
        retVal &= !this.isDeferredConcepts();
        retVal &= !this.isConceptLinksToSaveLater();
        retVal &= !this.isDeferredValueSets();
        retVal &= !this.isDeferredConceptMaps();
        retVal &= !this.isDeferredCodeSystemDeletions();
        if (theIncludeExecutingJobs) {
            retVal &= !this.isJobsExecuting();
        }
        return retVal;
    }

    @Override
    public boolean isJobsExecuting() {
        this.cleanseEndedJobs();
        return !this.myJobExecutions.isEmpty();
    }

    private void cleanseEndedJobs() {
        ArrayList<String> idsToDelete = new ArrayList<String>();
        for (String jobId : BATCH_JOBS_TO_CARE_ABOUT) {
            List jobInstanceInEndedState = this.myJobCoordinator.getInstancesbyJobDefinitionIdAndEndedStatus(jobId, Boolean.valueOf(true), Math.max(this.myJobExecutions.size(), 1), 0);
            for (JobInstance instance : jobInstanceInEndedState) {
                idsToDelete.add(instance.getInstanceId());
            }
        }
        for (String id : idsToDelete) {
            this.myJobExecutions.remove(id);
        }
    }

    private void saveConceptLink(TermConceptParentChildLink next) {
        if (next.getId() == null) {
            this.myConceptParentChildLinkDao.save(next);
        }
    }

    private boolean isProcessDeferredPaused() {
        return !this.myProcessDeferred;
    }

    private boolean isDeferredConceptsOrConceptLinksToSaveLater() {
        return this.isDeferredConcepts() || this.isConceptLinksToSaveLater();
    }

    private boolean isDeferredCodeSystemDeletions() {
        return !this.myDeferredCodeSystemsDeletions.isEmpty() || !this.myDeferredCodeSystemVersionsDeletions.isEmpty();
    }

    private boolean isDeferredConcepts() {
        return !this.myDeferredConcepts.isEmpty();
    }

    private boolean isConceptLinksToSaveLater() {
        return !this.myConceptLinksToSaveLater.isEmpty();
    }

    private boolean isDeferredValueSets() {
        return !this.myDeferredValueSets.isEmpty();
    }

    private boolean isDeferredConceptMaps() {
        return !this.myDeferredConceptMaps.isEmpty();
    }

    @VisibleForTesting
    void setTransactionManagerForUnitTest(PlatformTransactionManager theTxManager) {
        this.myTransactionMgr = theTxManager;
    }

    @VisibleForTesting
    void setTermConceptDaoSvc(TermConceptDaoSvc theTermConceptDaoSvc) {
        this.myTermConceptDaoSvc = theTermConceptDaoSvc;
    }

    @VisibleForTesting
    void setConceptDaoForUnitTest(ITermConceptDao theConceptDao) {
        this.myConceptDao = theConceptDao;
    }

    @VisibleForTesting
    void setCodeSystemVersionDaoForUnitTest(ITermCodeSystemVersionDao theCodeSystemVersionDao) {
        this.myCodeSystemVersionDao = theCodeSystemVersionDao;
    }

    @Override
    public void disallowDeferredTaskTimeout() {
        this.myAllowDeferredTasksTimeout = false;
    }

    @Override
    @VisibleForTesting
    public void logQueueForUnitTest() {
        ourLog.info("isProcessDeferredPaused: {}", (Object)this.isProcessDeferredPaused());
        ourLog.info("isDeferredConcepts: {}", (Object)this.isDeferredConcepts());
        ourLog.info("isConceptLinksToSaveLater: {}", (Object)this.isConceptLinksToSaveLater());
        ourLog.info("isDeferredValueSets: {}", (Object)this.isDeferredValueSets());
        ourLog.info("isDeferredConceptMaps: {}", (Object)this.isDeferredConceptMaps());
        ourLog.info("isDeferredCodeSystemDeletions: {}", (Object)this.isDeferredCodeSystemDeletions());
    }

    @Override
    public void deleteCodeSystemVersion(TermCodeSystemVersion theCodeSystemVersion) {
        this.myDeferredCodeSystemVersionsDeletions.add(theCodeSystemVersion);
    }

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        ScheduledJobDefinition jobDefinition = new ScheduledJobDefinition();
        jobDefinition.setId(Job.class.getName());
        jobDefinition.setJobClass(Job.class);
        theSchedulerService.scheduleLocalJob(5000L, jobDefinition);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("myDeferredCodeSystemsDeletions", this.myDeferredCodeSystemsDeletions.size()).append("myDeferredCodeSystemVersionsDeletions", this.myDeferredCodeSystemVersionsDeletions.size()).append("myDeferredConcepts", this.myDeferredConcepts.size()).append("myDeferredValueSets", this.myDeferredValueSets.size()).append("myDeferredConceptMaps", this.myDeferredConceptMaps.size()).append("myConceptLinksToSaveLater", this.myConceptLinksToSaveLater.size()).append("myJobExecutions", this.myJobExecutions.size()).append("myProcessDeferred", this.myProcessDeferred).toString();
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private ITermDeferredStorageSvc myTerminologySvc;

        public void execute(JobExecutionContext theContext) {
            this.myTerminologySvc.saveDeferred();
        }
    }
}

