/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.term.IZipContentsHandler;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.LoadedFileDescriptors;
import ca.uhn.fhir.jpa.term.TermReadSvcImpl;
import ca.uhn.fhir.jpa.term.UploadStatistics;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermLoaderSvc;
import ca.uhn.fhir.jpa.term.custom.CustomTerminologySet;
import ca.uhn.fhir.jpa.term.icd10.Icd10Loader;
import ca.uhn.fhir.jpa.term.icd10cm.Icd10CmLoader;
import ca.uhn.fhir.jpa.term.loinc.LoincAnswerListHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincAnswerListLinkHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincCodingPropertiesHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincConsumerNameHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincDocumentOntologyHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincGroupFileHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincGroupTermsFileHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincHierarchyHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincIeeeMedicalDeviceCodeHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincImagingDocumentCodeHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincLinguisticVariantHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincLinguisticVariantsHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincMapToHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincParentGroupFileHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincPartHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincPartLinkHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincPartRelatedCodeMappingHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincRsnaPlaybookHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincTop2000LabResultsSiHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincTop2000LabResultsUsHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincUniversalOrderSetHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincUploadPropertiesEnum;
import ca.uhn.fhir.jpa.term.loinc.LoincXmlFileZipContentsHandler;
import ca.uhn.fhir.jpa.term.loinc.PartTypeAndPartName;
import ca.uhn.fhir.jpa.term.snomedct.SctHandlerConcept;
import ca.uhn.fhir.jpa.term.snomedct.SctHandlerDescription;
import ca.uhn.fhir.jpa.term.snomedct.SctHandlerRelationship;
import ca.uhn.fhir.jpa.util.Counter;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ValidateUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.SAXException;

public class TermLoaderSvcImpl
implements ITermLoaderSvc {
    public static final String CUSTOM_CONCEPTS_FILE = "concepts.csv";
    public static final String CUSTOM_HIERARCHY_FILE = "hierarchy.csv";
    public static final String CUSTOM_PROPERTIES_FILE = "properties.csv";
    static final String IMGTHLA_HLA_NOM_TXT = "hla_nom.txt";
    static final String IMGTHLA_HLA_XML = "hla.xml";
    static final String CUSTOM_CODESYSTEM_JSON = "codesystem.json";
    private static final String SCT_FILE_CONCEPT = "Terminology/sct2_Concept_Full_";
    private static final String SCT_FILE_DESCRIPTION = "Terminology/sct2_Description_Full";
    private static final String SCT_FILE_RELATIONSHIP = "Terminology/sct2_Relationship_Full";
    private static final String CUSTOM_CODESYSTEM_XML = "codesystem.xml";
    private static final int LOG_INCREMENT = 1000;
    private static final Logger ourLog = LoggerFactory.getLogger(TermLoaderSvcImpl.class);
    private final FhirContext myCtx = FhirContext.forR4Cached();
    private final ITermDeferredStorageSvc myDeferredStorageSvc;
    private final ITermCodeSystemStorageSvc myCodeSystemStorageSvc;

    @Autowired
    public TermLoaderSvcImpl(ITermDeferredStorageSvc theDeferredStorageSvc, ITermCodeSystemStorageSvc theCodeSystemStorageSvc) {
        this(theDeferredStorageSvc, theCodeSystemStorageSvc, true);
    }

    private TermLoaderSvcImpl(ITermDeferredStorageSvc theDeferredStorageSvc, ITermCodeSystemStorageSvc theCodeSystemStorageSvc, boolean theProxyCheck) {
        if (theProxyCheck) {
            Validate.isTrue((boolean)AopUtils.isAopProxy((Object)theDeferredStorageSvc), (String)(theDeferredStorageSvc.getClass().getName() + " is not a proxy.  @Transactional annotations will be ignored."), (Object[])new Object[0]);
            Validate.isTrue((boolean)AopUtils.isAopProxy((Object)theCodeSystemStorageSvc), (String)(theCodeSystemStorageSvc.getClass().getName() + " is not a proxy.  @Transactional annotations will be ignored."), (Object[])new Object[0]);
        }
        this.myDeferredStorageSvc = theDeferredStorageSvc;
        this.myCodeSystemStorageSvc = theCodeSystemStorageSvc;
    }

    @VisibleForTesting
    public static TermLoaderSvcImpl withoutProxyCheck(ITermDeferredStorageSvc theTermDeferredStorageSvc, ITermCodeSystemStorageSvc theTermCodeSystemStorageSvc) {
        return new TermLoaderSvcImpl(theTermDeferredStorageSvc, theTermCodeSystemStorageSvc, false);
    }

    public UploadStatistics loadImgthla(List<ITermLoaderSvc.FileDescriptor> theFiles, RequestDetails theRequestDetails) {
        try (LoadedFileDescriptors descriptors = this.getLoadedFileDescriptors(theFiles);){
            List<String> mandatoryFilenameFragments = Arrays.asList(IMGTHLA_HLA_NOM_TXT, IMGTHLA_HLA_XML);
            descriptors.verifyMandatoryFilesExist(mandatoryFilenameFragments);
            ourLog.info("Beginning IMGTHLA processing");
            UploadStatistics uploadStatistics = this.processImgthlaFiles(descriptors, theRequestDetails);
            return uploadStatistics;
        }
    }

    @VisibleForTesting
    LoadedFileDescriptors getLoadedFileDescriptors(List<ITermLoaderSvc.FileDescriptor> theFiles) {
        return new LoadedFileDescriptors(theFiles);
    }

    public UploadStatistics loadLoinc(List<ITermLoaderSvc.FileDescriptor> theFiles, RequestDetails theRequestDetails) {
        try (LoadedFileDescriptors descriptors = this.getLoadedFileDescriptors(theFiles);){
            Properties uploadProperties = this.getProperties(descriptors, LoincUploadPropertiesEnum.LOINC_UPLOAD_PROPERTIES_FILE.getCode());
            String codeSystemVersionId = uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
            boolean isMakeCurrentVersion = Boolean.parseBoolean(uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_MAKE_CURRENT.getCode(), "true"));
            if (StringUtils.isBlank((CharSequence)codeSystemVersionId) && !isMakeCurrentVersion) {
                throw new InvalidRequestException(Msg.code((int)864) + "'" + LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode() + "' property is required when '" + LoincUploadPropertiesEnum.LOINC_CODESYSTEM_MAKE_CURRENT.getCode() + "' property is 'false'");
            }
            List<String> mandatoryFilenameFragments = Arrays.asList(uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_ANSWERLIST_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_ANSWERLIST_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_ANSWERLIST_LINK_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_ANSWERLIST_LINK_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_DOCUMENT_ONTOLOGY_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_DOCUMENT_ONTOLOGY_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_HIERARCHY_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_HIERARCHY_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_IEEE_MEDICAL_DEVICE_CODE_MAPPING_TABLE_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_IEEE_MEDICAL_DEVICE_CODE_MAPPING_TABLE_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_IMAGING_DOCUMENT_CODES_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_IMAGING_DOCUMENT_CODES_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PART_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_PART_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PART_RELATED_CODE_MAPPING_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_PART_RELATED_CODE_MAPPING_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_RSNA_PLAYBOOK_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_RSNA_PLAYBOOK_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_UNIVERSAL_LAB_ORDER_VALUESET_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_UNIVERSAL_LAB_ORDER_VALUESET_FILE_DEFAULT.getCode()));
            descriptors.verifyMandatoryFilesExist(mandatoryFilenameFragments);
            List<String> splitPartLinkFilenameFragments = Arrays.asList(uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE_PRIMARY.getCode(), LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE_PRIMARY_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE_SUPPLEMENTARY.getCode(), LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE_SUPPLEMENTARY_DEFAULT.getCode()));
            descriptors.verifyPartLinkFilesExist(splitPartLinkFilenameFragments, uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE_DEFAULT.getCode()));
            List<String> optionalFilenameFragments = Arrays.asList(uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_GROUP_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_GROUP_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_GROUP_TERMS_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_GROUP_TERMS_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PARENT_GROUP_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_PARENT_GROUP_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_TOP2000_COMMON_LAB_RESULTS_SI_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_TOP2000_COMMON_LAB_RESULTS_SI_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_TOP2000_COMMON_LAB_RESULTS_US_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_TOP2000_COMMON_LAB_RESULTS_US_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_MAPTO_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_MAPTO_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CONSUMER_NAME_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_CONSUMER_NAME_FILE_DEFAULT.getCode()), uploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_LINGUISTIC_VARIANTS_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_LINGUISTIC_VARIANTS_FILE_DEFAULT.getCode()));
            descriptors.verifyOptionalFilesExist(optionalFilenameFragments);
            ourLog.info("Beginning LOINC processing");
            if (isMakeCurrentVersion) {
                if (codeSystemVersionId != null) {
                    this.processLoincFiles(descriptors, theRequestDetails, uploadProperties, false);
                    uploadProperties.remove(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
                }
                ourLog.info("Uploading CodeSystem and making it current version");
            } else {
                ourLog.info("Uploading CodeSystem without updating current version");
            }
            theRequestDetails.getUserData().put("make.loading.version.current", isMakeCurrentVersion);
            UploadStatistics uploadStatistics = this.processLoincFiles(descriptors, theRequestDetails, uploadProperties, true);
            return uploadStatistics;
        }
    }

    public UploadStatistics loadSnomedCt(List<ITermLoaderSvc.FileDescriptor> theFiles, RequestDetails theRequestDetails) {
        try (LoadedFileDescriptors descriptors = this.getLoadedFileDescriptors(theFiles);){
            List<String> expectedFilenameFragments = Arrays.asList(SCT_FILE_DESCRIPTION, SCT_FILE_RELATIONSHIP, SCT_FILE_CONCEPT);
            descriptors.verifyMandatoryFilesExist(expectedFilenameFragments);
            ourLog.info("Beginning SNOMED CT processing");
            UploadStatistics uploadStatistics = this.processSnomedCtFiles(descriptors, theRequestDetails);
            return uploadStatistics;
        }
    }

    public UploadStatistics loadIcd10(List<ITermLoaderSvc.FileDescriptor> theFiles, RequestDetails theRequestDetails) {
        ourLog.info("Beginning ICD-10 processing");
        CodeSystem codeSystem = new CodeSystem();
        codeSystem.setUrl("http://hl7.org/fhir/sid/icd-10");
        codeSystem.setContent(CodeSystem.CodeSystemContentMode.NOTPRESENT);
        codeSystem.setStatus(Enumerations.PublicationStatus.ACTIVE);
        TermCodeSystemVersion codeSystemVersion = new TermCodeSystemVersion();
        int count = 0;
        try (LoadedFileDescriptors compressedDescriptors = this.getLoadedFileDescriptors(theFiles);){
            for (ITermLoaderSvc.FileDescriptor nextDescriptor : compressedDescriptors.getUncompressedFileDescriptors()) {
                if (!nextDescriptor.getFilename().toLowerCase(Locale.US).endsWith(".xml")) continue;
                InputStream inputStream = nextDescriptor.getInputStream();
                try (InputStreamReader reader = new InputStreamReader(inputStream, Charsets.UTF_8);){
                    Icd10Loader loader = new Icd10Loader(codeSystem, codeSystemVersion);
                    loader.load(reader);
                    count += loader.getConceptCount();
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (IOException | SAXException e) {
            throw new InternalErrorException(Msg.code((int)2135) + e);
        }
        codeSystem.setVersion(codeSystemVersion.getCodeSystemVersionId());
        IIdType target = this.storeCodeSystem(theRequestDetails, codeSystemVersion, codeSystem, null, null);
        return new UploadStatistics(count, target);
    }

    public UploadStatistics loadIcd10cm(List<ITermLoaderSvc.FileDescriptor> theFiles, RequestDetails theRequestDetails) {
        ourLog.info("Beginning ICD-10-cm processing");
        CodeSystem cs = new CodeSystem();
        cs.setUrl("http://hl7.org/fhir/sid/icd-10-cm");
        cs.setName("ICD-10-CM");
        cs.setContent(CodeSystem.CodeSystemContentMode.NOTPRESENT);
        cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        TermCodeSystemVersion codeSystemVersion = new TermCodeSystemVersion();
        int count = 0;
        try (LoadedFileDescriptors compressedDescriptors = this.getLoadedFileDescriptors(theFiles);){
            for (ITermLoaderSvc.FileDescriptor nextDescriptor : compressedDescriptors.getUncompressedFileDescriptors()) {
                if (!nextDescriptor.getFilename().toLowerCase(Locale.US).endsWith(".xml")) continue;
                InputStream inputStream = nextDescriptor.getInputStream();
                try (InputStreamReader reader = new InputStreamReader(inputStream, Charsets.UTF_8);){
                    Icd10CmLoader loader = new Icd10CmLoader(codeSystemVersion);
                    loader.load(reader);
                    count += loader.getConceptCount();
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (IOException | SAXException e) {
            throw new InternalErrorException(Msg.code((int)865) + e);
        }
        cs.setVersion(codeSystemVersion.getCodeSystemVersionId());
        IIdType target = this.storeCodeSystem(theRequestDetails, codeSystemVersion, cs, null, null);
        return new UploadStatistics(count, target);
    }

    public UploadStatistics loadCustom(String theSystem, List<ITermLoaderSvc.FileDescriptor> theFiles, RequestDetails theRequestDetails) {
        try (LoadedFileDescriptors descriptors = this.getLoadedFileDescriptors(theFiles);){
            CodeSystem codeSystem;
            Optional<String> codeSystemContent = this.loadFile(descriptors, CUSTOM_CODESYSTEM_JSON, CUSTOM_CODESYSTEM_XML);
            if (codeSystemContent.isPresent()) {
                codeSystem = (CodeSystem)EncodingEnum.detectEncoding((String)codeSystemContent.get()).newParser(this.myCtx).parseResource(CodeSystem.class, codeSystemContent.get());
                ValidateUtil.isTrueOrThrowInvalidRequest((boolean)theSystem.equalsIgnoreCase(codeSystem.getUrl()), (String)"CodeSystem.url does not match the supplied system: %s", (Object[])new Object[]{theSystem});
                ValidateUtil.isTrueOrThrowInvalidRequest((boolean)CodeSystem.CodeSystemContentMode.NOTPRESENT.equals((Object)codeSystem.getContent()), (String)"CodeSystem.content does not match the expected value: %s", (Object[])new Object[]{CodeSystem.CodeSystemContentMode.NOTPRESENT.toCode()});
            } else {
                codeSystem = new CodeSystem();
                codeSystem.setUrl(theSystem);
                codeSystem.setContent(CodeSystem.CodeSystemContentMode.NOTPRESENT);
            }
            CustomTerminologySet terminologySet = CustomTerminologySet.load(descriptors, false);
            TermCodeSystemVersion csv = terminologySet.toCodeSystemVersion();
            IIdType target = this.storeCodeSystem(theRequestDetails, csv, codeSystem, null, null);
            UploadStatistics uploadStatistics = new UploadStatistics(terminologySet.getSize(), target);
            return uploadStatistics;
        }
    }

    public UploadStatistics loadDeltaAdd(String theSystem, List<ITermLoaderSvc.FileDescriptor> theFiles, RequestDetails theRequestDetails) {
        ourLog.info("Processing terminology delta ADD for system[{}] with files: {}", (Object)theSystem, theFiles.stream().map(ITermLoaderSvc.FileDescriptor::getFilename).collect(Collectors.toList()));
        try (LoadedFileDescriptors descriptors = this.getLoadedFileDescriptors(theFiles);){
            CustomTerminologySet terminologySet = CustomTerminologySet.load(descriptors, false);
            UploadStatistics uploadStatistics = this.myCodeSystemStorageSvc.applyDeltaCodeSystemsAdd(theSystem, terminologySet);
            return uploadStatistics;
        }
    }

    public UploadStatistics loadDeltaRemove(String theSystem, List<ITermLoaderSvc.FileDescriptor> theFiles, RequestDetails theRequestDetails) {
        ourLog.info("Processing terminology delta REMOVE for system[{}] with files: {}", (Object)theSystem, theFiles.stream().map(ITermLoaderSvc.FileDescriptor::getFilename).collect(Collectors.toList()));
        try (LoadedFileDescriptors descriptors = this.getLoadedFileDescriptors(theFiles);){
            CustomTerminologySet terminologySet = CustomTerminologySet.load(descriptors, true);
            UploadStatistics uploadStatistics = this.myCodeSystemStorageSvc.applyDeltaCodeSystemsRemove(theSystem, terminologySet);
            return uploadStatistics;
        }
    }

    private void dropCircularRefs(TermConcept theConcept, ArrayList<String> theChain, Map<String, TermConcept> theCode2concept) {
        theChain.add(theConcept.getCode());
        Iterator<TermConceptParentChildLink> childIter = theConcept.getChildren().iterator();
        while (childIter.hasNext()) {
            TermConceptParentChildLink next = childIter.next();
            TermConcept nextChild = next.getChild();
            if (theChain.contains(nextChild.getCode())) {
                StringBuilder b = new StringBuilder();
                b.append("Removing circular reference code ");
                b.append(nextChild.getCode());
                b.append(" from parent ");
                b.append(next.getParent().getCode());
                b.append(". Chain was: ");
                for (String nextInChain : theChain) {
                    TermConcept nextCode = theCode2concept.get(nextInChain);
                    b.append(nextCode.getCode());
                    b.append('[');
                    b.append(StringUtils.substring((String)nextCode.getDisplay(), (int)0, (int)20).replace("[", "").replace("]", "").trim());
                    b.append("] ");
                }
                ourLog.info(b.toString(), (Object)theConcept.getCode());
                childIter.remove();
                nextChild.getParents().remove(next);
                continue;
            }
            this.dropCircularRefs(nextChild, theChain, theCode2concept);
        }
        theChain.remove(theChain.size() - 1);
    }

    @Nonnull
    @VisibleForTesting
    Properties getProperties(LoadedFileDescriptors theDescriptors, String thePropertiesFile) {
        Properties retVal = new Properties();
        try (InputStream propertyStream = TermLoaderSvcImpl.class.getResourceAsStream("/ca/uhn/fhir/jpa/term/loinc/loincupload.properties");){
            retVal.load(propertyStream);
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code((int)866) + "Failed to process loinc.properties", (Throwable)e);
        }
        for (ITermLoaderSvc.FileDescriptor next : theDescriptors.getUncompressedFileDescriptors()) {
            if (!next.getFilename().endsWith(thePropertiesFile)) continue;
            try {
                InputStream inputStream = next.getInputStream();
                try {
                    retVal.load(inputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new InternalErrorException(Msg.code((int)867) + "Failed to read " + thePropertiesFile, (Throwable)e);
            }
        }
        return retVal;
    }

    private Optional<String> loadFile(LoadedFileDescriptors theDescriptors, String ... theFilenames) {
        for (ITermLoaderSvc.FileDescriptor next : theDescriptors.getUncompressedFileDescriptors()) {
            for (String nextFilename : theFilenames) {
                if (!next.getFilename().endsWith(nextFilename)) continue;
                try {
                    String contents = IOUtils.toString((InputStream)next.getInputStream(), (Charset)Charsets.UTF_8);
                    return Optional.of(contents);
                }
                catch (IOException e) {
                    throw new InternalErrorException(Msg.code((int)868) + e);
                }
            }
        }
        return Optional.empty();
    }

    private UploadStatistics processImgthlaFiles(LoadedFileDescriptors theDescriptors, RequestDetails theRequestDetails) {
        TermCodeSystemVersion codeSystemVersion = new TermCodeSystemVersion();
        ArrayList valueSets = new ArrayList();
        ArrayList conceptMaps = new ArrayList();
        try {
            String imgthlaCsString = IOUtils.toString((InputStream)TermReadSvcImpl.class.getResourceAsStream("/ca/uhn/fhir/jpa/term/imgthla/imgthla.xml"), (Charset)Charsets.UTF_8);
            CodeSystem imgthlaCs = (CodeSystem)FhirContext.forR4Cached().newXmlParser().parseResource(CodeSystem.class, imgthlaCsString);
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code((int)869) + "Failed to load imgthla.xml", (Throwable)e);
        }
        boolean foundHlaNom = false;
        boolean foundHlaXml = false;
        for (ITermLoaderSvc.FileDescriptor nextZipBytes : theDescriptors.getUncompressedFileDescriptors()) {
            LineNumberReader lnr;
            InputStreamReader reader;
            String nextFilename;
            block18: {
                nextFilename = nextZipBytes.getFilename();
                if (!(IMGTHLA_HLA_NOM_TXT.equals(nextFilename) || nextFilename.endsWith("/hla_nom.txt") || IMGTHLA_HLA_XML.equals(nextFilename) || nextFilename.endsWith("/hla.xml"))) {
                    ourLog.info("Skipping unexpected file {}", (Object)nextFilename);
                    continue;
                }
                if (!IMGTHLA_HLA_NOM_TXT.equals(nextFilename) && !nextFilename.endsWith("/hla_nom.txt")) break block18;
                ourLog.info("Processing file {}", (Object)nextFilename);
                reader = null;
                try {
                    reader = new InputStreamReader(nextZipBytes.getInputStream(), Charsets.UTF_8);
                    lnr = new LineNumberReader(reader);
                    while (lnr.readLine() != null) {
                    }
                    ourLog.warn("Lines read from {}:  {}", (Object)nextFilename, (Object)lnr.getLineNumber());
                }
                catch (IOException e) {
                    try {
                        throw new InternalErrorException(Msg.code((int)870) + e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
                foundHlaNom = true;
            }
            if (!IMGTHLA_HLA_XML.equals(nextFilename) && !nextFilename.endsWith("/hla.xml")) continue;
            ourLog.info("Processing file {}", (Object)nextFilename);
            reader = null;
            try {
                reader = new InputStreamReader(nextZipBytes.getInputStream(), Charsets.UTF_8);
                lnr = new LineNumberReader(reader);
                while (lnr.readLine() != null) {
                }
                ourLog.warn("Lines read from {}:  {}", (Object)nextFilename, (Object)lnr.getLineNumber());
            }
            catch (IOException e) {
                throw new InternalErrorException(Msg.code((int)871) + e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            foundHlaXml = true;
        }
        if (!foundHlaNom) {
            throw new InvalidRequestException(Msg.code((int)872) + "Did not find file matching hla_nom.txt");
        }
        if (!foundHlaXml) {
            throw new InvalidRequestException(Msg.code((int)873) + "Did not find file matching hla.xml");
        }
        int valueSetCount = valueSets.size();
        int rootConceptCount = codeSystemVersion.getConcepts().size();
        ourLog.info("Have {} total concepts, {} root concepts, {} ValueSets", new Object[]{rootConceptCount, rootConceptCount, valueSetCount});
        throw new InternalErrorException(Msg.code((int)874) + "HLA nomenclature terminology upload not yet fully implemented.");
    }

    UploadStatistics processLoincFiles(LoadedFileDescriptors theDescriptors, RequestDetails theRequestDetails, Properties theUploadProperties, Boolean theCloseFiles) {
        TermCodeSystemVersion codeSystemVersion = new TermCodeSystemVersion();
        HashMap<String, TermConcept> code2concept = new HashMap<String, TermConcept>();
        ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
        ArrayList<ConceptMap> conceptMaps = new ArrayList<ConceptMap>();
        ArrayList<LoincLinguisticVariantsHandler.LinguisticVariant> linguisticVariants = new ArrayList<LoincLinguisticVariantsHandler.LinguisticVariant>();
        LoincXmlFileZipContentsHandler loincXmlHandler = this.getLoincXmlFileZipContentsHandler();
        TermLoaderSvcImpl.iterateOverZipFile(theDescriptors, "loinc.xml", false, false, loincXmlHandler);
        String loincCsString = loincXmlHandler.getContents();
        if (StringUtils.isBlank((CharSequence)loincCsString)) {
            throw new InvalidRequestException(Msg.code((int)875) + "Did not find loinc.xml in the ZIP distribution.");
        }
        CodeSystem loincCs = (CodeSystem)FhirContext.forR4Cached().newXmlParser().parseResource(CodeSystem.class, loincCsString);
        if (StringUtils.isNotBlank((CharSequence)loincCs.getVersion())) {
            throw new InvalidRequestException(Msg.code((int)876) + "'loinc.xml' file must not have a version defined. To define a version use '" + LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode() + "' property of 'loincupload.properties' file");
        }
        String codeSystemVersionId = theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
        if (codeSystemVersionId != null) {
            loincCs.setVersion(codeSystemVersionId);
            loincCs.setId(loincCs.getId() + "-" + codeSystemVersionId);
        }
        HashMap<String, CodeSystem.PropertyType> propertyNamesToTypes = new HashMap<String, CodeSystem.PropertyType>();
        for (CodeSystem.PropertyComponent nextProperty : loincCs.getProperty()) {
            String nextPropertyCode = nextProperty.getCode();
            CodeSystem.PropertyType nextPropertyType = nextProperty.getType();
            if (!StringUtils.isNotBlank((CharSequence)nextPropertyCode)) continue;
            propertyNamesToTypes.put(nextPropertyCode, nextPropertyType);
        }
        if (!propertyNamesToTypes.containsKey("EXTERNAL_COPYRIGHT_NOTICE")) {
            String externalCopyRightNoticeCode = "EXTERNAL_COPYRIGHT_NOTICE";
            CodeSystem.PropertyType externalCopyRightNoticeType = CodeSystem.PropertyType.STRING;
            propertyNamesToTypes.put(externalCopyRightNoticeCode, externalCopyRightNoticeType);
        }
        IZipContentsHandlerCsv handler = new LoincPartHandler(codeSystemVersion, code2concept);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PART_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_PART_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        Map<PartTypeAndPartName, String> partTypeAndPartNameToPartNumber = handler.getPartTypeAndPartNameToPartNumber();
        handler = new LoincHandler(codeSystemVersion, code2concept, propertyNamesToTypes, partTypeAndPartNameToPartNumber);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincHierarchyHandler(codeSystemVersion, code2concept);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_HIERARCHY_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_HIERARCHY_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincAnswerListHandler(codeSystemVersion, code2concept, valueSets, conceptMaps, theUploadProperties, loincCs.getCopyright());
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_ANSWERLIST_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_ANSWERLIST_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincAnswerListLinkHandler(code2concept);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_ANSWERLIST_LINK_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_ANSWERLIST_LINK_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincRsnaPlaybookHandler(code2concept, valueSets, conceptMaps, theUploadProperties, loincCs.getCopyright());
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_RSNA_PLAYBOOK_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_RSNA_PLAYBOOK_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincPartRelatedCodeMappingHandler(code2concept, valueSets, conceptMaps, theUploadProperties, loincCs.getCopyright());
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PART_RELATED_CODE_MAPPING_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_PART_RELATED_CODE_MAPPING_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincDocumentOntologyHandler(code2concept, propertyNamesToTypes, valueSets, conceptMaps, theUploadProperties, loincCs.getCopyright());
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_DOCUMENT_ONTOLOGY_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_DOCUMENT_ONTOLOGY_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincTop2000LabResultsUsHandler(code2concept, valueSets, conceptMaps, theUploadProperties, loincCs.getCopyright());
        TermLoaderSvcImpl.iterateOverZipFileCsvOptional(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_TOP2000_COMMON_LAB_RESULTS_US_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_TOP2000_COMMON_LAB_RESULTS_US_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincTop2000LabResultsSiHandler(code2concept, valueSets, conceptMaps, theUploadProperties, loincCs.getCopyright());
        TermLoaderSvcImpl.iterateOverZipFileCsvOptional(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_TOP2000_COMMON_LAB_RESULTS_SI_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_TOP2000_COMMON_LAB_RESULTS_SI_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincUniversalOrderSetHandler(code2concept, valueSets, conceptMaps, theUploadProperties);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_UNIVERSAL_LAB_ORDER_VALUESET_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_UNIVERSAL_LAB_ORDER_VALUESET_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincIeeeMedicalDeviceCodeHandler(code2concept, valueSets, conceptMaps, theUploadProperties, loincCs.getCopyright());
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_IEEE_MEDICAL_DEVICE_CODE_MAPPING_TABLE_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_IEEE_MEDICAL_DEVICE_CODE_MAPPING_TABLE_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincImagingDocumentCodeHandler(code2concept, valueSets, conceptMaps, theUploadProperties);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_IMAGING_DOCUMENT_CODES_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_IMAGING_DOCUMENT_CODES_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincGroupFileHandler(code2concept, valueSets, conceptMaps, theUploadProperties, loincCs.getCopyright());
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_GROUP_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_GROUP_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincGroupTermsFileHandler(code2concept, valueSets, conceptMaps, theUploadProperties);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_GROUP_TERMS_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_GROUP_TERMS_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincParentGroupFileHandler(code2concept, valueSets, conceptMaps, theUploadProperties);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PARENT_GROUP_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_PARENT_GROUP_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincPartLinkHandler(codeSystemVersion, code2concept, propertyNamesToTypes);
        TermLoaderSvcImpl.iterateOverZipFileCsvOptional(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        TermLoaderSvcImpl.iterateOverZipFileCsvOptional(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE_PRIMARY.getCode(), LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE_PRIMARY_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        TermLoaderSvcImpl.iterateOverZipFileCsvOptional(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE_SUPPLEMENTARY.getCode(), LoincUploadPropertiesEnum.LOINC_PART_LINK_FILE_SUPPLEMENTARY_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincConsumerNameHandler(code2concept);
        TermLoaderSvcImpl.iterateOverZipFileCsvOptional(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CONSUMER_NAME_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_CONSUMER_NAME_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincCodingPropertiesHandler(code2concept, propertyNamesToTypes);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        handler = new LoincLinguisticVariantsHandler(linguisticVariants);
        TermLoaderSvcImpl.iterateOverZipFileCsvOptional(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_LINGUISTIC_VARIANTS_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_LINGUISTIC_VARIANTS_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        for (LoincLinguisticVariantsHandler.LinguisticVariant linguisticVariant : linguisticVariants) {
            handler = new LoincLinguisticVariantHandler(code2concept, linguisticVariant.getLanguageCode());
            String langFileName = linguisticVariant.getLinguisticVariantFileName();
            TermLoaderSvcImpl.iterateOverZipFileCsvOptional(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_LINGUISTIC_VARIANTS_PATH.getCode() + langFileName, LoincUploadPropertiesEnum.LOINC_LINGUISTIC_VARIANTS_PATH_DEFAULT.getCode() + langFileName), handler, ',', QuoteMode.NON_NUMERIC, false);
        }
        if (theDescriptors.isOptionalFilesExist(List.of(theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_MAPTO_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_MAPTO_FILE_DEFAULT.getCode())))) {
            handler = new LoincMapToHandler(code2concept);
            TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_MAPTO_FILE.getCode(), LoincUploadPropertiesEnum.LOINC_MAPTO_FILE_DEFAULT.getCode()), handler, ',', QuoteMode.NON_NUMERIC, false);
        }
        if (theCloseFiles.booleanValue()) {
            IOUtils.closeQuietly((Closeable)theDescriptors);
        }
        valueSets.add(this.getValueSetLoincAll(theUploadProperties, loincCs.getCopyright()));
        for (Map.Entry entry : code2concept.entrySet()) {
            TermConcept nextConcept = (TermConcept)entry.getValue();
            if (!nextConcept.getParents().isEmpty()) continue;
            codeSystemVersion.getConcepts().add(nextConcept);
        }
        int valueSetCount = valueSets.size();
        int n = codeSystemVersion.getConcepts().size();
        int conceptCount = code2concept.size();
        ourLog.info("Have {} total concepts, {} root concepts, {} ValueSets", new Object[]{conceptCount, n, valueSetCount});
        IIdType target = this.storeCodeSystem(theRequestDetails, codeSystemVersion, loincCs, valueSets, conceptMaps);
        return new UploadStatistics(conceptCount, target);
    }

    @VisibleForTesting
    protected LoincXmlFileZipContentsHandler getLoincXmlFileZipContentsHandler() {
        return new LoincXmlFileZipContentsHandler();
    }

    private ValueSet getValueSetLoincAll(Properties theUploadProperties, String theCopyrightStatement) {
        ValueSet retVal = new ValueSet();
        String codeSystemVersionId = theUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
        Object valueSetId = codeSystemVersionId != null ? "loinc-all-" + codeSystemVersionId : "loinc-all";
        retVal.setId((String)valueSetId);
        retVal.setUrl("http://loinc.org/vs");
        retVal.setVersion(codeSystemVersionId);
        retVal.setName("All LOINC codes");
        retVal.setStatus(Enumerations.PublicationStatus.ACTIVE);
        retVal.setDate(new Date());
        retVal.setPublisher("Regenstrief Institute, Inc.");
        retVal.setDescription("A value set that includes all LOINC codes");
        retVal.setCopyright(theCopyrightStatement);
        retVal.getCompose().addInclude().setSystem("http://loinc.org").setVersion(codeSystemVersionId);
        return retVal;
    }

    private UploadStatistics processSnomedCtFiles(LoadedFileDescriptors theDescriptors, RequestDetails theRequestDetails) {
        TermCodeSystemVersion codeSystemVersion = new TermCodeSystemVersion();
        HashMap<String, TermConcept> id2concept = new HashMap<String, TermConcept>();
        HashMap<String, TermConcept> code2concept = new HashMap<String, TermConcept>();
        HashSet<String> validConceptIds = new HashSet<String>();
        IZipContentsHandlerCsv handler = new SctHandlerConcept(validConceptIds);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, SCT_FILE_CONCEPT, handler, '\t', null, true);
        ourLog.info("Have {} valid concept IDs", (Object)validConceptIds.size());
        handler = new SctHandlerDescription(validConceptIds, code2concept, id2concept, codeSystemVersion);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, SCT_FILE_DESCRIPTION, handler, '\t', null, true);
        ourLog.info("Got {} concepts, cloning map", (Object)code2concept.size());
        HashMap<String, TermConcept> rootConcepts = new HashMap<String, TermConcept>(code2concept);
        handler = new SctHandlerRelationship(codeSystemVersion, rootConcepts, code2concept);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, SCT_FILE_RELATIONSHIP, handler, '\t', null, true);
        IOUtils.closeQuietly((Closeable)theDescriptors);
        ourLog.info("Looking for root codes");
        rootConcepts.entrySet().removeIf(theStringTermConceptEntry -> !((TermConcept)theStringTermConceptEntry.getValue()).getParents().isEmpty());
        ourLog.info("Done loading SNOMED CT files - {} root codes, {} total codes", (Object)rootConcepts.size(), (Object)code2concept.size());
        Counter circularCounter = new Counter();
        for (TermConcept next : rootConcepts.values()) {
            long count = circularCounter.getThenAdd();
            float pct = (float)count / (float)rootConcepts.size() * 100.0f;
            ourLog.info(" * Scanning for circular refs - have scanned {} / {} codes ({}%)", new Object[]{count, rootConcepts.size(), Float.valueOf(pct)});
            this.dropCircularRefs(next, new ArrayList<String>(), code2concept);
        }
        codeSystemVersion.getConcepts().addAll(rootConcepts.values());
        CodeSystem cs = new CodeSystem();
        cs.setUrl("http://snomed.info/sct");
        cs.setName("SNOMED CT");
        cs.setContent(CodeSystem.CodeSystemContentMode.NOTPRESENT);
        cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        IIdType target = this.storeCodeSystem(theRequestDetails, codeSystemVersion, cs, null, null);
        return new UploadStatistics(code2concept.size(), target);
    }

    private IIdType storeCodeSystem(RequestDetails theRequestDetails, TermCodeSystemVersion theCodeSystemVersion, CodeSystem theCodeSystem, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps) {
        Validate.isTrue((theCodeSystem.getContent() == CodeSystem.CodeSystemContentMode.NOTPRESENT ? 1 : 0) != 0);
        List valueSets = (List)ObjectUtils.defaultIfNull(theValueSets, Collections.emptyList());
        List conceptMaps = (List)ObjectUtils.defaultIfNull(theConceptMaps, Collections.emptyList());
        this.myDeferredStorageSvc.setProcessDeferred(false);
        IIdType retVal = this.myCodeSystemStorageSvc.storeNewCodeSystemVersion(theCodeSystem, theCodeSystemVersion, theRequestDetails, valueSets, conceptMaps);
        this.myDeferredStorageSvc.setProcessDeferred(true);
        return retVal;
    }

    public static void iterateOverZipFileCsv(LoadedFileDescriptors theDescriptors, String theFileNamePart, IZipContentsHandlerCsv theHandler, char theDelimiter, QuoteMode theQuoteMode, boolean theIsPartialFilename) {
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theFileNamePart, theHandler, theDelimiter, theQuoteMode, theIsPartialFilename, true);
    }

    public static void iterateOverZipFileCsvOptional(LoadedFileDescriptors theDescriptors, String theFileNamePart, IZipContentsHandlerCsv theHandler, char theDelimiter, QuoteMode theQuoteMode, boolean theIsPartialFilename) {
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, theFileNamePart, theHandler, theDelimiter, theQuoteMode, theIsPartialFilename, false);
    }

    private static void iterateOverZipFileCsv(LoadedFileDescriptors theDescriptors, String theFileNamePart, IZipContentsHandlerCsv theHandler, char theDelimiter, QuoteMode theQuoteMode, boolean theIsPartialFilename, boolean theRequireMatch) {
        IZipContentsHandler handler = (reader, filename) -> {
            CSVParser parsed = TermLoaderSvcImpl.newCsvRecords(theDelimiter, theQuoteMode, reader);
            Iterator iter = parsed.iterator();
            ourLog.debug("Header map: {}", (Object)parsed.getHeaderMap());
            int count = 0;
            int nextLoggedCount = 0;
            while (iter.hasNext()) {
                CSVRecord nextRecord = (CSVRecord)iter.next();
                if (!nextRecord.isConsistent()) continue;
                theHandler.accept(nextRecord);
                if (++count < nextLoggedCount) continue;
                ourLog.info(" * Processed {} records in {}", (Object)count, (Object)filename);
                nextLoggedCount += 1000;
            }
        };
        TermLoaderSvcImpl.iterateOverZipFile(theDescriptors, theFileNamePart, theIsPartialFilename, theRequireMatch, handler);
    }

    private static void iterateOverZipFile(LoadedFileDescriptors theDescriptors, String theFileNamePart, boolean theIsPartialFilename, boolean theRequireMatch, IZipContentsHandler theHandler) {
        boolean foundMatch = false;
        for (ITermLoaderSvc.FileDescriptor nextZipBytes : theDescriptors.getUncompressedFileDescriptors()) {
            boolean matches;
            String nextFilename = nextZipBytes.getFilename();
            if (theIsPartialFilename) {
                matches = nextFilename.contains(theFileNamePart);
            } else {
                boolean bl = matches = nextFilename.endsWith("/" + theFileNamePart) || nextFilename.equals(theFileNamePart);
            }
            if (!matches) continue;
            ourLog.info("Processing file {}", (Object)nextFilename);
            foundMatch = true;
            try {
                InputStreamReader reader = new InputStreamReader(nextZipBytes.getInputStream(), Charsets.UTF_8);
                theHandler.handle(reader, nextFilename);
            }
            catch (IOException e) {
                throw new InternalErrorException(Msg.code((int)877) + e);
            }
        }
        if (!foundMatch && theRequireMatch) {
            throw new InvalidRequestException(Msg.code((int)878) + "Did not find file matching " + theFileNamePart);
        }
    }

    @Nonnull
    private static CSVParser newCsvRecords(char theDelimiter, QuoteMode theQuoteMode, Reader theReader) throws IOException {
        CSVFormat format = CSVFormat.newFormat((char)theDelimiter).withFirstRecordAsHeader().withTrim();
        if (theQuoteMode != null) {
            format = format.withQuote('\"').withQuoteMode(theQuoteMode);
        }
        CSVParser parsed = new CSVParser(theReader, format);
        return parsed;
    }

    public static String firstNonBlank(String ... theStrings) {
        String retVal = "";
        for (String nextString : theStrings) {
            if (!StringUtils.isNotBlank((CharSequence)nextString)) continue;
            retVal = nextString;
            break;
        }
        return retVal;
    }

    public static TermConcept getOrCreateConcept(Map<String, TermConcept> id2concept, String id) {
        TermConcept concept = id2concept.get(id);
        if (concept == null) {
            concept = new TermConcept();
            id2concept.put(id, concept);
        }
        return concept;
    }

    public static TermConceptProperty getOrCreateConceptProperty(Map<String, List<TermConceptProperty>> code2Properties, String code, String key) {
        List<TermConceptProperty> termConceptProperties = code2Properties.get(code);
        if (termConceptProperties == null) {
            return new TermConceptProperty();
        }
        Optional<TermConceptProperty> termConceptProperty = termConceptProperties.stream().filter(property -> key.equals(property.getKey())).findFirst();
        return termConceptProperty.orElseGet(TermConceptProperty::new);
    }
}

