/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.custom;

import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.entity.TermConceptPropertyTypeEnum;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import ca.uhn.fhir.util.ValidateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;

public class PropertyHandler
implements IZipContentsHandlerCsv {
    public static final String CODE = "CODE";
    public static final String KEY = "KEY";
    public static final String VALUE = "VALUE";
    public static final String TYPE = "TYPE";
    private final Map<String, List<TermConceptProperty>> myCode2Properties;

    public PropertyHandler(Map<String, List<TermConceptProperty>> theCode2concept) {
        this.myCode2Properties = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String code = StringUtils.trim((String)theRecord.get(CODE));
        String key = StringUtils.trim((String)theRecord.get(KEY));
        if (StringUtils.isNotBlank((CharSequence)code) && StringUtils.isNotBlank((CharSequence)KEY)) {
            String value = StringUtils.trim((String)theRecord.get(VALUE));
            String type = StringUtils.trim((String)theRecord.get(TYPE));
            List<TermConceptProperty> conceptProperties = this.myCode2Properties.get(code);
            if (conceptProperties == null) {
                conceptProperties = new ArrayList<TermConceptProperty>();
            }
            TermConceptProperty conceptProperty = TermLoaderSvcImpl.getOrCreateConceptProperty(this.myCode2Properties, code, key);
            ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)conceptProperty, (String)"Concept property %s not found in file", (Object[])new Object[]{conceptProperty});
            conceptProperty.setKey(key);
            conceptProperty.setValue(value);
            conceptProperty.setType(TermConceptPropertyTypeEnum.STRING);
            conceptProperties.add(conceptProperty);
            this.myCode2Properties.put(code, conceptProperties);
        }
    }
}

