/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.icd10;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.util.XmlUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Optional;
import org.hl7.fhir.r4.model.CodeSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Icd10Loader {
    public static final String EXPECTED_ROOT_NODE = "ClaML";
    private final CodeSystem codeSystem;
    private final TermCodeSystemVersion codeSystemVersion;
    private int conceptCount = 0;

    public Icd10Loader(CodeSystem codeSystem, TermCodeSystemVersion codeSystemVersion) {
        this.codeSystem = codeSystem;
        this.codeSystemVersion = codeSystemVersion;
    }

    public void load(Reader reader) throws IOException, SAXException {
        Document document = XmlUtil.parseDocument((Reader)reader, (boolean)false, (boolean)true);
        Element documentElement = document.getDocumentElement();
        String rootNodeName = documentElement.getTagName();
        if (!EXPECTED_ROOT_NODE.equals(rootNodeName)) {
            return;
        }
        for (Element title : XmlUtil.getChildrenByTagName((Element)documentElement, (String)"Title")) {
            String version;
            String name = title.getAttribute("name");
            if (!name.isEmpty()) {
                this.codeSystem.setName(name);
                this.codeSystem.setTitle(name);
            }
            if (!(version = title.getAttribute("version")).isEmpty()) {
                this.codeSystemVersion.setCodeSystemVersionId(version);
            }
            this.codeSystem.setDescription(title.getTextContent());
        }
        HashMap<String, TermConcept> conceptMap = new HashMap<String, TermConcept>();
        for (Element aClass : XmlUtil.getChildrenByTagName((Element)documentElement, (String)"Class")) {
            String code = aClass.getAttribute("code");
            if (code.isEmpty()) continue;
            boolean rootConcept = XmlUtil.getChildrenByTagName((Element)aClass, (String)"SuperClass").isEmpty();
            TermConcept termConcept = rootConcept ? this.codeSystemVersion.addConcept() : new TermConcept();
            termConcept.setCode(code);
            for (Element rubric : XmlUtil.getChildrenByTagName((Element)aClass, (String)"Rubric")) {
                String textContent;
                String kind = rubric.getAttribute("kind");
                Optional firstLabel = XmlUtil.getChildrenByTagName((Element)rubric, (String)"Label").stream().findFirst();
                if (!firstLabel.isPresent() || (textContent = ((Element)firstLabel.get()).getTextContent()) == null || textContent.isEmpty()) continue;
                textContent = textContent.replace("\n", "").replace("\r", "").replace("\t", "");
                if (kind.equals("preferred")) {
                    termConcept.setDisplay(textContent);
                    continue;
                }
                termConcept.addPropertyString(kind, textContent);
            }
            for (Element superClass : XmlUtil.getChildrenByTagName((Element)aClass, (String)"SuperClass")) {
                TermConcept parent = (TermConcept)conceptMap.get(superClass.getAttribute("code"));
                if (parent == null) continue;
                parent.addChild(termConcept, TermConceptParentChildLink.RelationshipTypeEnum.ISA);
            }
            conceptMap.put(code, termConcept);
        }
        this.conceptCount = conceptMap.size();
    }

    public int getConceptCount() {
        return this.conceptCount;
    }
}

